/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.VaultMod;
import iskallia.vault.command.Command;
import iskallia.vault.command.CrystalCommand;
import iskallia.vault.core.data.compound.IntList;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.stat.DiscoveredRoomStat;
import iskallia.vault.core.vault.stat.DiscoveredTunnelStat;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.ArchitectVaultLayout;
import iskallia.vault.core.world.generator.layout.ClassicCircleLayout;
import iskallia.vault.core.world.generator.layout.ClassicInfiniteLayout;
import iskallia.vault.core.world.generator.layout.ClassicPolygonLayout;
import iskallia.vault.core.world.generator.layout.ClassicSpiralLayout;
import iskallia.vault.core.world.generator.layout.DIYVaultLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.world.data.ServerVaults;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class VaultCommand
extends Command {
    @Override
    public String getName() {
        return "vault";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"kick").executes(context -> this.kickFromVault(((CommandSourceStack)context.getSource()).m_81375_(), false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> this.kickFromVault(EntityArgument.m_91474_((CommandContext)context, (String)"player"), false))).then(Commands.m_82129_((String)"complete", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.kickFromVault(EntityArgument.m_91474_((CommandContext)context, (String)"player"), BoolArgumentType.getBool((CommandContext)context, (String)"complete"))))));
        builder.then(Commands.m_82127_((String)"addModifier").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CrystalCommand.SUGGEST_MODIFIER).then(Commands.m_82129_((String)"stackSize", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::addModifier)))));
        builder.then(Commands.m_82127_((String)"removeModifier").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CrystalCommand.SUGGEST_MODIFIER).then(Commands.m_82129_((String)"stackSize", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::removeModifier)))));
        builder.then(Commands.m_82127_((String)"discover_map").executes(this::discover));
        builder.then(Commands.m_82127_((String)"offer_companion_egg_hunt").executes(this::executeOfferCompanionEggHunt));
    }

    private boolean isPlayerInVault(ServerPlayer player) {
        return ServerVaults.getAll().stream().anyMatch(vault -> vault.getOptional(Vault.LISTENERS).map(listeners -> listeners.contains(player.m_142081_())).orElse(false));
    }

    private int addModifier(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        ResourceLocation modifier = ResourceLocationArgument.m_107011_(context, (String)"modifier");
        int stackSize = IntegerArgumentType.getInteger(context, (String)"stackSize");
        ServerLevel level = player.m_183503_();
        Object vaultModifier = VaultModifierRegistry.get(modifier);
        if (vaultModifier == null) {
            player.m_6352_((Component)new TextComponent("Modifier not found").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        if (!this.isPlayerInVault(player)) {
            player.m_6352_((Component)new TextComponent("Player is not in a vault").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        ServerVaults.get((Level)level).ifPresent(vault -> {
            Collection optionalListeners = vault.getOptional(Vault.LISTENERS).map(Listeners::getAll).orElse(Collections.emptyList());
            vault.getOptional(Vault.MODIFIERS).ifPresent(modifiers -> {
                modifiers.addModifier((VaultModifier<?>)vaultModifier, stackSize, true, JavaRandom.ofInternal(vault.get(Vault.SEED)));
                for (int i = 0; i < stackSize; ++i) {
                    Modifiers.Entry entry = modifiers.getEntries().get(modifiers.getEntries().size() - i - 1);
                    vaultModifier.onVaultAdd((VirtualWorld)level, (Vault)vault, entry.getContext().copy());
                    optionalListeners.forEach(listener -> vaultModifier.onListenerAdd((VirtualWorld)level, (Vault)vault, entry.getContext().copy(), (Listener)listener));
                }
                player.m_6352_((Component)new TextComponent("Added " + stackSize + " stacks of " + vaultModifier.getDisplayName() + " modifier").m_130940_(ChatFormatting.GREEN), player.m_142081_());
                for (Listener listener2 : vault.get(Vault.LISTENERS).getAll()) {
                    listener2.getPlayer().ifPresent(other -> {
                        if (!(listener2 instanceof Runner)) {
                            return;
                        }
                        level.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
                        other.m_5661_((Component)new TextComponent("").m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_(vaultModifier.getChatDisplayNameComponent(1)).m_7220_((Component)new TextComponent(" with commands.").m_130940_(ChatFormatting.GRAY)), false);
                    });
                }
            });
        });
        return 0;
    }

    private int removeModifier(CommandContext<CommandSourceStack> commandSourceStackCommandContext) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(commandSourceStackCommandContext, (String)"player");
        ResourceLocation modifier = ResourceLocationArgument.m_107011_(commandSourceStackCommandContext, (String)"modifier");
        int stackSize = IntegerArgumentType.getInteger(commandSourceStackCommandContext, (String)"stackSize");
        ServerLevel level = player.m_183503_();
        Object vaultModifier = VaultModifierRegistry.get(modifier);
        if (vaultModifier == null) {
            player.m_6352_((Component)new TextComponent("Modifier not found").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        if (!this.isPlayerInVault(player)) {
            player.m_6352_((Component)new TextComponent("Player is not in a vault").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        ServerVaults.get((Level)level).ifPresent(vault -> {
            Collection optionalListeners = vault.getOptional(Vault.LISTENERS).map(Listeners::getAll).orElse(Collections.emptyList());
            vault.getOptional(Vault.MODIFIERS).ifPresent(modifiers -> {
                for (int i = 0; i < stackSize; ++i) {
                    Modifiers.Entry entry = modifiers.getEntries().get(modifiers.getEntries().size() - i - 1);
                    vaultModifier.onVaultRemove((VirtualWorld)level, (Vault)vault, entry.getContext().copy());
                    optionalListeners.forEach(listener -> vaultModifier.onListenerRemove((VirtualWorld)level, (Vault)vault, entry.getContext().copy(), (Listener)listener));
                }
                player.m_6352_((Component)new TextComponent("Remove " + stackSize + " stacks of " + vaultModifier.getDisplayName() + " modifier").m_130940_(ChatFormatting.RED), player.m_142081_());
                for (Listener listener2 : vault.get(Vault.LISTENERS).getAll()) {
                    listener2.getPlayer().ifPresent(other -> {
                        if (!(listener2 instanceof Runner)) {
                            return;
                        }
                        level.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
                        other.m_5661_((Component)new TextComponent("").m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" removed ").m_130940_(ChatFormatting.GRAY)).m_7220_(vaultModifier.getChatDisplayNameComponent(1)).m_7220_((Component)new TextComponent(" with commands.").m_130940_(ChatFormatting.GRAY)), false);
                    });
                }
            });
        });
        return 0;
    }

    private int kickFromVault(ServerPlayer player, boolean complete) {
        if (!this.isPlayerInVault(player)) {
            player.m_6352_((Component)new TextComponent("Player is not in a vault").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        for (Vault vault : ServerVaults.getAll()) {
            vault.ifPresent(Vault.LISTENERS, listeners -> {
                if (listeners.contains(player.m_142081_())) {
                    Listener listener = listeners.get(player.m_142081_());
                    ServerVaults.getWorld(vault).ifPresent(world -> {
                        listener.ifPresent(Listener.ID, id -> vault.ifPresent(Vault.STATS, collector -> {
                            StatCollector stats = collector.get((UUID)id);
                            stats.set(StatCollector.COMPLETION, complete ? Completion.COMPLETED : Completion.BAILED);
                        }));
                        listeners.remove((VirtualWorld)((Object)((Object)world)), vault, listener);
                    });
                }
            });
        }
        return 1;
    }

    private int discover(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel level = player.m_183503_();
        Vault vault = ServerVaults.get((Level)level).orElse(null);
        if (vault == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Not in a vault."));
            return 0;
        }
        if (!vault.get(Vault.LISTENERS).contains(player.m_142081_())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("You are not in this vault."));
            return 0;
        }
        this.revealMapForAll(vault);
        this.sendFeedback(context, "Discovered full vault map for all players.", true);
        return 1;
    }

    private void revealMapForAll(Vault vault) {
        VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (!(generator instanceof GridGenerator)) {
            VaultMod.LOGGER.info("Vault generator is not grid based; cannot discover map.");
            return;
        }
        GridGenerator gridGenerator = (GridGenerator)generator;
        GridLayout gridLayout = gridGenerator.get(GridGenerator.LAYOUT);
        if (!(gridLayout instanceof VaultGridLayout)) {
            VaultMod.LOGGER.info("Vault layout is not grid based; cannot discover map.");
            return;
        }
        VaultGridLayout layout = (VaultGridLayout)gridLayout;
        int cellX = gridGenerator.get(GridGenerator.CELL_X);
        int cellZ = gridGenerator.get(GridGenerator.CELL_Z);
        int radius = this.getVaultRadius(layout, vault);
        Collection<Listener> listeners = vault.get(Vault.LISTENERS).getAll();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                RegionPos region = RegionPos.of(x, z, cellX, cellZ);
                VaultLayout.PieceType type = layout.getType(vault, region);
                if (type == VaultLayout.PieceType.NONE) continue;
                if (type == VaultLayout.PieceType.ROOM || type.isStart()) {
                    ChunkRandom random = ChunkRandom.any();
                    random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
                    PlacementSettings settings = new PlacementSettings(new ProcessorContext(vault, random)).setFlags(272);
                    Template template = layout.getAt(vault, region, random, settings);
                    if (template instanceof JigsawTemplate) {
                        JigsawTemplate jigsaw = (JigsawTemplate)template;
                        template = jigsaw.getRoot();
                    }
                    ResourceLocation id = template.getKey().getId();
                    for (Listener listener : listeners) {
                        BlockPos key;
                        StatCollector stats = vault.get(Vault.STATS).get(listener.get(Listener.ID));
                        DiscoveredRoomStat rooms = stats.get(StatCollector.ROOMS_DISCOVERED);
                        if (rooms.containsKey(key = new BlockPos(region.m_123341_(), 0, region.m_123343_()))) continue;
                        rooms.put(key, id);
                    }
                    continue;
                }
                if (type != VaultLayout.PieceType.TUNNEL_X && type != VaultLayout.PieceType.TUNNEL_Z) continue;
                ResourceLocation icon = type == VaultLayout.PieceType.TUNNEL_X ? VaultMod.id("gui/map/tunnel_x") : VaultMod.id("gui/map/tunnel_z");
                for (Listener listener : listeners) {
                    BlockPos key;
                    StatCollector stats = vault.get(Vault.STATS).get(listener.get(Listener.ID));
                    DiscoveredTunnelStat tunnels = stats.get(StatCollector.DISCOVERED_TUNNELS);
                    if (tunnels.containsKey(key = new BlockPos(region.m_123341_(), 0, region.m_123343_()))) continue;
                    tunnels.put(key, icon);
                }
            }
        }
    }

    private int getVaultRadius(VaultGridLayout layout, Vault vault) {
        ClassicPolygonLayout polygon;
        ClassicCircleLayout circle;
        ClassicSpiralLayout spiral;
        if (layout instanceof ClassicSpiralLayout && (spiral = (ClassicSpiralLayout)layout).has(ClassicSpiralLayout.HALF_LENGTH)) {
            int unit = spiral.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return spiral.get(ClassicSpiralLayout.HALF_LENGTH) * unit;
        }
        if (layout instanceof ClassicCircleLayout && (circle = (ClassicCircleLayout)layout).has(ClassicCircleLayout.RADIUS)) {
            int unit = circle.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return circle.get(ClassicCircleLayout.RADIUS) * unit;
        }
        if (layout instanceof ClassicPolygonLayout && (polygon = (ClassicPolygonLayout)layout).has(ClassicPolygonLayout.VERTICES)) {
            IntList verts = polygon.get(ClassicPolygonLayout.VERTICES);
            int max = 0;
            for (Integer vert : verts) {
                max = Math.max(max, Math.abs(vert));
            }
            int unit = polygon.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return max * unit;
        }
        if (layout instanceof ArchitectVaultLayout) {
            ArchitectVaultLayout arch = (ArchitectVaultLayout)layout;
            int count = arch.get(ArchitectVaultLayout.ROOM_ENTRIES).getTotalCount();
            int unit = arch.get(ArchitectVaultLayout.TUNNEL_SPAN) + 1;
            return this.spiralRadius(count, unit);
        }
        if (layout instanceof DIYVaultLayout) {
            DIYVaultLayout diy = (DIYVaultLayout)layout;
            int count = diy.get(DIYVaultLayout.ROOM_ENTRIES).getTotalCount();
            int unit = diy.get(DIYVaultLayout.TUNNEL_SPAN) + 1;
            return this.spiralRadius(count, unit);
        }
        if (layout instanceof ClassicInfiniteLayout) {
            ClassicInfiniteLayout infinite = (ClassicInfiniteLayout)layout;
            int unit = infinite.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return 6 * unit;
        }
        return 6;
    }

    private int spiralRadius(int rooms, int unit) {
        double r = Math.ceil((Math.sqrt(rooms + 1) - 1.0) / 2.0);
        return (int)r * unit;
    }

    private int executeOfferCompanionEggHunt(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel level = player.m_183503_();
        Vault vault = ServerVaults.get((Level)level).orElse(null);
        if (vault == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Not in a vault."));
            return 0;
        }
        if (!vault.get(Vault.LISTENERS).contains(player.m_142081_())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("You are not in this vault."));
            return 0;
        }
        vault.getOptional(Vault.COMPANION_EGG_HUNT).ifPresent(hunt -> {
            if (level instanceof VirtualWorld) {
                VirtualWorld virtualWorld = (VirtualWorld)level;
                hunt.offerCompanionEgg(player, vault, virtualWorld);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Offered companion egg to ").m_7220_(player.m_5446_()), true);
            }
        });
        return 1;
    }
}

