/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.world.data.PlayerReputationData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.command.EnumArgument;

public class VaultLevelCommand
extends Command {
    @Override
    public String getName() {
        return "vault_level";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"add_exp").then(Commands.m_82129_((String)"exp", (ArgumentType)IntegerArgumentType.integer()).executes(this::addExp)));
        builder.then(Commands.m_82127_((String)"set_rep").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"god", (ArgumentType)EnumArgument.enumArgument(VaultGod.class)).executes(this::setRep))));
        builder.then(Commands.m_82127_((String)"set_level").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(this::setLevel)));
        builder.then(Commands.m_82127_((String)"add_skill_points").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(this::addSkillPoints)));
        builder.then(Commands.m_82127_((String)"add_prestige_points").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(this::addPrestigePoints)));
        builder.then(Commands.m_82127_((String)"add_knowledge_points").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(this::addKnowledgePoints)));
        builder.then(Commands.m_82127_((String)"add_expertise_points").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::addExpertisePoints))).executes(this::addExpertisePoints)));
        builder.then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::getPlayerStats)));
    }

    private int getPlayerStats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        PlayerVaultStatsData data = PlayerVaultStatsData.get(player.m_183503_());
        PlayerVaultStats vaultStats = data.getVaultStats((Player)player);
        int vaultLevel = vaultStats.getVaultLevel();
        int exp = vaultStats.getExp();
        int spentSkillPoints = vaultStats.getTotalSpentSkillPoints();
        int spentKnowledgePoints = vaultStats.getTotalSpentKnowledgePoints();
        int spentExpertisePoints = vaultStats.getTotalSpentExpertisePoints();
        int unspentSkillPoints = vaultStats.getUnspentSkillPoints();
        int unspentKnowledgePoints = vaultStats.getUnspentKnowledgePoints();
        int unspentExpertisePoints = vaultStats.getUnspentExpertisePoints();
        ArrayList<TextComponent> messages = new ArrayList<TextComponent>();
        messages.add(new TextComponent("======================================"));
        messages.add(new TextComponent(String.format("Player Stats: %s%s", ChatFormatting.DARK_AQUA, player.m_5446_().getString())));
        messages.add(new TextComponent(String.format("Vault Level: %s%s", ChatFormatting.YELLOW, vaultLevel)));
        messages.add(new TextComponent(String.format("Vault Exp: %s%s", ChatFormatting.YELLOW, exp)));
        messages.add(new TextComponent(String.format("Skill Points: %s%s%s used / %s%s%s available", ChatFormatting.YELLOW, spentSkillPoints, ChatFormatting.RESET, ChatFormatting.YELLOW, unspentSkillPoints, ChatFormatting.RESET)));
        messages.add(new TextComponent(String.format("Knowledge Points: %s%s%s used / %s%s%s available", ChatFormatting.AQUA, spentKnowledgePoints, ChatFormatting.RESET, ChatFormatting.AQUA, unspentKnowledgePoints, ChatFormatting.RESET)));
        messages.add(new TextComponent(String.format("Expertise Points: %s%s%s used / %s%s%s available", ChatFormatting.LIGHT_PURPLE, spentExpertisePoints, ChatFormatting.RESET, ChatFormatting.LIGHT_PURPLE, unspentExpertisePoints, ChatFormatting.RESET)));
        messages.add(new TextComponent("======================================"));
        messages.forEach(message -> ((CommandSourceStack)context.getSource()).m_81354_((Component)message, true));
        return 0;
    }

    private int setLevel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        PlayerVaultStatsData.get(source.m_81372_()).setVaultLevel(player, level);
        player.refreshTabListName();
        return 0;
    }

    private int setRep(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        VaultGod god = (VaultGod)((Object)context.getArgument("god", VaultGod.class));
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerReputationData.addReputation(player.m_142081_(), god, level);
        player.refreshTabListName();
        return 0;
    }

    private int addExp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int exp = IntegerArgumentType.getInteger(context, (String)"exp");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerVaultStatsData.get(source.m_81372_()).addVaultExp(source.m_81375_(), exp);
        return 0;
    }

    private int addSkillPoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        PlayerVaultStatsData.get(source.m_81372_()).addSkillPoints(source.m_81375_(), amount);
        return 0;
    }

    private int addPrestigePoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        PlayerVaultStatsData.get(source.m_81372_()).addPrestigePoints(source.m_81375_(), amount);
        return 0;
    }

    private int addKnowledgePoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        PlayerVaultStatsData.get(source.m_81372_()).addKnowledgePoints(source.m_81375_(), amount);
        return 0;
    }

    private int addExpertisePoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            PlayerVaultStatsData.get(source.m_81372_()).addExpertisePoints(player, amount);
        }
        catch (IllegalArgumentException ignored) {
            PlayerVaultStatsData.get(source.m_81372_()).addExpertisePoints(source.m_81375_(), amount);
        }
        return 0;
    }
}

