/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.skill.ability.effect.ArcaneAbility;
import iskallia.vault.skill.ability.effect.ArcaneRailAbility;
import iskallia.vault.skill.ability.effect.DashAbility;
import iskallia.vault.skill.ability.effect.DashDamageAbility;
import iskallia.vault.skill.ability.effect.DashWarpAbility;
import iskallia.vault.skill.ability.effect.EmpowerAbility;
import iskallia.vault.skill.ability.effect.EmpowerIceArmourAbility;
import iskallia.vault.skill.ability.effect.EmpowerSlownessAuraAbility;
import iskallia.vault.skill.ability.effect.ExecuteAbility;
import iskallia.vault.skill.ability.effect.FarmerAbility;
import iskallia.vault.skill.ability.effect.FarmerAnimalAbility;
import iskallia.vault.skill.ability.effect.FarmerCactusAbility;
import iskallia.vault.skill.ability.effect.FarmerMelonAbility;
import iskallia.vault.skill.ability.effect.GhostWalkAbility;
import iskallia.vault.skill.ability.effect.GhostWalkSpiritAbility;
import iskallia.vault.skill.ability.effect.HealAbility;
import iskallia.vault.skill.ability.effect.HealEffectAbility;
import iskallia.vault.skill.ability.effect.HealGroupAbility;
import iskallia.vault.skill.ability.effect.ImplodeAbility;
import iskallia.vault.skill.ability.effect.JavelinAbility;
import iskallia.vault.skill.ability.effect.JavelinPiercingAbility;
import iskallia.vault.skill.ability.effect.JavelinScatterAbility;
import iskallia.vault.skill.ability.effect.JavelinSightAbility;
import iskallia.vault.skill.ability.effect.LifeTapAbility;
import iskallia.vault.skill.ability.effect.ManaShieldAbility;
import iskallia.vault.skill.ability.effect.MegaJumpAbility;
import iskallia.vault.skill.ability.effect.MegaJumpBreakDownAbility;
import iskallia.vault.skill.ability.effect.MegaJumpBreakUpAbility;
import iskallia.vault.skill.ability.effect.NovaAbility;
import iskallia.vault.skill.ability.effect.NovaDotAbility;
import iskallia.vault.skill.ability.effect.NovaSpeedAbility;
import iskallia.vault.skill.ability.effect.RampageAbility;
import iskallia.vault.skill.ability.effect.RampageChainAbility;
import iskallia.vault.skill.ability.effect.RampageLeechAbility;
import iskallia.vault.skill.ability.effect.ShellAbility;
import iskallia.vault.skill.ability.effect.ShellPorcupineAbility;
import iskallia.vault.skill.ability.effect.ShellQuillAbility;
import iskallia.vault.skill.ability.effect.ShieldBashAbility;
import iskallia.vault.skill.ability.effect.SmiteAbility;
import iskallia.vault.skill.ability.effect.SmiteArchonAbility;
import iskallia.vault.skill.ability.effect.SmiteThunderstormAbility;
import iskallia.vault.skill.ability.effect.StonefallAbility;
import iskallia.vault.skill.ability.effect.StonefallColdAbility;
import iskallia.vault.skill.ability.effect.StonefallSnowAbility;
import iskallia.vault.skill.ability.effect.SummonEternalAbility;
import iskallia.vault.skill.ability.effect.TauntAbility;
import iskallia.vault.skill.ability.effect.TauntCharmAbility;
import iskallia.vault.skill.ability.effect.TauntRepelAbility;
import iskallia.vault.skill.ability.effect.TotemAbility;
import iskallia.vault.skill.ability.effect.TotemManaRegenAbility;
import iskallia.vault.skill.ability.effect.TotemMobDamageAbility;
import iskallia.vault.skill.ability.effect.TotemPlayerDamageAbility;
import iskallia.vault.skill.ability.effect.VeinMinerAbility;
import iskallia.vault.skill.ability.effect.VeinMinerDurabilityAbility;
import iskallia.vault.skill.ability.effect.VeinMinerFortuneAbility;
import iskallia.vault.skill.ability.effect.VeinMinerVoidAbility;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class AbilitiesConfig
extends Config {
    private static final int DEFAULT_COLOR = TextColor.m_131268_((String)"#00FFFF").m_131265_();
    @Expose
    public AbilityTree tree;

    @Override
    public String getName() {
        return "abilities";
    }

    public Optional<AbilityTree> get() {
        return Optional.of(this.tree);
    }

    public Optional<Skill> getAbilityById(String name) {
        Optional<Skill> exact = this.tree.getForId(name);
        if (exact.isPresent()) {
            return exact;
        }
        return this.tree.skills.stream().filter(s -> s.getId().equalsIgnoreCase(name)).findFirst();
    }

    @Override
    protected void reset() {
        this.tree = new AbilityTree();
        this.tree.skills.add(AbilitiesConfig.spec("Dash", "Dash", AbilitiesConfig.tier("Dash_Base", "Dash", AbilitiesConfig.quintuple(new DashAbility(0, 1, 1, 10, 1.0f, 10))), AbilitiesConfig.tier("Dash_Damage", "Dash: Bullet", AbilitiesConfig.quintuple(new DashDamageAbility(0, 1, 1, 10, 1.0f, 10, 0.5f))), AbilitiesConfig.tier("Dash_Warp", "Dash: Warp", AbilitiesConfig.quintuple(new DashWarpAbility(0, 1, 1, 10, 1.0f, 1.0f)))));
        this.tree.skills.add(AbilitiesConfig.spec("Empower", "Empower", AbilitiesConfig.tier("Empower_Base", "Empower", AbilitiesConfig.quintuple(new EmpowerAbility(0, 1, 1, 10, 1.0f, 200, 0.5f))), AbilitiesConfig.tier("Empower_Ice_Armor", "Empower: Ice Armor", AbilitiesConfig.quintuple(new EmpowerIceArmourAbility(0, 1, 1, 10, 1.0f, 200, 10.0f, 0, 20, 1.0f))), AbilitiesConfig.tier("Empower_Slowness_Aura", "Empower: Slowness Aura", AbilitiesConfig.quintuple(new EmpowerSlownessAuraAbility(0, 1, 1, 10, 1.0f, 200, 10.0f, 0)))));
        this.tree.skills.add(AbilitiesConfig.spec("Execute", "Execute", AbilitiesConfig.tier("Execute_Base", "Execute", AbilitiesConfig.quintuple(new ExecuteAbility(0, 1, 1, 10, 0.5f, 200)))));
        this.tree.skills.add(AbilitiesConfig.spec("Farmer", "Farmer", AbilitiesConfig.tier("Farmer_Base", "Farmer", AbilitiesConfig.quintuple(new FarmerAbility(0, 1, 1, 10, 1.0f, 5, 10, 10))), AbilitiesConfig.tier("Farmer_Melon", "Farmer: Cultivator", AbilitiesConfig.quintuple(new FarmerMelonAbility(0, 1, 1, 10, 1.0f, 5, 10, 10))), AbilitiesConfig.tier("Farmer_Cactus", "Farmer: Gardener", AbilitiesConfig.quintuple(new FarmerCactusAbility(0, 1, 1, 10, 1.0f, 5, 10, 10))), AbilitiesConfig.tier("Farmer_Animal", "Farmer: Rancher", AbilitiesConfig.quintuple(new FarmerAnimalAbility(0, 1, 1, 10, 1.0f, 5, 10, 10, 0.5f)))));
        this.tree.skills.add(AbilitiesConfig.spec("Ghost_Walk", "Ghost Walk", AbilitiesConfig.tier("Ghost_Walk_Base", "Ghost Walk", AbilitiesConfig.quintuple(new GhostWalkAbility(0, 1, 1, 10, 1.0f, 200))), AbilitiesConfig.tier("Ghost_Walk_Spirit", "Ghost Walk: Spirit", AbilitiesConfig.quintuple(new GhostWalkSpiritAbility(0, 1, 1, 10, 1.0f, 200)))));
        this.tree.skills.add(AbilitiesConfig.spec("Heal", "Heal", AbilitiesConfig.tier("Heal_Base", "Heal", AbilitiesConfig.quintuple(new HealAbility(0, 1, 1, 10, 1.0f))), AbilitiesConfig.tier("Heal_Group", "Heal: Aid", AbilitiesConfig.quintuple(new HealGroupAbility(0, 1, 1, 10, 1.0f, 10.0f))), AbilitiesConfig.tier("Heal_Cleanse", "Heal: Cleanse", AbilitiesConfig.quintuple(new HealEffectAbility(0, 1, 1, 10, 1.0f, AbilitiesConfig.cleanseEffects(), HealEffectAbility.RemovalStrategy.DEFINED_ONLY)))));
        this.tree.skills.add(AbilitiesConfig.spec("Hunter", "Hunter", AbilitiesConfig.tier("Hunter_Base", "Hunter", AbilitiesConfig.quintuple(new HunterAbility(0, 1, 1, 10, 1.0f, 10.0, DEFAULT_COLOR, 200, List.of(TilePredicate.of("the_vault:wooden_chest{Hidden:0b}", true).orElseThrow())))), AbilitiesConfig.tier("Hunter_Blocks", "Hunter: Observer", AbilitiesConfig.quintuple(new HunterAbility(0, 1, 1, 10, 1.0f, 10.0, DEFAULT_COLOR, 200, AbilitiesConfig.observerKeys()))), AbilitiesConfig.tier("Hunter_Wooden", "Hunter: Wooden", AbilitiesConfig.quintuple(new HunterAbility(0, 1, 1, 10, 1.0f, 10.0, DEFAULT_COLOR, 200, List.of(TilePredicate.of("the_vault:wooden_chest{Hidden:0b}", true).orElseThrow())))), AbilitiesConfig.tier("Hunter_Gilded", "Hunter: Gilded", AbilitiesConfig.quintuple(new HunterAbility(0, 1, 1, 10, 1.0f, 10.0, DEFAULT_COLOR, 200, List.of(TilePredicate.of("the_vault:gilded_chest{Hidden:0b}", true).orElseThrow())))), AbilitiesConfig.tier("Hunter_Living", "Hunter: Living", AbilitiesConfig.quintuple(new HunterAbility(0, 1, 1, 10, 1.0f, 10.0, DEFAULT_COLOR, 200, List.of(TilePredicate.of("the_vault:living_chest{Hidden:0b}", true).orElseThrow())))), AbilitiesConfig.tier("Hunter_Ornate", "Hunter: Ornate", AbilitiesConfig.quintuple(new HunterAbility(0, 1, 1, 10, 1.0f, 10.0, DEFAULT_COLOR, 200, List.of(TilePredicate.of("the_vault:ornate_chest{Hidden:0b}", true).orElseThrow())))), AbilitiesConfig.tier("Hunter_Coins", "Hunter: Coins", AbilitiesConfig.quintuple(new HunterAbility(0, 1, 1, 10, 1.0f, 10.0, DEFAULT_COLOR, 200, List.of(TilePredicate.of("the_vault:coin_pile{Hidden:0b}", true).orElseThrow()))))));
        this.tree.skills.add(AbilitiesConfig.spec("Javelin", "Javelin", AbilitiesConfig.tier("Javelin_Base", "Javelin", AbilitiesConfig.quintuple(new JavelinAbility(0, 1, 1, 10, 1.0f, 0.5f, 1.0f, 1.0f))), AbilitiesConfig.tier("Javelin_Piercing", "Javelin: Piercing", AbilitiesConfig.quintuple(new JavelinPiercingAbility(0, 1, 1, 10, 1.0f, 0.5f, 1.0f, 1))), AbilitiesConfig.tier("Javelin_Scatter", "Javelin: Scatter", AbilitiesConfig.quintuple(new JavelinScatterAbility(0, 1, 1, 10, 1.0f, 0.5f, 1.0f, 1, 1, 1))), AbilitiesConfig.tier("Javelin_Sight", "Javelin: Sight", AbilitiesConfig.quintuple(new JavelinSightAbility(0, 1, 1, 10, 1.0f, 0.5f, 1.0f, 10.0f, 1)))));
        this.tree.skills.add(AbilitiesConfig.spec("Mana_Shield", "Mana Shield", AbilitiesConfig.tier("Mana_Shield_Base", "Mana Shield", AbilitiesConfig.quintuple(new ManaShieldAbility(0, 1, 1, 1200, 10, 60, 20))), AbilitiesConfig.tier("Mana_Shield_Retribution", "Mana Shield: Retribution", AbilitiesConfig.quintuple(new ShieldBashAbility(0, 1, 1, 1200, 10, 10.0f, 0.5f)))));
        this.tree.skills.add(AbilitiesConfig.spec("Mega_Jump", "Mega Jump", AbilitiesConfig.tier("Mega_Jump_Base", "Mega Jump", AbilitiesConfig.quintuple(new MegaJumpAbility(0, 1, 1, 10, 1.0f, 10))), AbilitiesConfig.tier("Mega_Jump_Break_Up", "Mega Jump: Drill", AbilitiesConfig.quintuple(new MegaJumpBreakUpAbility(0, 1, 1, 10, 1.0f, 10))), AbilitiesConfig.tier("Mega_Jump_Break_Down", "Mega Jump: Dig", AbilitiesConfig.quintuple(new MegaJumpBreakDownAbility(0, 1, 1, 10, 1.0f, 3, 3)))));
        this.tree.skills.add(AbilitiesConfig.spec("Nova", "Nova", AbilitiesConfig.tier("Nova_Base", "Nova", AbilitiesConfig.quintuple(new NovaAbility(0, 1, 1, 10, 1.0f, 10.0f, 0.5f, 0.5f))), AbilitiesConfig.tier("Nova_Slow", "Nova: Frost", AbilitiesConfig.quintuple(new NovaSpeedAbility(0, 1, 1, 10, 1.0f, 10.0f, 0.5f, 0.5f, 200, 0, 20))), AbilitiesConfig.tier("Nova_Dot", "Nova: Poison", AbilitiesConfig.quintuple(new NovaDotAbility(0, 1, 1, 10, 1.0f, 10.0f, 0.5f, 0.5f, 200)))));
        this.tree.skills.add(AbilitiesConfig.spec("Rampage", "Rampage", AbilitiesConfig.tier("Rampage_Base", "Rampage", AbilitiesConfig.quintuple(new RampageAbility(0, 1, 1, 10, 1.0f, 0.5f))), AbilitiesConfig.tier("Rampage_Leech", "Rampage: Vampire", AbilitiesConfig.quintuple(new RampageLeechAbility(0, 1, 1, 10, 1.0f, 0.5f, 0.5f))), AbilitiesConfig.tier("Rampage_Chain", "Rampage: Chain", AbilitiesConfig.quintuple(new RampageChainAbility(0, 1, 1, 10, 1.0f, 0.5f, 5)))));
        this.tree.skills.add(AbilitiesConfig.spec("Shell", "Shell", AbilitiesConfig.tier("Shell_Base", "Shell", AbilitiesConfig.quintuple(new ShellAbility(0, 1, 1, 10, 1.0f))), AbilitiesConfig.tier("Shell_Porcupine", "Shell: Porcupine", AbilitiesConfig.quintuple(new ShellPorcupineAbility(0, 1, 1, 10, 1.0f, 0.5f, 0.5f, 5.0f))), AbilitiesConfig.tier("Shell_Quill", "Shell: Quill", AbilitiesConfig.quintuple(new ShellQuillAbility(0, 1, 1, 10, 1.0f, 0.5f, 0.5f, 5.0f, 3)))));
        this.tree.skills.add(AbilitiesConfig.spec("Stonefall", "Stonefall", AbilitiesConfig.tier("Stonefall_Base", "Stonefall", AbilitiesConfig.quintuple(new StonefallAbility(0, 1, 1, 10, 1.0f, 200, 0.5f, 10.0f, 0.5f))), AbilitiesConfig.tier("Stonefall_Snow", "Stonefall: Surefoot", AbilitiesConfig.quintuple(new StonefallSnowAbility(0, 1, 1, 10, 1.0f, 200, 0.5f, 10.0f, 0.5f, 0.5f))), AbilitiesConfig.tier("Stonefall_Cold", "Stonefall: Coldsnap", AbilitiesConfig.quintuple(new StonefallColdAbility(0, 1, 1, 10, 1.0f, 200, 0.5f, 10.0f, 0.5f, 0, 200, 4)))));
        this.tree.skills.add(AbilitiesConfig.spec("Summon_Eternal", "Summon Eternal", AbilitiesConfig.tier("Summon_Eternal_Base", "Summon Eternal", AbilitiesConfig.quintuple(new SummonEternalAbility(0, 1, 1, 10, 1.0f, 1, 200, 0.5f, false)))));
        this.tree.skills.add(AbilitiesConfig.spec("Taunt", "Taunt", AbilitiesConfig.tier("Taunt_Base", "Taunt", AbilitiesConfig.quintuple(new TauntAbility(0, 1, 1, 10, 1.0f, 10.0f, 200, 1))), AbilitiesConfig.tier("Taunt_Repel", "Taunt: Fear", AbilitiesConfig.quintuple(new TauntRepelAbility(0, 1, 1, 10, 1.0f, 10.0f, 200, 10.0f))), AbilitiesConfig.tier("Taunt_Charm", "Taunt: Charm", AbilitiesConfig.quintuple(new TauntCharmAbility(0, 1, 1, 10, 1.0f, 10.0f, 200, 3, 0.6f, 0.025f)))));
        this.tree.skills.add(AbilitiesConfig.spec("Totem", "Totem", AbilitiesConfig.tier("Totem_Base", "Totem: Rejuvenation", AbilitiesConfig.quintuple(new TotemAbility(0, 1, 1, 10, 1.0f, 200, 10.0f, 1.0f))), AbilitiesConfig.tier("Totem_Player_Damage", "Totem: Wrath", AbilitiesConfig.quintuple(new TotemPlayerDamageAbility(0, 1, 1, 10, 1.0f, 200, 10.0f, 0.5f))), AbilitiesConfig.tier("Totem_Mana_Regen", "Totem: Spirit", AbilitiesConfig.quintuple(new TotemManaRegenAbility(0, 1, 1, 10, 1.0f, 200, 10.0f, 0.5f))), AbilitiesConfig.tier("Totem_Mob_Damage", "Totem: Hatred", AbilitiesConfig.quintuple(new TotemMobDamageAbility(0, 1, 1, 10, 1.0f, 200, 10.0f, 0.5f, 20)))));
        this.tree.skills.add(AbilitiesConfig.spec("Vein_Miner", "Vein Miner", AbilitiesConfig.tier("Vein_Miner_Base", "Vein Miner", AbilitiesConfig.quintuple(new VeinMinerAbility(0, 1, 1, 10, 16))), AbilitiesConfig.tier("Vein_Miner_Fortune", "Vein Miner: Fortune", AbilitiesConfig.quintuple(new VeinMinerFortuneAbility(0, 1, 1, 10, 16, 1))), AbilitiesConfig.tier("Vein_Miner_Durability", "Vein Miner: Finesse", AbilitiesConfig.quintuple(new VeinMinerDurabilityAbility(0, 1, 1, 10, 16, 1))), AbilitiesConfig.tier("Vein_Miner_Void", "Vein Miner: Void", AbilitiesConfig.quintuple(new VeinMinerVoidAbility(0, 1, 1, 10, 16)))));
        this.tree.skills.add(AbilitiesConfig.spec("Smite", "Smite", AbilitiesConfig.tier("Smite_Base", "Smite", AbilitiesConfig.quintuple(new SmiteAbility(0, 1, 1, 10, 1.0f, 0.5f, 10, 15.0f, 20.0f, -1864448, 5.0f))), AbilitiesConfig.tier("Smite_Archon", "Smite: Archon", AbilitiesConfig.quintuple(new SmiteArchonAbility(0, 1, 1, 10, 1.0f, 0.5f, 10, 15.0f, 20.0f, -1864448, 5.0f, 0.0f))), AbilitiesConfig.tier("Smite_Thunderstorm", "Smite: Thunderstorm", AbilitiesConfig.quintuple(new SmiteThunderstormAbility(0, 1, 1, 10, 1.0f, 0.5f, 10, 15.0f, 20.0f, -1864448, 5.0f)))));
        this.tree.skills.add(AbilitiesConfig.spec("Arcane", "Arcane", AbilitiesConfig.tier("Arcane_Base", "Arcane", AbilitiesConfig.quintuple(new ArcaneAbility(0, 1, 1, 10, 1.0f, 0.5f, 10.0f))), AbilitiesConfig.tier("Arcane_Rail", "Arcane: Rail", AbilitiesConfig.quintuple(new ArcaneRailAbility(0, 1, 1, 10, 1.0f, 0.3f, 1.0f)))));
        this.tree.skills.add(AbilitiesConfig.spec("Implode", "Implode", AbilitiesConfig.tier("Implode_Base", "Implode", AbilitiesConfig.quintuple(new ImplodeAbility(0, 1, 1, 10, 1.0f, 5.0f, 0.5f))), AbilitiesConfig.tier("Implode_Life_Tap", "Implode: Life Tap", AbilitiesConfig.quintuple(new LifeTapAbility(0, 1, 1, 10, 5.0f, 0.8f, 10.0)))));
    }

    private static LearnableSkill[] quintuple(LearnableSkill skill) {
        return new LearnableSkill[]{skill, (LearnableSkill)skill.copy(), (LearnableSkill)skill.copy(), (LearnableSkill)skill.copy(), (LearnableSkill)skill.copy()};
    }

    private static TieredSkill tier(String id, String name, LearnableSkill ... skill) {
        return AbilitiesConfig.setIdAndName(id, name, new TieredSkill(0, 1, 1, Stream.of(skill)));
    }

    private static SpecializedSkill spec(String id, String name, LearnableSkill ... skill) {
        return AbilitiesConfig.setIdAndName(id, name, new SpecializedSkill(0, 1, 1, Stream.of(skill)));
    }

    private static <S extends Skill> S setIdAndName(String id, String name, S skill) {
        skill.setId(id);
        skill.setName(name);
        return skill;
    }

    private static List<MobEffect> cleanseEffects() {
        return ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(effect -> effect.m_19483_() == MobEffectCategory.HARMFUL).toList();
    }

    private static List<TilePredicate> observerKeys() {
        return List.of(TilePredicate.of("the_vault:obelisk", true).orElseThrow(), TilePredicate.of("the_vault:scavenger_altar", true).orElseThrow(), TilePredicate.of("the_vault:monolith", true).orElseThrow(), TilePredicate.of("the_vault:lodestone", true).orElseThrow(), TilePredicate.of("the_vault:crake_pedestal", true).orElseThrow());
    }
}

