/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.init.ModConfigs;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AbilitiesDescriptionsConfig
extends Config {
    @Expose
    private TreeMap<String, DescriptionData> data;

    @Override
    public String getName() {
        return "abilities_descriptions";
    }

    @Override
    public <T extends Config> T readConfig() {
        AbilitiesDescriptionsConfig config = (AbilitiesDescriptionsConfig)super.readConfig();
        config.data.values().stream().map(descriptionData -> descriptionData.description).forEach(jsonElement -> ModConfigs.COLORS.replaceColorStrings((JsonElement)jsonElement));
        return (T)config;
    }

    public MutableComponent getDescriptionFor(String skillName) {
        DescriptionData data = this.data.get(skillName);
        if (data == null) {
            return Component.Serializer.m_130714_((String)("[{text:'No description for ', color:'#192022'},{text: '" + skillName + "', color: '#fcf5c5'},{text: ', yet', color: '#192022'}]"));
        }
        return Component.Serializer.m_130691_((JsonElement)data.description);
    }

    public List<String> getCurrent(String skillName) {
        DescriptionData data = this.data.get(skillName);
        if (data == null) {
            return Collections.emptyList();
        }
        return data.current;
    }

    public List<String> getNext(String skillName) {
        DescriptionData data = this.data.get(skillName);
        if (data == null) {
            return Collections.emptyList();
        }
        return data.next;
    }

    @Override
    protected void reset() {
        this.data = new TreeMap();
        this.data.put("Dash_Base", new DescriptionData(this.defaultDescription("Dash_Base"), List.of("cooldown", "manaCost", "distance"), List.of("level", "cooldown", "manaCost", "distance")));
        this.data.put("Dash_Damage", new DescriptionData(this.defaultDescription("Dash_Damage"), List.of("cooldown", "manaCost", "distance", "damage"), List.of("level", "cooldown", "manaCost", "distance", "damage")));
        this.data.put("Dash_Warp", new DescriptionData(this.defaultDescription("Dash_Warp"), List.of("cooldown", "manaCost", "force"), List.of("level", "cooldown", "manaCost", "force")));
        this.data.put("Farmer_Base", new DescriptionData(this.defaultDescription("Farmer_Base"), List.of("cooldown", "manaCost", "delay", "rangeHorizontal", "rangeVertical"), List.of("level", "cooldown", "manaCost", "delay", "rangeHorizontal", "rangeVertical")));
        this.data.put("Farmer_Cactus", new DescriptionData(this.defaultDescription("Farmer_Cactus"), List.of("cooldown", "manaCost", "delay", "rangeHorizontal", "rangeVertical"), List.of("level", "cooldown", "manaCost", "delay", "rangeHorizontal", "rangeVertical")));
        this.data.put("Farmer_Melon", new DescriptionData(this.defaultDescription("Farmer_Melon"), List.of("cooldown", "manaCost", "delay", "rangeHorizontal", "rangeVertical"), List.of("level", "cooldown", "manaCost", "delay", "rangeHorizontal", "rangeVertical")));
        this.data.put("Farmer_Animal", new DescriptionData(this.defaultDescription("Farmer_Animal"), List.of("cooldown", "manaCost", "delay", "rangeHorizontal", "rangeVertical", "chance"), List.of("level", "cooldown", "manaCost", "delay", "rangeHorizontal", "rangeVertical", "chance")));
        this.data.put("Ghost_Walk_Base", new DescriptionData(this.defaultDescription("Ghost_Walk_Base"), List.of("cooldown", "manaCost", "duration"), List.of("level", "cooldown", "manaCost", "duration")));
        this.data.put("Ghost Walk_Spirit_Walk", new DescriptionData(this.defaultDescription("Ghost Walk_Spirit_Walk"), List.of("cooldown", "manaCost", "duration"), List.of("level", "cooldown", "manaCost", "duration")));
        this.data.put("Heal_Base", new DescriptionData(this.defaultDescription("Heal_Base"), List.of("cooldown", "manaCost", "heal"), List.of("level", "cooldown", "manaCost", "heal")));
        this.data.put("Heal_Cleanse", new DescriptionData(this.defaultDescription("Heal_Cleanse"), List.of("cooldown", "manaCost"), List.of("level", "cooldown", "manaCost")));
        this.data.put("Heal_Group", new DescriptionData(this.defaultDescription("Heal_Group"), List.of("cooldown", "manaCost", "heal", "radius"), List.of("level", "cooldown", "manaCost", "heal", "radius")));
        this.data.put("Hunter_Base", new DescriptionData(this.defaultDescription("Hunter_Base"), List.of("cooldown", "manaCost", "adjustedDuration", "radius"), List.of("level", "cooldown", "manaCost", "adjustedDuration", "radius")));
        this.data.put("Mana_Shield_Base", new DescriptionData(this.defaultDescription("Mana_Shield_Base"), List.of("cooldown", "manaCostPerSecond", "absorb"), List.of("level", "cooldown", "manaCostPerSecond", "absorb")));
        this.data.put("Implode_Base", new DescriptionData(this.defaultDescription("Implode_Base"), List.of("cooldown", "manaCostPerSecond", "damage"), List.of("level", "cooldown", "manaCostPerSecond", "damage")));
        this.data.put("Mana_Shield_Cast_Base", new DescriptionData(this.defaultDescription("Mana_Shield_Cast_Base"), List.of("cooldown", "manaCost", "duration", "healthPoints"), List.of("level", "cooldown", "manaCost", "duration", "healthPoints")));
        this.data.put("Retribution_Base", new DescriptionData(this.defaultDescription("Retribution_Base"), List.of("cooldown", "manaCost", "distance", "damage"), List.of("level", "cooldown", "manaCost", "distance", "damage")));
        this.data.put("Implode", new DescriptionData(this.defaultDescription("Implode"), List.of("cooldown", "manaCost", "radius", "damage"), List.of("level", "cooldown", "manaCost", "radius", "damage")));
        this.data.put("Retribution", new DescriptionData(this.defaultDescription("Retribution"), List.of("cooldown", "manaCost", "distance", "damage"), List.of("level", "cooldown", "manaCost", "distance", "damage")));
        this.data.put("Mega_Jump_Base", new DescriptionData(this.defaultDescription("Mega_Jump_Base"), List.of("cooldown", "manaCost", "rangeVertical"), List.of("level", "cooldown", "manaCost", "rangeVertical")));
        this.data.put("Mega Jump_Break_Up", new DescriptionData(this.defaultDescription("Mega Jump_Break_Up"), List.of("cooldown", "manaCost", "rangeVertical"), List.of("level", "cooldown", "manaCost", "rangeVertical")));
        this.data.put("Mega Jump_Break_Down", new DescriptionData(this.defaultDescription("Mega Jump_Break_Down"), List.of("cooldown", "manaCost", "rangeVertical", "radius"), List.of("level", "cooldown", "manaCost", "rangeVertical", "radius")));
        this.data.put("Nova_Base", new DescriptionData(this.defaultDescription("Nova_Base"), List.of("cooldown", "manaCost", "radius", "ability_power", "knockback"), List.of("level", "cooldown", "manaCost", "radius", "ability_power", "knockback")));
        this.data.put("Nova_Dot", new DescriptionData(this.defaultDescription("Nova_Dot"), List.of("cooldown", "manaCost", "radius", "ability_power", "adjustedDuration"), List.of("level", "cooldown", "manaCost", "radius", "ability_power", "adjustedDuration")));
        this.data.put("Nova_Speed", new DescriptionData(this.defaultDescription("Nova_Speed"), List.of("cooldown", "manaCost", "radius", "adjustedDuration", "slowness"), List.of("level", "cooldown", "manaCost", "radius", "adjustedDuration", "slowness")));
        this.data.put("Rampage_Base", new DescriptionData(this.defaultDescription("Rampage_Base"), List.of("cooldown", "manaCostPerSecond", "damage"), List.of("level", "cooldown", "manaCostPerSecond", "damage")));
        this.data.put("Rampage_Chain", new DescriptionData(this.defaultDescription("Rampage_Chain"), List.of("cooldown", "manaCostPerSecond", "chains"), List.of("level", "cooldown", "manaCostPerSecond", "chains")));
        this.data.put("Rampage_Leech", new DescriptionData(this.defaultDescription("Rampage_Leech"), List.of("cooldown", "manaCostPerSecond", "leech"), List.of("level", "cooldown", "manaCostPerSecond", "leech")));
        this.data.put("Summon_Eternal_Base", new DescriptionData(this.defaultDescription("Summon_Eternal_Base"), List.of("cooldown", "manaCost", "eternals", "duration", "ancientChance"), List.of("level", "cooldown", "manaCost", "eternals", "duration", "ancientChance")));
        this.data.put("Empower_Base", new DescriptionData(this.defaultDescription("Empower_Base"), List.of("cooldown", "manaCostPerSecond", "speed"), List.of("level", "cooldown", "manaCostPerSecond", "speed")));
        this.data.put("Empower_Ice_Armour", new DescriptionData(this.defaultDescription("Empower_Ice_Armour"), List.of("cooldown", "manaCostPerSecond", "chilled", "adjustedDuration", "additionalManaPerHit"), List.of("level", "cooldown", "manaCostPerSecond", "chilled", "adjustedDuration", "additionalManaPerHit")));
        this.data.put("Empower_Slowness_Aura", new DescriptionData(this.defaultDescription("Empower_Slowness_Aura"), List.of("cooldown", "manaCostPerSecond", "slowness", "radius"), List.of("level", "cooldown", "manaCostPerSecond", "slowness", "radius")));
        this.data.put("Taunt_Base", new DescriptionData(this.defaultDescription("Taunt_Base"), List.of("cooldown", "manaCost", "radius", "adjustedDuration"), List.of("level", "cooldown", "manaCost", "radius", "adjustedDuration")));
        this.data.put("Taunt_Repel", new DescriptionData(this.defaultDescription("Taunt_Repel"), List.of("cooldown", "manaCost", "radius", "adjustedDuration", "distance"), List.of("level", "cooldown", "manaCost", "radius", "adjustedDuration", "distance")));
        this.data.put("Taunt_Charm", new DescriptionData(this.defaultDescription("Taunt_Charm"), List.of("cooldown", "manaCost", "radius", "adjustedDuration", "maxTargets", "damage", "speed"), List.of("level", "cooldown", "manaCost", "radius", "adjustedDuration", "maxTargets", "damage", "speed")));
        this.data.put("Vein_Miner_Base", new DescriptionData(this.defaultDescription("Vein_Miner_Base"), List.of("cooldown", "blocks"), List.of("level", "cooldown", "blocks")));
        this.data.put("Vein Miner_Durability", new DescriptionData(this.defaultDescription("Vein Miner_Durability"), List.of("cooldown", "blocks", "unbreaking"), List.of("level", "cooldown", "blocks", "unbreaking")));
        this.data.put("Vein Miner_Fortune", new DescriptionData(this.defaultDescription("Vein Miner_Fortune"), List.of("cooldown", "blocks", "fortune"), List.of("level", "cooldown", "blocks", "fortune")));
        this.data.put("Vein Miner_Void", new DescriptionData(this.defaultDescription("Vein Miner_Void"), List.of("cooldown", "blocks"), List.of("level", "cooldown", "blocks")));
        this.data.put("Stonefall_Base", new DescriptionData(this.defaultDescription("Stonefall_Base"), List.of("cooldown", "manaCost", "adjustedDuration", "damageReduction", "radius", "knockback"), List.of("level", "cooldown", "manaCost", "adjustedDuration", "damageReduction", "radius", "knockback")));
        this.data.put("Stonefall_Snow", new DescriptionData(this.defaultDescription("Stonefall_Snow"), List.of("cooldown", "manaCost", "adjustedDuration", "damageReduction", "radius", "ability_power"), List.of("level", "cooldown", "manaCost", "adjustedDuration", "damageReduction", "radius", "ability_power")));
        this.data.put("Stonefall_Cold", new DescriptionData(this.defaultDescription("Stonefall_Cold"), List.of("cooldown", "manaCost", "adjustedDuration", "damageReduction", "freezeDuration", "amplifier", "radius"), List.of("level", "cooldown", "manaCost", "adjustedDuration", "damageReduction", "freezeDuration", "amplifier", "radius")));
        this.data.put("Totem_Base", new DescriptionData(this.defaultDescription("Totem_Base"), List.of("cooldown", "manaCost", "adjustedDuration", "radius", "heal"), List.of("level", "cooldown", "manaCost", "adjustedDuration", "radius", "heal")));
        this.data.put("Totem_Mob_Damage", new DescriptionData(this.defaultDescription("Totem_Mob_Damage"), List.of("cooldown", "manaCost", "adjustedDuration", "radius", "damage"), List.of("level", "cooldown", "manaCost", "adjustedDuration", "radius", "damage")));
        this.data.put("Totem_Mana_Regen", new DescriptionData(this.defaultDescription("Totem_Mob_Damage"), List.of("cooldown", "manaCost", "adjustedDuration", "radius", "manaRegen"), List.of("level", "cooldown", "manaCost", "adjustedDuration", "radius", "manaRegen")));
        this.data.put("Totem_Player_Damage", new DescriptionData(this.defaultDescription("Totem_Mob_Damage"), List.of("cooldown", "manaCost", "adjustedDuration", "radius", "damage"), List.of("level", "cooldown", "manaCost", "adjustedDuration", "radius", "damage")));
        this.data.put("Javelin_Base", new DescriptionData(this.defaultDescription("Javelin_Base"), List.of("cooldown", "manaCost", "damage", "throwPower", "knockback"), List.of("level", "cooldown", "manaCost", "damage", "throwPower", "knockback")));
        this.data.put("Javelin_Piercing", new DescriptionData(this.defaultDescription("Javelin_Piercing"), List.of("cooldown", "manaCost", "damage", "throwPower", "piercing"), List.of("level", "cooldown", "manaCost", "damage", "throwPower", "piercing")));
        this.data.put("Javelin_Scatter", new DescriptionData(this.defaultDescription("Javelin_Scatter"), List.of("cooldown", "manaCost", "damage", "throwPower", "numberOfBounces", "numberOfJavelins"), List.of("level", "cooldown", "manaCost", "damage", "throwPower", "numberOfBounces", "numberOfJavelins")));
        this.data.put("Javelin_Sight", new DescriptionData(this.defaultDescription("Javelin_Sight"), List.of("cooldown", "manaCost", "damage", "throwPower", "radius", "adjustedDuration"), List.of("level", "cooldown", "manaCost", "damage", "throwPower", "radius", "adjustedDuration")));
        this.data.put("Smite_Base", new DescriptionData(this.defaultDescription("Smite_Base"), List.of("cooldown", "manaCostPerSecond", "radius", "damage", "damageInterval", "additionalManaPerBolt"), List.of("level", "cooldown", "manaCostPerSecond", "radius", "damage", "damageInterval", "additionalManaPerBolt")));
        this.data.put("Smite_Archon", new DescriptionData(this.defaultDescription("Smite_Archon"), List.of("cooldown", "manaCostPerSecond", "radius", "damage", "damageInterval", "additionalManaPerBolt"), List.of("level", "cooldown", "manaCostPerSecond", "radius", "damage", "damageInterval", "additionalManaPerBolt")));
        this.data.put("Smite_Thunderstorm", new DescriptionData(this.defaultDescription("Smite_Thunderstorm"), List.of("cooldown", "manaCostPerSecond", "radius", "damage", "damageInterval", "additionalManaPerBolt"), List.of("level", "cooldown", "manaCostPerSecond", "radius", "damage", "damageInterval", "additionalManaPerBolt")));
        this.data.put("Shell_Base", new DescriptionData(this.defaultDescription("Shell_Base"), List.of("cooldown", "manaCostPerSecond", "additionalManaPerHit", "stunChance", "stunAmplifier", "stunDuration"), List.of("level", "cooldown", "manaCostPerSecond", "additionalManaPerHit", "stunChance", "stunAmplifier", "stunDuration")));
        this.data.put("Shell_Porcupine", new DescriptionData(this.defaultDescription("Shell_Porcupine"), List.of("cooldown", "manaCostPerSecond", "durabilityWearReduction", "damage", "additionalManaPerHit"), List.of("level", "cooldown", "manaCostPerSecond", "durabilityWearReduction", "damage", "additionalManaPerHit")));
        this.data.put("Shell_Quill", new DescriptionData(this.defaultDescription("Shell_Quill"), List.of("cooldown", "manaCostPerSecond", "durabilityWearReduction", "damage", "additionalManaPerHit", "quillCount"), List.of("level", "cooldown", "manaCostPerSecond", "durabilityWearReduction", "damage", "additionalManaPerHit", "quillCount")));
        this.data.put("Fireball_Base", new DescriptionData(this.defaultDescription("Fireball_Base"), List.of("cooldown", "manaCost", "ability_power", "radius"), List.of("level", "cooldown", "manaCost", "ability_power", "radius")));
        this.data.put("Fireball_Volley", new DescriptionData(this.defaultDescription("Fireball_Volley"), List.of("cooldown", "manaCost", "ability_power", "radius"), List.of("level", "cooldown", "manaCost", "ability_power", "radius")));
        this.data.put("Fireball_Fireshot", new DescriptionData(this.defaultDescription("Fireball_Fireshot"), List.of("cooldown", "manaCost", "ability_power"), List.of("level", "cooldown", "manaCost", "ability_power")));
        this.data.put("Storm_Arrow_Base", new DescriptionData(this.defaultDescription("Storm_Arrow_Base"), List.of("cooldown", "manaCost", "ability_power", "radius", "stormInterval"), List.of("level", "cooldown", "manaCost", "ability_power", "radius", "stormInterval")));
        this.data.put("Storm_Arrow_Blizzard", new DescriptionData(this.defaultDescription("Storm_Arrow_Blizzard"), List.of("cooldown", "manaCost", "ability_power", "radius", "stormInterval", "frostbiteChance", "frostbiteDuration", "slowDuration", "amplifier"), List.of("level", "cooldown", "manaCost", "ability_power", "radius", "stormInterval", "frostbiteChance", "frostbiteDuration", "slowDuration", "amplifier")));
        this.data.put("Battle_Cry_Base", new DescriptionData(this.defaultDescription("Battle_Cry_Base"), List.of("cooldown", "manaCost", "attackDamagePerStack", "radius", "stacksUsedPerHit", "maxStacks", "adjustedDuration"), List.of("level", "cooldown", "manaCost", "attackDamagePerStack", "radius", "stacksUsedPerHit", "maxStacks", "adjustedDuration")));
        this.data.put("Battle_Cry_Spectral_Strike", new DescriptionData(this.defaultDescription("Battle_Cry_Spectral_Strike"), List.of("cooldown", "manaCost", "abilityPowerPerStack", "radius", "stacksUsedPerHit", "maxStacks", "adjustedDuration"), List.of("level", "cooldown", "manaCost", "abilityPowerPerStack", "radius", "stacksUsedPerHit", "maxStacks", "adjustedDuration")));
        this.data.put("Battle_Cry_Lucky_Strike", new DescriptionData(this.defaultDescription("Battle_Cry_Lucky_Strike"), List.of("cooldown", "manaCost", "luckyHitPerStack", "radius", "stacksUsedPerHit", "maxStacks", "adjustedDuration"), List.of("level", "cooldown", "manaCost", "luckyHitPerStack", "radius", "stacksUsedPerHit", "maxStacks", "adjustedDuration")));
    }

    private JsonElement defaultDescription(String skillName) {
        return JsonParser.parseString((String)("[{text:'Default config description for ', color:'$text'},{text: '" + skillName + "', color: '$name'},{text: ' - please configure me!', color: '$text'}]"));
    }

    public static class DescriptionData {
        @Expose
        private final JsonElement description;
        @Expose
        private final List<String> current;
        @Expose
        private final List<String> next;

        public DescriptionData(JsonElement description, List<String> current, List<String> next) {
            this.description = description;
            this.current = current;
            this.next = next;
        }
    }
}

