/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.init.ModConfigs;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ArchetypeDescriptionsConfig
extends Config {
    private static final String NAME = "archetype_descriptions";
    @Expose
    private Map<ResourceLocation, JsonElement> descriptions;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public <T extends Config> T readConfig() {
        ArchetypeDescriptionsConfig config = (ArchetypeDescriptionsConfig)super.readConfig();
        for (JsonElement element : config.descriptions.values()) {
            ModConfigs.COLORS.replaceColorStrings(element);
        }
        return (T)config;
    }

    public MutableComponent getDescriptionFor(ResourceLocation archetypeId) {
        JsonElement element = this.descriptions.get(archetypeId);
        if (element == null) {
            return Component.Serializer.m_130714_((String)("[{text:'No description for ', color:'#192022'},{text: '" + String.valueOf(archetypeId) + "', color: '#fcf5c5'},{text: ', yet', color: '#192022'}]"));
        }
        return Component.Serializer.m_130691_((JsonElement)element);
    }

    @Override
    protected void reset() {
        this.descriptions = new HashMap<ResourceLocation, JsonElement>();
    }
}

