/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.task.BingoTask;
import iskallia.vault.task.Task;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class BingoConfig
extends Config {
    @Expose
    public Map<ResourceLocation, LevelEntryList<BingoTask>> pools;

    @Override
    public String getName() {
        return "bingo";
    }

    public Optional<BingoTask> generate(ResourceLocation pool, int level) {
        if (!this.pools.containsKey(pool)) {
            return Optional.empty();
        }
        return this.pools.get(pool).getForLevel(level).map(Task::copy);
    }

    @Override
    protected void reset() {
        this.pools = new LinkedHashMap<ResourceLocation, LevelEntryList<BingoTask>>();
    }
}

