/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.roll.IntRoll;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class CatalystConfig
extends Config {
    @Expose
    public Map<ResourceLocation, LevelEntryList<Pool>> pools;

    @Override
    public String getName() {
        return "catalyst";
    }

    @Override
    protected void reset() {
        this.pools = new LinkedHashMap<ResourceLocation, LevelEntryList<Pool>>();
        this.pools.put(VaultMod.id("craft_wooden_cascade"), new LevelEntryList<Pool>().put(new Pool(0, new WeightedList<Entry>().add(new Entry(IntRoll.ofUniform(15, 25), Arrays.asList(VaultMod.id("wooden_cascade")), 1), 1).add(new Entry(IntRoll.ofUniform(15, 25), Arrays.asList(VaultMod.id("wooden_cascade"), VaultMod.id("random_negative")), 1), 1))));
        this.pools.put(VaultMod.id("craft_coin_cascade"), new LevelEntryList<Pool>().put(new Pool(0, new WeightedList<Entry>().add(new Entry(IntRoll.ofUniform(15, 25), Arrays.asList(VaultMod.id("coin_cascade")), 1), 1).add(new Entry(IntRoll.ofUniform(15, 25), Arrays.asList(VaultMod.id("coin_cascade"), VaultMod.id("random_negative")), 1), 1))));
    }

    public Optional<CompoundTag> generate(ResourceLocation id, int level, RandomSource random) {
        return Optional.ofNullable(this.pools.get(id)).flatMap(p -> p.getForLevel(level)).flatMap(pool -> pool.pool.getRandom(random)).map(entry -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("size", entry.size.get(random));
            nbt.m_128405_("model", entry.model);
            ListTag modifiers = new ListTag();
            for (ResourceLocation modifier : entry.modifiers) {
                modifiers.add((Object)StringTag.m_129297_((String)modifier.toString()));
            }
            nbt.m_128365_("modifiers", (Tag)modifiers);
            if (entry.isSuper != null) {
                nbt.m_128379_("isSuper", entry.isSuper.booleanValue());
            }
            return nbt;
        });
    }

    public static class Pool
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final WeightedList<Entry> pool;

        public Pool(int level, WeightedList<Entry> pool) {
            this.level = level;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    public static class Entry {
        @Expose
        private final IntRoll size;
        @Expose
        private final List<ResourceLocation> modifiers;
        @Expose
        private final int model;
        @Expose
        private final Boolean isSuper;

        public Entry(IntRoll size, List<ResourceLocation> modifiers, int model) {
            this.size = size;
            this.modifiers = modifiers;
            this.model = model;
            this.isSuper = null;
        }

        public Entry(IntRoll size, List<ResourceLocation> modifiers, int model, Boolean isSuper) {
            this.size = size;
            this.modifiers = modifiers;
            this.model = model;
            this.isSuper = isSuper;
        }
    }
}

