/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.network.chat.TextColor;

public class ColorsConfig
extends Config {
    private static final TextColor MISSING_COLOR = TextColor.m_131266_((int)0xFF00AA);
    @Expose(deserialize=false)
    private final List<String> COMMENTS = List.of("// - builtin values may be edited, but not removed", "// - add / remove custom values inside the custom object", "// - custom values override builtin values");
    public static final String TEXT = "text";
    public static final String NAME = "name";
    public static final String COOLDOWN = "cooldown";
    public static final String MANA_COST = "manaCost";
    public static final String DISTANCE = "distance";
    public static final String DAMAGE = "damage";
    public static final String ABILITY_POWER = "ability_power";
    public static final String DAMAGE_REDUCTION = "damageReduction";
    public static final String LEVEL_HI = "levelHi";
    public static final String LEVEL_LO = "levelLo";
    public static final String DURATION = "duration";
    public static final String DELAY = "delay";
    public static final String RANGE = "range";
    public static final String CHANCE = "chance";
    public static final String HEAL = "heal";
    public static final String RADIUS = "radius";
    public static final String ABSORB = "absorb";
    public static final String MANA_PER_DAMAGE = "manaPerDamage";
    public static final String KNOCKBACK = "knockback";
    public static final String SLOWNESS = "slowness";
    public static final String CHILLED = "chilled";
    public static final String CHAINS = "chains";
    public static final String LEECH = "leech";
    public static final String ETERNALS = "eternals";
    public static final String RESISTANCE = "resistance";
    public static final String SPEED = "speed";
    public static final String PROJECTILE_DAMAGE_TAKEN = "projectileDamageTaken";
    public static final String BLOCKS = "blocks";
    public static final String UNBREAKING = "unbreaking";
    public static final String FORTUNE = "fortune";
    public static final String MAX_TARGETS = "maxTargets";
    public static final String FREEZE_DURATION = "freezeDuration";
    public static final String DAMAGE_INTERVAL = "damageInterval";
    public static final String PIERCING = "piercing";
    public static final String NUMBER_OF_BOUNCES = "numberOfBounces";
    public static final String NUMBER_OF_JAVELINS = "numberOfJavelins";
    public static final String THROW_POWER = "throwPower";
    public static final String AMPLIFIER = "amplifier";
    public static final String MANA_PER_BOLT = "additionalManaPerBolt";
    public static final String FORCE = "force";
    public static final String STORM_INTERVAL = "stormInterval";
    public static final String STACKS_USED_PER_HIT = "stacksUsedPerHit";
    public static final String MAX_STACKS = "maxStacks";
    public static final String LUCKY_HIT = "luckyHit";
    public static final String AREA_OF_EFFECT = "areaOfEffect";
    public static final String MAX_GLACIAL_PRISON = "maxGlacialPrison";
    public static final String GLACIAL_CHANCE = "glacialChance";
    public static final String BARRIER_POINTS = "healthPoints";
    @Expose
    private final Colors colors = new Colors();

    @Override
    public String getName() {
        return "colors";
    }

    @Override
    protected void reset() {
        this.colors.builtin.clear();
        this.colors.custom.clear();
        this.colors.builtin.put(TEXT, TextColor.m_131266_((int)1646626));
        this.colors.builtin.put(NAME, TextColor.m_131266_((int)0xFCF5C5));
        this.colors.builtin.put(COOLDOWN, TextColor.m_131266_((int)255));
        this.colors.builtin.put(MANA_COST, TextColor.m_131266_((int)65535));
        this.colors.builtin.put(DISTANCE, TextColor.m_131266_((int)15918725));
        this.colors.builtin.put(ABILITY_POWER, TextColor.m_131266_((int)16711883));
        this.colors.builtin.put(DAMAGE, TextColor.m_131266_((int)12727847));
        this.colors.builtin.put(DAMAGE_REDUCTION, TextColor.m_131266_((int)12727847));
        this.colors.builtin.put(LEVEL_HI, TextColor.m_131266_((int)65280));
        this.colors.builtin.put(LEVEL_LO, TextColor.m_131266_((int)12727847));
        this.colors.builtin.put(DURATION, TextColor.m_131266_((int)16561527));
        this.colors.builtin.put(DELAY, TextColor.m_131266_((int)16561527));
        this.colors.builtin.put(RANGE, TextColor.m_131266_((int)883257));
        this.colors.builtin.put(CHANCE, TextColor.m_131266_((int)10441724));
        this.colors.builtin.put(HEAL, TextColor.m_131266_((int)8254855));
        this.colors.builtin.put(RADIUS, TextColor.m_131266_((int)883257));
        this.colors.builtin.put(ABSORB, TextColor.m_131266_((int)9367001));
        this.colors.builtin.put(MANA_PER_DAMAGE, TextColor.m_131266_((int)65535));
        this.colors.builtin.put(KNOCKBACK, TextColor.m_131266_((int)10033226));
        this.colors.builtin.put(SLOWNESS, TextColor.m_131266_((int)2837801));
        this.colors.builtin.put(CHILLED, TextColor.m_131266_((int)5286063));
        this.colors.builtin.put(CHAINS, TextColor.m_131266_((int)2837801));
        this.colors.builtin.put(LEECH, TextColor.m_131266_((int)0xFF6E6E));
        this.colors.builtin.put(ETERNALS, TextColor.m_131266_((int)13107175));
        this.colors.builtin.put(RESISTANCE, TextColor.m_131266_((int)13487988));
        this.colors.builtin.put(SPEED, TextColor.m_131266_((int)13487988));
        this.colors.builtin.put(PROJECTILE_DAMAGE_TAKEN, TextColor.m_131266_((int)13611380));
        this.colors.builtin.put(BLOCKS, TextColor.m_131266_((int)9723192));
        this.colors.builtin.put(UNBREAKING, TextColor.m_131266_((int)0x333333));
        this.colors.builtin.put(FORTUNE, TextColor.m_131266_((int)6692771));
        this.colors.builtin.put(MAX_TARGETS, TextColor.m_131266_((int)13435035));
        this.colors.builtin.put(FREEZE_DURATION, TextColor.m_131266_((int)255));
        this.colors.builtin.put(DAMAGE_INTERVAL, TextColor.m_131266_((int)11035173));
        this.colors.builtin.put(PIERCING, TextColor.m_131266_((int)16738816));
        this.colors.builtin.put(NUMBER_OF_BOUNCES, TextColor.m_131266_((int)16749492));
        this.colors.builtin.put(NUMBER_OF_JAVELINS, TextColor.m_131266_((int)14942082));
        this.colors.builtin.put(THROW_POWER, TextColor.m_131266_((int)16743168));
        this.colors.builtin.put(AMPLIFIER, TextColor.m_131266_((int)0xFFFF9E));
        this.colors.builtin.put(MANA_PER_BOLT, TextColor.m_131266_((int)65535));
        this.colors.builtin.put(FORCE, TextColor.m_131266_((int)15918725));
        this.colors.builtin.put(STORM_INTERVAL, TextColor.m_131266_((int)15910513));
        this.colors.builtin.put(MAX_STACKS, TextColor.m_131266_((int)52084));
        this.colors.builtin.put(STACKS_USED_PER_HIT, TextColor.m_131266_((int)13748480));
        this.colors.builtin.put(LUCKY_HIT, TextColor.m_131266_((int)1308067));
        this.colors.builtin.put(AREA_OF_EFFECT, TextColor.m_131266_((int)15319925));
        this.colors.builtin.put(MAX_GLACIAL_PRISON, TextColor.m_131266_((int)4703456));
        this.colors.builtin.put(GLACIAL_CHANCE, TextColor.m_131266_((int)8973822));
    }

    public TextColor getColor(String key) {
        return this.colors.get(key);
    }

    public void replaceColorStrings(JsonElement element) {
        this.replaceColorStrings(element, this.colors);
    }

    private TextColor replaceColorStrings(JsonElement element, Colors colors) {
        String string;
        JsonPrimitive primitive;
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            ArrayList list = Lists.newArrayList((Iterable)object.keySet());
            for (String key : list) {
                TextColor result = this.replaceColorStrings(object.get(key), colors);
                if (result == null) continue;
                object.remove(key);
                object.add(key, (JsonElement)new JsonPrimitive(result.toString()));
            }
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                TextColor result = this.replaceColorStrings(array.get(i), colors);
                if (result == null) continue;
                array.set(i, (JsonElement)new JsonPrimitive(result.toString()));
            }
        } else if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString() && (string = primitive.getAsString()).startsWith("$")) {
            return colors.get(string.substring(1));
        }
        return null;
    }

    public static class Colors {
        @Expose
        private final TreeMap<String, TextColor> builtin = new TreeMap();
        @Expose
        private final TreeMap<String, TextColor> custom = new TreeMap();

        public TextColor get(String key) {
            if (this.custom.containsKey(key)) {
                return this.custom.get(key);
            }
            return this.builtin.getOrDefault(key, MISSING_COLOR);
        }
    }
}

