/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.VaultRarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class CompanionRelicsConfig
extends Config {
    @Expose
    public Map<ResourceLocation, LevelEntryList<Pool>> pools = new LinkedHashMap<ResourceLocation, LevelEntryList<Pool>>();
    @Expose
    private Map<Block, Map<VaultRarity, Double>> relicChances = new LinkedHashMap<Block, Map<VaultRarity, Double>>();
    @Expose
    private Map<Block, Map<VaultRarity, Double>> particleChances = new LinkedHashMap<Block, Map<VaultRarity, Double>>();
    @Expose
    private int lootMinLevel = 50;
    @Expose
    private WeightedList<ResourceLocation> lootPoolWeights;

    @Override
    public String getName() {
        return "companion_relics";
    }

    @Override
    protected void reset() {
        this.pools = new LinkedHashMap<ResourceLocation, LevelEntryList<Pool>>();
        this.pools.put(VaultMod.id("coin_cascade"), new LevelEntryList<Pool>().put(new Pool(0, new WeightedList<Entry>().add(new Entry(List.of("coin_cascade"), IntRoll.ofConstant(1)), 1).add(new Entry(Arrays.asList("coin_cascade", "random_negative"), IntRoll.ofConstant(1)), 1))));
        this.pools.put(VaultMod.id("wooden_cascade"), new LevelEntryList<Pool>().put(new Pool(0, new WeightedList<Entry>().add(new Entry(List.of("wooden_cascade"), IntRoll.ofConstant(2)), 1).add(new Entry(Arrays.asList("wooden_cascade", "random_negative"), IntRoll.ofConstant(2)), 1))));
        this.lootMinLevel = 50;
        this.relicChances.clear();
        this.set(ModBlocks.WOODEN_CHEST, 0.0, this.relicChances);
        this.set(ModBlocks.GILDED_CHEST, 0.2f, this.relicChances);
        this.set(ModBlocks.LIVING_CHEST, 0.0, this.relicChances);
        this.set(ModBlocks.ORNATE_CHEST, 0.5, this.relicChances);
        this.set(ModBlocks.ORNATE_STRONGBOX, 0.5, this.relicChances);
        this.set(ModBlocks.GILDED_STRONGBOX, 0.2f, this.relicChances);
        this.set(ModBlocks.LIVING_STRONGBOX, 0.0, this.relicChances);
        this.set(ModBlocks.ORNATE_BARREL, 0.5, this.relicChances);
        this.set(ModBlocks.GILDED_BARREL, 0.2f, this.relicChances);
        this.set(ModBlocks.LIVING_BARREL, 0.0, this.relicChances);
        this.set(ModBlocks.WOODEN_BARREL, 0.0, this.relicChances);
        this.particleChances.clear();
        this.set(ModBlocks.WOODEN_CHEST, 0.0, this.particleChances);
        this.set(ModBlocks.GILDED_CHEST, 0.2f, this.particleChances);
        this.set(ModBlocks.LIVING_CHEST, 0.0, this.particleChances);
        this.set(ModBlocks.ORNATE_CHEST, 0.5, this.particleChances);
        this.set(ModBlocks.ORNATE_STRONGBOX, 0.5, this.particleChances);
        this.set(ModBlocks.GILDED_STRONGBOX, 0.2f, this.particleChances);
        this.set(ModBlocks.LIVING_STRONGBOX, 0.0, this.particleChances);
        this.set(ModBlocks.ORNATE_BARREL, 0.5, this.particleChances);
        this.set(ModBlocks.GILDED_BARREL, 0.2f, this.particleChances);
        this.set(ModBlocks.LIVING_BARREL, 0.0, this.particleChances);
        this.set(ModBlocks.WOODEN_BARREL, 0.0, this.particleChances);
        this.lootPoolWeights = new WeightedList();
        this.lootPoolWeights.add(VaultMod.id("wooden_cascade"), 1);
        this.lootPoolWeights.add(VaultMod.id("coin_cascade"), 1);
    }

    public Optional<ResolvedEntry> generate(ResourceLocation id, int level, RandomSource random) {
        return Optional.ofNullable(this.pools.get(id)).flatMap(p -> p.getForLevel(level)).flatMap(pool -> pool.pool.getRandom(random)).map(entry -> entry.resolve(level, random));
    }

    public int getMaxModels() {
        return this.pools.values().stream().flatMap(Collection::stream).flatMap(pool -> pool.pool.entrySet().stream()).mapToInt(entry -> ((Entry)entry.getKey()).model.getMax()).max().orElse(0);
    }

    public int getRandomModel(RandomSource random) {
        return random.nextInt(this.getMaxModels() + 1);
    }

    private void set(Block block, double chance, Map<Block, Map<VaultRarity, Double>> mapOut) {
        for (VaultRarity value : VaultRarity.values()) {
            mapOut.computeIfAbsent(block, block1 -> new LinkedHashMap()).put(value, chance);
        }
    }

    public double getRelicChestChance(Block block, VaultRarity rarity) {
        return this.relicChances.getOrDefault(block, Collections.emptyMap()).getOrDefault((Object)rarity, 0.0);
    }

    public int getRelicMinLevel() {
        return this.lootMinLevel;
    }

    public double getParticleChance(Block block, VaultRarity rarity) {
        return this.particleChances.getOrDefault(block, Collections.emptyMap()).getOrDefault((Object)rarity, 0.0);
    }

    public Optional<ResourceLocation> getRandomLootPool(RandomSource random) {
        return this.lootPoolWeights.getRandom(random);
    }

    public Optional<ResolvedEntry> getRandom(int level, RandomSource random) {
        return this.getRandomLootPool(random).flatMap(id -> this.generate((ResourceLocation)id, level, random));
    }

    public static class Pool
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final WeightedList<Entry> pool;

        public Pool(int level, WeightedList<Entry> pool) {
            this.level = level;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    public static class Entry {
        @Expose
        private final List<String> modifiers;
        @Expose
        private final IntRoll model;

        public Entry(IntRoll model, List<ResourceLocation> modifiers) {
            this(modifiers.stream().map(ResourceLocation::toString).toList(), model);
        }

        public Entry(List<String> modifiers, IntRoll model) {
            this.modifiers = modifiers;
            this.model = model;
        }

        public ResolvedEntry resolve(int level, RandomSource random) {
            ArrayList<ResourceLocation> resolved = new ArrayList<ResourceLocation>();
            for (String id : this.modifiers) {
                if (id.startsWith("@")) {
                    ResourceLocation poolId = new ResourceLocation(id.substring(1));
                    List<VaultModifier<?>> pool = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(poolId, level, random);
                    if (pool != null) {
                        for (VaultModifier<?> modifier : pool) {
                            resolved.add(modifier.getId());
                        }
                        continue;
                    }
                    VaultMod.LOGGER.error("Unknown companion relic modifier pool: {}", (Object)poolId);
                    continue;
                }
                resolved.add(new ResourceLocation(id));
            }
            return new ResolvedEntry(resolved, this.model);
        }
    }

    public static class ResolvedEntry {
        private final List<ResourceLocation> modifiers;
        private final IntRoll model;

        public ResolvedEntry(List<ResourceLocation> modifiers, IntRoll model) {
            this.modifiers = modifiers;
            this.model = model;
        }

        public List<ResourceLocation> getModifiers() {
            return this.modifiers;
        }

        public IntRoll getModel() {
            return this.model;
        }
    }
}

