/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.item.CompanionSeries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompanionsConfig
extends Config {
    @Expose
    private int maxLevel;
    @Expose
    private float expMultiplier;
    @Expose
    private float completionXpShare = 1.0f;
    @Expose
    private int hatchingTime = 20;
    @Expose
    private int[] cooldownRange = new int[]{20, 40};
    @Expose
    private float cooldownMultiplier = 1.0f;
    @Expose
    private List<CompanionLevelMeta> levels = new ArrayList<CompanionLevelMeta>();
    @Expose
    private List<Integer> temporalModifierDurations = new ArrayList<Integer>();
    @Expose
    private int relicRemovalCost = 256;
    @Expose
    private Map<String, Double> PET_WEIGHTS = new HashMap<String, Double>();
    @Expose
    private Map<CompanionSeries, Double> SERIES_WEIGHTS = new HashMap<CompanionSeries, Double>();

    @Override
    public String getName() {
        return "companions";
    }

    public float getCooldownMultiplier() {
        return this.cooldownMultiplier;
    }

    @Override
    protected void reset() {
        this.cooldownRange = new int[]{20, 40};
        this.maxLevel = 10;
        this.completionXpShare = 1.0f;
        this.expMultiplier = 1.0f;
        this.relicRemovalCost = 256;
        this.levels.clear();
        int[] tnlPerLevel = new int[]{10000, 25000, 50000, 125000, 250000, 500000, 1000000, 3000000, 6000000};
        this.temporalModifierDurations = Arrays.asList(1200, 1800, 2400, 3000, 3600, 4800, 6000, 7200, 9600, 12000);
        for (int x = 1; x <= this.maxLevel; ++x) {
            CompanionLevelMeta level = new CompanionLevelMeta();
            level.level = x;
            level.tnl = x == 1 ? 0 : tnlPerLevel[x - 2];
            this.levels.add(level);
        }
        this.PET_WEIGHTS = new HashMap<String, Double>();
        this.PET_WEIGHTS.put("venus", 1.0);
        this.SERIES_WEIGHTS = new HashMap<CompanionSeries, Double>();
        this.SERIES_WEIGHTS.put(CompanionSeries.PET, 2.0);
    }

    public int getRelicRemovalCost() {
        return this.relicRemovalCost;
    }

    public int getTemporalModifierTime(int level) {
        int index = Math.min(level - 1, this.temporalModifierDurations.size() - 1);
        return this.temporalModifierDurations.get(index);
    }

    public int[] getCooldownRange() {
        return this.cooldownRange;
    }

    public int getRandomCooldown(RandomSource random) {
        int min = this.cooldownRange[0];
        int max = this.cooldownRange[1];
        return random.nextInt(max - min + 1) + min;
    }

    public CompanionLevelMeta getLevelMeta(int level) {
        int maxLevelTNLAvailable = this.levels.size() - 1;
        if (level < 0 || level > maxLevelTNLAvailable) {
            return this.levels.get(maxLevelTNLAvailable);
        }
        return this.levels.get(level);
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public float getExpMultiplier() {
        return this.expMultiplier;
    }

    public float getCompletionXpShare() {
        return this.completionXpShare;
    }

    public int getTotalExpAtLevel(int level) {
        int totalExp = 0;
        for (int x = 0; x < level; ++x) {
            totalExp += this.getLevelMeta((int)x).tnl;
        }
        return totalExp;
    }

    public int getHatchingTime() {
        return this.hatchingTime;
    }

    public double getPetWeight(String type) {
        return this.PET_WEIGHTS.getOrDefault(type, 1.0);
    }

    public double getSeriesWeight(CompanionSeries companionSeries) {
        return this.SERIES_WEIGHTS.getOrDefault((Object)companionSeries, 1.0);
    }

    public static class CompanionLevelMeta {
        @Expose
        private int level;
        @Expose
        private int tnl;

        public int getLevel() {
            return this.level;
        }

        public int getTnl() {
            return this.tnl;
        }
    }
}

