/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import java.util.HashMap;
import java.util.Map;

public class DurabilityConfig
extends Config {
    @Expose
    private final Map<Integer, Float> durabilityOverride = new HashMap<Integer, Float>();
    @Expose
    private final Map<Integer, Float> armorDurabilityOverride = new HashMap<Integer, Float>();

    @Override
    public String getName() {
        return "durability";
    }

    public float getDurabilityIgnoreChance(int unbreakingLevel) {
        return this.getIgnoreChance(this.durabilityOverride, unbreakingLevel);
    }

    public float getArmorDurabilityIgnoreChance(int unbreakingLevel) {
        return this.getIgnoreChance(this.armorDurabilityOverride, unbreakingLevel);
    }

    private float getIgnoreChance(Map<Integer, Float> chanceMap, int unbreakingLevel) {
        if (unbreakingLevel < 1) {
            return 0.0f;
        }
        int overrideLevel = chanceMap.keySet().stream().filter(level -> level <= unbreakingLevel).mapToInt(level -> level).max().orElse(0);
        if (overrideLevel <= 0) {
            return 0.0f;
        }
        return chanceMap.get(overrideLevel).floatValue();
    }

    @Override
    protected void reset() {
        this.durabilityOverride.clear();
        this.armorDurabilityOverride.clear();
        this.durabilityOverride.put(1, Float.valueOf(0.5f));
        this.durabilityOverride.put(2, Float.valueOf(0.66667f));
        this.durabilityOverride.put(3, Float.valueOf(0.75f));
        this.durabilityOverride.put(4, Float.valueOf(0.78f));
        this.durabilityOverride.put(5, Float.valueOf(0.8f));
        this.durabilityOverride.put(6, Float.valueOf(0.82f));
        this.durabilityOverride.put(7, Float.valueOf(0.84f));
        this.durabilityOverride.put(8, Float.valueOf(0.86f));
        this.durabilityOverride.put(9, Float.valueOf(0.88f));
        this.durabilityOverride.put(10, Float.valueOf(0.9f));
        this.armorDurabilityOverride.put(1, Float.valueOf(0.2f));
        this.armorDurabilityOverride.put(2, Float.valueOf(0.27f));
        this.armorDurabilityOverride.put(3, Float.valueOf(0.3f));
        this.armorDurabilityOverride.put(4, Float.valueOf(0.33f));
        this.armorDurabilityOverride.put(5, Float.valueOf(0.36f));
        this.armorDurabilityOverride.put(6, Float.valueOf(0.39f));
        this.armorDurabilityOverride.put(7, Float.valueOf(0.42f));
        this.armorDurabilityOverride.put(8, Float.valueOf(0.45f));
        this.armorDurabilityOverride.put(9, Float.valueOf(0.48f));
        this.armorDurabilityOverride.put(10, Float.valueOf(0.51f));
    }
}

