/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.init.ModEntities;
import iskallia.vault.util.data.WeightedList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EliteSpawnerConfig
extends Config {
    @Expose
    public int blockCheckRadius;
    @Expose
    public Map<String, SpawnerGroup> spawnerGroups;

    @Override
    public String getName() {
        return "elite_spawner";
    }

    @Override
    protected void reset() {
        this.blockCheckRadius = 50;
        this.spawnerGroups = new HashMap<String, SpawnerGroup>();
        this.addSpawnerGroup(ModEntities.ELITE_DROWNED, 4, 9, EntityType.f_20562_, EntityType.f_20455_, EntityType.f_20524_);
        this.addSpawnerGroup(ModEntities.ELITE_ENDERMAN, 5, 10, EntityType.f_20566_, EntityType.f_20516_, EntityType.f_20521_);
        this.addSpawnerGroup(ModEntities.ELITE_HUSK, 4, 11, EntityType.f_20458_, EntityType.f_20468_, EntityType.f_20456_);
        ListTag handItemsTag = new ListTag();
        handItemsTag.add((Object)new ItemStack((ItemLike)Items.f_42393_).m_41739_(new CompoundTag()));
        CompoundTag mobTag = new CompoundTag();
        mobTag.m_128365_("HandItems", (Tag)handItemsTag);
        this.addSpawnerGroup(new SpawnerEntity(ModEntities.ELITE_SKELETON.getRegistryName(), mobTag), 6, 9, new SpawnerEntity(EntityType.f_20524_.getRegistryName(), mobTag), new SpawnerEntity(EntityType.f_20481_.getRegistryName(), mobTag), new SpawnerEntity(EntityType.f_20513_.getRegistryName(), mobTag));
        this.addSpawnerGroup(ModEntities.ELITE_SPIDER, 7, 10, EntityType.f_20479_, EntityType.f_20554_, EntityType.f_20523_);
        this.addSpawnerGroup(ModEntities.ELITE_STRAY, 5, 8, EntityType.f_20481_, EntityType.f_20558_, EntityType.f_20524_);
        this.addSpawnerGroup(ModEntities.ELITE_WITCH, 4, 9, EntityType.f_20495_, EntityType.f_20501_, EntityType.f_20524_);
        this.addSpawnerGroup(ModEntities.ELITE_ZOMBIE, 3, 6, EntityType.f_20501_, EntityType.f_20493_, EntityType.f_20524_);
    }

    private void addSpawnerGroup(EntityType<?> eliteEntityType, int min, int max, EntityType<?> ... minionTypes) {
        WeightedList<SpawnerEntity> minions = new WeightedList<SpawnerEntity>();
        Arrays.stream(minionTypes).forEach(mt -> minions.add(new WeightedList.Entry<SpawnerEntity>(new SpawnerEntity(mt.getRegistryName(), null), 1)));
        this.spawnerGroups.put(eliteEntityType.getRegistryName().toString(), new SpawnerGroup(new SpawnerEntity(eliteEntityType.getRegistryName(), null), min, max, minions));
    }

    private void addSpawnerGroup(SpawnerEntity elite, int min, int max, SpawnerEntity ... minions) {
        WeightedList<SpawnerEntity> minionsWeigheted = new WeightedList<SpawnerEntity>();
        Arrays.stream(minions).forEach(minion -> minionsWeigheted.add(new WeightedList.Entry<SpawnerEntity>((SpawnerEntity)minion, 1)));
        this.spawnerGroups.put(elite.entityName.toString(), new SpawnerGroup(elite, min, max, minionsWeigheted));
    }

    public static class SpawnerEntity {
        @Expose
        public ResourceLocation entityName;
        @Expose
        public CompoundTag entityNbt;

        public SpawnerEntity(ResourceLocation entityName, @Nullable CompoundTag entityNbt) {
            this.entityName = entityName;
            this.entityNbt = entityNbt;
        }
    }

    public static class SpawnerGroup {
        @Expose
        public SpawnerEntity elite;
        @Expose
        public int min;
        @Expose
        public int max;
        @Expose
        public WeightedList<SpawnerEntity> minions;

        public SpawnerGroup(SpawnerEntity elite, int min, int max, WeightedList<SpawnerEntity> minions) {
            this.elite = elite;
            this.min = min;
            this.max = max;
            this.minions = minions;
        }
    }
}

