/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.roll.IntRoll;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentPoolsConfig
extends Config {
    @Expose
    private Map<String, Map<ResourceLocation, IntRoll>> enchantmentPools;

    @Override
    public String getName() {
        return "enchantment_pools";
    }

    @Override
    protected void reset() {
        this.enchantmentPools = Map.of("random_efficiency", Map.of(new ResourceLocation("efficiency"), IntRoll.ofUniform(3, 5)), "feather_falling_ranged", Map.of(new ResourceLocation("feather_falling"), IntRoll.ofUniform(1, 4)));
    }

    public Map<String, Map<ResourceLocation, IntRoll>> getEnchantmentPools() {
        return this.enchantmentPools;
    }

    public Map<ResourceLocation, IntRoll> getEnchantmentPool(String pool) {
        return this.enchantmentPools.getOrDefault(pool, Map.of());
    }

    public Map<ResourceLocation, Integer> generatePool(String pool) {
        return this.generatePool(pool, (RandomSource)JavaRandom.ofNanoTime());
    }

    public Map<ResourceLocation, Integer> generatePool(String pool, RandomSource random) {
        return this.getEnchantmentPool(pool).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IntRoll)entry.getValue()).get(random)));
    }

    public void generatePool(ItemStack stack, RandomSource random) {
        if (!stack.m_41782_()) {
            return;
        }
        if (stack.m_41783_().m_128441_("VaultEnchantmentPools")) {
            ListTag stringList = stack.m_41783_().m_128437_("VaultEnchantmentPools", 8);
            if (stringList.isEmpty()) {
                return;
            }
            List<String> poolNames = stringList.stream().map(Tag::m_7916_).toList();
            Map<String, Map> pools = poolNames.stream().collect(Collectors.toMap(key -> key, key -> this.getEnchantmentPool((String)key).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IntRoll)entry.getValue()).get(JavaRandom.ofNanoTime())))));
            for (Map.Entry<String, Map> entry : pools.entrySet()) {
                String poolName = entry.getKey();
                Map enchantments = entry.getValue();
                enchantments.forEach((enchantment, level) -> {
                    Enchantment mcEnchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment);
                    if (level > 0 && mcEnchantment != null) {
                        stack.m_41663_(mcEnchantment, level.intValue());
                    }
                });
            }
            stack.m_41783_().m_128473_("VaultEnchantmentPools");
        }
    }
}

