/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntityGroupDefinitionsConfig
extends Config {
    @Expose
    public List<EntityGroupDefinition> groups;

    @Override
    public String getName() {
        return "entity_group_definitions";
    }

    @Override
    protected void reset() {
        this.groups = new ArrayList<EntityGroupDefinition>();
        this.groups.add(new EntityGroupDefinition("@the_vault:horde", "Hordes", VaultMod.id("gui/mob_groups/horde.png"), TextColor.m_131266_((int)0xFF0000), true));
    }

    public List<EntityGroupDefinition> getGroups() {
        return this.groups;
    }

    public boolean isInGroup(Entity entity) {
        for (EntityGroupDefinition group : this.groups) {
            if (!group.isInGroup(entity)) continue;
            return true;
        }
        return false;
    }

    public boolean isInGroup(Entity entity, boolean showHealthbar) {
        for (EntityGroupDefinition group : this.groups) {
            if (group.showHealthbar != showHealthbar || !group.isInGroup(entity)) continue;
            return true;
        }
        return false;
    }

    public Optional<EntityGroupDefinition> getGroup(Entity entity) {
        for (EntityGroupDefinition entry : this.groups) {
            if (!entry.isInGroup(entity)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public Optional<EntityGroupDefinition> getGroup(String groupId) {
        for (EntityGroupDefinition entry : this.groups) {
            if (!entry.id.equals(groupId)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public List<String> getGroupIds() {
        return this.groups.stream().map(EntityGroupDefinition::getId).toList();
    }

    public class EntityGroupDefinition {
        @Expose
        public String id;
        @Expose
        public String displayName;
        @Expose
        public ResourceLocation icon;
        @Expose
        public TextColor color;
        @Expose
        public boolean showHealthbar;
        @Expose
        public int stackValue;

        public EntityGroupDefinition(String id, String displayName, ResourceLocation icon, TextColor color, boolean showHealthbar) {
            this.id = id;
            this.displayName = displayName;
            this.icon = icon;
            this.color = color;
            this.showHealthbar = showHealthbar;
        }

        public boolean isInGroup(Vec3 pos, BlockPos blockPos, PartialCompoundNbt nbt) {
            Optional<EntityPredicate> predicate = EntityPredicate.of(this.id, true);
            if (predicate.isPresent()) {
                EntityPredicate entityPredicate = predicate.get();
                return entityPredicate.test(pos, blockPos, nbt);
            }
            return false;
        }

        public boolean isInGroup(Entity entity) {
            return this.isInGroup(entity.m_20182_(), entity.m_142538_(), PartialCompoundNbt.of(entity.serializeNBT()));
        }

        public boolean isInGroup(PartialEntity entity) {
            return this.isInGroup(entity.getPos(), entity.getBlockPos(), entity.getNbt());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }

        public String getId() {
            return this.id;
        }

        public TextColor getColor() {
            return this.color;
        }

        public int getStackValue() {
            return this.stackValue;
        }
    }
}

