/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntityGroupsConfig
extends Config {
    @Expose
    private Map<ResourceLocation, EntityPredicate> groups;

    @Override
    public String getName() {
        return "entity_groups";
    }

    public boolean isInGroup(ResourceLocation groupId, Vec3 pos, BlockPos blockPos, PartialCompoundNbt nbt) {
        EntityPredicate predicate = this.groups.get(groupId);
        return predicate != null && predicate.test(pos, blockPos, nbt);
    }

    public boolean isInGroup(ResourceLocation groupId, Entity entity) {
        EntityPredicate predicate = this.groups.get(groupId);
        return predicate != null && predicate.test(entity);
    }

    public boolean isInGroup(ResourceLocation groupId, PartialEntity entity) {
        return this.isInGroup(groupId, entity.getPos(), entity.getBlockPos(), entity.getNbt());
    }

    @Override
    protected void reset() {
        this.groups = new LinkedHashMap<ResourceLocation, EntityPredicate>();
    }

    public Map<ResourceLocation, EntityPredicate> getGroups() {
        return this.groups;
    }
}

