/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.init.ModEntities;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class EntityHitboxOffsets
extends Config {
    @Expose
    private Map<ResourceLocation, EntityHitboxOffset> offsets;

    @Override
    public String getName() {
        return "entity_hitbox_offsets";
    }

    @Override
    protected void reset() {
        this.offsets = new HashMap<ResourceLocation, EntityHitboxOffset>();
        this.offsets.put(ModEntities.DEATHCAP.getRegistryName(), new EntityHitboxOffset(0.0f, 0.4f, 0.0f));
    }

    public Map<ResourceLocation, EntityHitboxOffset> getOffsets() {
        return this.offsets;
    }

    public Optional<EntityHitboxOffset> getOffset(ResourceLocation entityId) {
        return Optional.ofNullable(this.offsets.get(entityId));
    }

    public static class EntityHitboxOffset {
        @Expose
        private float x;
        @Expose
        private float y;
        @Expose
        private float z;

        public EntityHitboxOffset(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static EntityHitboxOffset empty() {
            return new EntityHitboxOffset(0.0f, 0.0f, 0.0f);
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }
    }
}

