/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.entity.entity.eyesore.EyesoreEntity;
import iskallia.vault.entity.entity.eyesore.EyesoreFireballEntity;
import net.minecraft.server.level.ServerLevel;

public class EyesoreConfig
extends Config {
    @Expose
    public BasicAttack basicAttack;
    @Expose
    public LaserAttack laserAttack;

    @Override
    public String getName() {
        return "eyesore";
    }

    @Override
    protected void reset() {
        this.basicAttack = new BasicAttack(5.0f, 4.0f);
        this.laserAttack = new LaserAttack(4.0f, 2.0f, 20);
    }

    public static class BasicAttack {
        @Expose
        public float baseDamage;
        @Expose
        public float extraDamagePerPlayer;

        public BasicAttack(float baseDamage, float extraDamagePerPlayer) {
            this.baseDamage = baseDamage;
            this.extraDamagePerPlayer = extraDamagePerPlayer;
        }

        public float getDamage(EyesoreFireballEntity entity) {
            ServerLevel world = (ServerLevel)entity.m_20193_();
            float damage = this.baseDamage;
            return damage;
        }
    }

    public static class LaserAttack {
        @Expose
        public float baseDamage;
        @Expose
        public float extraDamagePerPlayer;
        @Expose
        public int tickDelay;

        public LaserAttack(float baseDamage, float extraDamagePerPlayer, int tickDelay) {
            this.baseDamage = baseDamage;
            this.extraDamagePerPlayer = extraDamagePerPlayer;
            this.tickDelay = tickDelay;
        }

        public float getDamage(EyesoreEntity entity, int tick) {
            if (tick % this.tickDelay != 0) {
                return 0.0f;
            }
            ServerLevel world = (ServerLevel)entity.m_20193_();
            float damage = this.baseDamage;
            return damage;
        }
    }
}

