/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.model.armor.ArmorModel;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.item.gear.FocusItem;
import iskallia.vault.item.gear.VaultArmorItem;
import iskallia.vault.item.gear.VaultAxeItem;
import iskallia.vault.item.gear.VaultShieldItem;
import iskallia.vault.item.gear.VaultSwordItem;
import iskallia.vault.item.gear.WandItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GearModelRollRaritiesConfig
extends Config {
    @Expose
    int weightedRollChance;
    @Expose
    Map<String, List<String>> ARMOR_MODEL_ROLLS;
    @Expose
    Map<String, List<String>> SWORD_MODEL_ROLLS;
    @Expose
    Map<String, List<String>> AXE_MODEL_ROLLS;
    @Expose
    Map<String, List<String>> SHIELD_MODEL_ROLLS;
    @Expose
    Map<String, List<String>> WAND_MODEL_ROLLS;
    @Expose
    Map<String, List<String>> FOCUS_MODEL_ROLLS;
    @Expose
    Map<String, List<String>> MAGNETS_MODEL_ROLLS;

    public Map<String, List<String>> getRolls(ItemStack stack) {
        if (stack.m_41720_() instanceof VaultArmorItem) {
            return this.ARMOR_MODEL_ROLLS;
        }
        if (stack.m_41720_() instanceof VaultSwordItem) {
            return this.SWORD_MODEL_ROLLS;
        }
        if (stack.m_41720_() instanceof VaultAxeItem) {
            return this.AXE_MODEL_ROLLS;
        }
        if (stack.m_41720_() instanceof VaultShieldItem) {
            return this.SHIELD_MODEL_ROLLS;
        }
        if (stack.m_41720_() instanceof WandItem) {
            return this.WAND_MODEL_ROLLS;
        }
        if (stack.m_41720_() instanceof FocusItem) {
            return this.FOCUS_MODEL_ROLLS;
        }
        if (stack.m_41720_() instanceof MagnetItem) {
            return this.MAGNETS_MODEL_ROLLS;
        }
        return Collections.emptyMap();
    }

    private String transformWithEquipmentSlot(String modelId, EquipmentSlot slot) {
        String slotName = ArmorModel.slotName(slot);
        return slotName == null ? modelId : modelId + "/" + slotName;
    }

    public ResourceLocation getRandomRoll(ItemStack stack, VaultGearData data, EquipmentSlot slot, Random random, @javax.annotation.Nullable Player player, @javax.annotation.Nullable DiscoveredModelsData discoveredData) {
        Set<ResourceLocation> possibleRolls = this.getPossibleRolls(stack, data, slot);
        if (player == null || discoveredData == null || possibleRolls.isEmpty()) {
            return MiscUtils.getRandomEntry(possibleRolls, random);
        }
        Set<ResourceLocation> discoveredModels = discoveredData.getDiscoveredModels(player.m_142081_());
        WeightedList<ResourceLocation> weightedRolls = new WeightedList<ResourceLocation>();
        for (ResourceLocation modelId : possibleRolls) {
            int weight = discoveredModels.contains(modelId) ? 1 : Math.max(1, this.getWeightedRollChance());
            weightedRolls.add(modelId, weight);
        }
        return weightedRolls.getRandom(random).orElseGet(() -> (ResourceLocation)MiscUtils.getRandomEntry(possibleRolls, random));
    }

    public ResourceLocation getRandomRoll(ItemStack stack, VaultGearData data, EquipmentSlot slot, Random random) {
        return this.getRandomRoll(stack, data, slot, random, null, null);
    }

    private <G extends Item> Set<ResourceLocation> getPossibleRolls(ItemStack stack, VaultGearData data, EquipmentSlot slot) {
        Set<ResourceLocation> rolls = this.getUnfilteredRolls(stack, data, slot);
        rolls.removeIf(modelId -> this.getForcedTierRarity(stack, (ResourceLocation)modelId) != null);
        return rolls;
    }

    private <G extends Item> Set<ResourceLocation> getUnfilteredRolls(ItemStack stack, VaultGearData data, EquipmentSlot slot) {
        List<String> modelIds = this.getRolls(stack).get(data.getRarity().name());
        if (modelIds == null) {
            return ModDynamicModels.REGISTRIES.getAssociatedRegistry(stack.m_41720_()).map(DynamicModelRegistry::getIds).orElseGet(Collections::emptySet);
        }
        return modelIds.stream().map(modelId -> this.transformWithEquipmentSlot((String)modelId, slot)).map(ResourceLocation::new).filter(modelId -> ModDynamicModels.REGISTRIES.getModel(stack.m_41720_(), (ResourceLocation)modelId).isPresent()).collect(Collectors.toSet());
    }

    public VaultGearRarity getRarityOf(ItemStack stack, ResourceLocation modelId) {
        Map<String, List<String>> rolls = this.getRolls(stack);
        if (rolls == null) {
            return VaultGearRarity.SCRAPPY;
        }
        VaultGearRarity predefined = this.getForcedTierRarity(stack, modelId);
        if (predefined != null) {
            return predefined;
        }
        if (stack.m_41720_() instanceof VaultArmorItem) {
            modelId = ModDynamicModels.Armor.PIECE_REGISTRY.get(modelId).map(ArmorPieceModel::getArmorModel).map(DynamicModel::getId).orElse(modelId);
        }
        boolean isSpecial = false;
        Optional<DynamicModelRegistry<?>> registry = ModDynamicModels.REGISTRIES.getAssociatedRegistry(stack.m_41720_());
        if (registry.isPresent()) {
            DynamicModelRegistry<?> reg = registry.get();
            isSpecial = reg.get(modelId).map(m -> m.getModelProperties().doesRequireRewards()).orElse(false);
        }
        if (isSpecial) {
            return VaultGearRarity.SPECIAL;
        }
        for (int i = VaultGearRarity.values().length - 1; i >= 0; --i) {
            VaultGearRarity rarity = VaultGearRarity.values()[i];
            List<String> modelIds = rolls.get(rarity.name());
            if (modelIds == null || !modelIds.contains(modelId.toString())) continue;
            return rarity;
        }
        return VaultGearRarity.SCRAPPY;
    }

    public boolean canAppearNormally(ItemStack stack, ResourceLocation modelId) {
        return this.getForcedTierRarity(stack, modelId) == null;
    }

    public int getWeightedRollChance() {
        return this.weightedRollChance;
    }

    @javax.annotation.Nullable
    private VaultGearRarity getForcedTierRarity(ItemStack stack, ResourceLocation modelId) {
        return null;
    }

    @Override
    public String getName() {
        return "gear_model_roll_rarities";
    }

    @Override
    protected void reset() {
        this.weightedRollChance = 2;
        this.ARMOR_MODEL_ROLLS = new HashMap<String, List<String>>();
        this.ARMOR_MODEL_ROLLS.put(VaultGearRarity.SCRAPPY.name(), ModDynamicModels.Armor.MODEL_REGISTRY.getIds().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        this.SWORD_MODEL_ROLLS = new HashMap<String, List<String>>();
        this.SWORD_MODEL_ROLLS.put(VaultGearRarity.SCRAPPY.name(), ModDynamicModels.Swords.REGISTRY.getIds().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        this.AXE_MODEL_ROLLS = new HashMap<String, List<String>>();
        this.AXE_MODEL_ROLLS.put(VaultGearRarity.SCRAPPY.name(), ModDynamicModels.Axes.REGISTRY.getIds().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        this.SHIELD_MODEL_ROLLS = new HashMap<String, List<String>>();
        this.SHIELD_MODEL_ROLLS.put(VaultGearRarity.SCRAPPY.name(), ModDynamicModels.Shields.REGISTRY.getIds().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        this.WAND_MODEL_ROLLS = new HashMap<String, List<String>>();
        this.WAND_MODEL_ROLLS.put(VaultGearRarity.SCRAPPY.name(), ModDynamicModels.Wands.REGISTRY.getIds().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        this.FOCUS_MODEL_ROLLS = new HashMap<String, List<String>>();
        this.FOCUS_MODEL_ROLLS.put(VaultGearRarity.SCRAPPY.name(), ModDynamicModels.Focus.REGISTRY.getIds().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        this.MAGNETS_MODEL_ROLLS = new HashMap<String, List<String>>();
        this.MAGNETS_MODEL_ROLLS.put(VaultGearRarity.SCRAPPY.name(), ModDynamicModels.Magnets.REGISTRY.getIds().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
    }

    @Nullable
    public ResourceLocation getRandomMagnetRoll(ItemStack stack, VaultGearData gearData, Random random, Player player, DiscoveredModelsData discoveredModelsData) {
        Set<ResourceLocation> possibleRolls = this.getPossibleRolls(stack, gearData, EquipmentSlot.MAINHAND);
        if (player == null || discoveredModelsData == null || possibleRolls.isEmpty()) {
            return MiscUtils.getRandomEntry(possibleRolls, random);
        }
        Set<ResourceLocation> discoveredModels = discoveredModelsData.getDiscoveredModels(player.m_142081_());
        WeightedList<ResourceLocation> weightedRolls = new WeightedList<ResourceLocation>();
        for (ResourceLocation modelId : possibleRolls) {
            int weight = discoveredModels.contains(modelId) ? 1 : Math.max(1, this.getWeightedRollChance());
            weightedRolls.add(modelId, weight);
        }
        return weightedRolls.getRandom(random).orElseGet(() -> (ResourceLocation)MiscUtils.getRandomEntry(possibleRolls, random));
    }
}

