/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.init.ModGearAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class GodCharmConfig
extends Config {
    @Expose
    private Map<VaultGod, GodEntry> gods;

    @Override
    public String getName() {
        return "god_charm";
    }

    @Override
    protected void reset() {
        this.gods = new HashMap<VaultGod, GodEntry>();
        GodEntry idona = new GodEntry();
        idona.add(ModGearAttributes.DAMAGE_INCREASE.getRegistryName(), 0.5f, 2.5f, 0.5f, 10);
        idona.add(ModGearAttributes.ABILITY_POWER_PERCENT.getRegistryName(), 0.25f, 0.75f, 0.25f, 10);
        idona.add(ModGearAttributes.SOUL_QUANTITY.getRegistryName(), 1.0f, 4.0f, 1.0f, 10);
        this.gods.put(VaultGod.IDONA, idona);
        GodEntry tenos = new GodEntry();
        tenos.add(ModGearAttributes.MANA_REGEN_ADDITIVE_PERCENTILE.getRegistryName(), 2.0f, 6.0f, 1.0f, 10);
        tenos.add(ModGearAttributes.MANA_ADDITIVE_PERCENTILE.getRegistryName(), 0.25f, 0.75f, 0.25f, 10);
        tenos.add(ModGearAttributes.AREA_OF_EFFECT.getRegistryName(), 0.25f, 0.75f, 0.25f, 10);
        this.gods.put(VaultGod.TENOS, tenos);
        GodEntry velara = new GodEntry();
        velara.add(ModGearAttributes.HEALTH_PERCENTILE.getRegistryName(), 0.25f, 0.75f, 0.25f, 10);
        velara.add(ModGearAttributes.HEALING_EFFECTIVENESS.getRegistryName(), 0.25f, 0.75f, 0.25f, 10);
        velara.add(ModGearAttributes.EFFECT_AVOIDANCE.getRegistryName(), 0.25f, 0.75f, 0.25f, 10);
        this.gods.put(VaultGod.VELARA, velara);
        GodEntry wendarr = new GodEntry();
        wendarr.add(ModGearAttributes.COOLDOWN_REDUCTION.getRegistryName(), 0.25f, 0.75f, 0.25f, 10);
        wendarr.add(ModGearAttributes.EFFECT_DURATION.getRegistryName(), 0.25f, 0.75f, 0.25f, 10);
        wendarr.add(ModGearAttributes.MOVEMENT_SPEED.getRegistryName(), 0.5f, 1.0f, 0.1f, 10);
        this.gods.put(VaultGod.WENDARR, wendarr);
    }

    public ModifierInfo getRandomModifierForGod(VaultGod god, RandomSource random) {
        GodEntry godEntry = this.gods.get((Object)god);
        if (godEntry == null) {
            return null;
        }
        return godEntry.getRandomModifier(random);
    }

    public Set<VaultGod> getGodNames() {
        return Collections.unmodifiableSet(this.gods.keySet());
    }

    public boolean hasGod(VaultGod god) {
        return this.gods.containsKey((Object)god);
    }

    public static class GodEntry {
        @Expose
        private WeightedList<ModifierEntry> modifiers = new WeightedList();

        public void add(ResourceLocation attributeId, float min, float max, float step, int weight) {
            ModifierEntry entry = new ModifierEntry(attributeId, min, max, step);
            this.modifiers.add(entry, weight);
        }

        public ModifierInfo getRandomModifier(RandomSource random) {
            if (this.modifiers.isEmpty()) {
                return null;
            }
            Optional<ModifierEntry> randomEntry = this.modifiers.getRandom(random);
            if (randomEntry.isEmpty()) {
                return null;
            }
            ModifierEntry entry = randomEntry.get();
            int steps = (int)((entry.max - entry.min) / entry.step);
            int randomStep = random.nextInt(steps + 1);
            float baseValue = entry.min + (float)randomStep * entry.step;
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(entry.attributeId);
            return new ModifierInfo(entry.attributeId, attribute, baseValue, entry);
        }
    }

    public static class ModifierInfo {
        private final ResourceLocation attributeId;
        private final VaultGearAttribute<?> attribute;
        private final float baseValue;
        private final ModifierEntry entry;

        public ModifierInfo(ResourceLocation attributeId, VaultGearAttribute<?> attribute, float baseValue, ModifierEntry entry) {
            this.attributeId = attributeId;
            this.attribute = attribute;
            this.baseValue = baseValue;
            this.entry = entry;
        }

        public ResourceLocation getAttributeId() {
            return this.attributeId;
        }

        public VaultGearAttribute<?> getAttribute() {
            return this.attribute;
        }

        public float getBaseValue() {
            return this.baseValue;
        }

        public float getMinValue() {
            return this.entry.min;
        }

        public float getMaxValue() {
            return this.entry.max;
        }

        public float getStepValue() {
            return this.entry.step;
        }
    }

    public static class ModifierEntry {
        @Expose
        public ResourceLocation attributeId;
        @Expose
        public float min;
        @Expose
        public float max;
        @Expose
        public float step;

        public ModifierEntry(ResourceLocation attributeId, float min, float max, float step) {
            this.attributeId = attributeId;
            this.min = min;
            this.max = max;
            this.step = step;
        }
    }
}

