/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.block.HeraldTrophyBlock;
import iskallia.vault.config.Config;
import java.util.LinkedHashMap;
import java.util.Map;

public class HeraldTrophyConfig
extends Config {
    @Expose
    private Map<HeraldTrophyBlock.Variant, Integer> trophyTimes;

    public int getTime(HeraldTrophyBlock.Variant variant) {
        return this.trophyTimes.get((Object)variant);
    }

    public HeraldTrophyBlock.Variant getTrophy(int time) {
        HeraldTrophyBlock.Variant trophy = null;
        int minTime = Integer.MAX_VALUE;
        for (Map.Entry<HeraldTrophyBlock.Variant, Integer> entry : this.trophyTimes.entrySet()) {
            if (time > entry.getValue() || entry.getValue() >= minTime) continue;
            trophy = entry.getKey();
            minTime = entry.getValue();
        }
        return trophy;
    }

    @Override
    public String getName() {
        return "herald_trophy";
    }

    @Override
    protected void reset() {
        this.trophyTimes = new LinkedHashMap<HeraldTrophyBlock.Variant, Integer>();
        this.trophyTimes.put(HeraldTrophyBlock.Variant.BRONZE, 24000);
        this.trophyTimes.put(HeraldTrophyBlock.Variant.SILVER, 18000);
        this.trophyTimes.put(HeraldTrophyBlock.Variant.GOLD, 12000);
        this.trophyTimes.put(HeraldTrophyBlock.Variant.PLATINUM, 6000);
    }
}

