/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.roll.FloatRoll;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.item.data.InscriptionData;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class InscriptionConfig
extends Config {
    @Expose
    public Map<ResourceLocation, LevelEntryList<Pool>> pools;
    @Expose
    public Map<ResourceLocation, Integer> poolToModel;
    @Expose
    public List<Integer> ringWeights;

    @Override
    public String getName() {
        return "inscription";
    }

    public int getModel(ResourceLocation pool) {
        return this.poolToModel.getOrDefault(pool, 0);
    }

    public List<Integer> getRingWeights() {
        return this.ringWeights;
    }

    @Override
    protected void reset() {
        this.pools = new LinkedHashMap<ResourceLocation, LevelEntryList<Pool>>();
        this.pools.put(VaultMod.id("test"), new LevelEntryList<Pool>().put(new Pool(0, new WeightedList<Entry>().add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/challenge/crystal_caves"), null, 1, 0xFF00FF)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 16).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/challenge/digsite"), null, 1, 0xFF00FF)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 16).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/challenge/dragon"), null, 1, 0xFF00FF)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 16).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/challenge/factory"), null, 1, 0xFF00FF)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 16).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/challenge/village"), null, 1, 0xFF00FF)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 16).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/challenge/wildwest"), null, 1, 0xFF00FF)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 16).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/challenge/x-mark"), null, 1, 0xFF00FF)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 16).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/omega/cube"), null, 1, 7012096)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 4).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/omega/blacksmith"), null, 1, 7012096)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 4).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/omega/digsite"), null, 1, 7012096)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 4).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/omega/mine"), null, 1, 7012096)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 4).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/omega/painting"), null, 1, 7012096)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 4).add(new Entry(Arrays.asList(new InscriptionData.Entry(VaultMod.id("vault/rooms/omega/vendor"), null, 1, 7012096)), FloatRoll.ofUniform(0.1f, 0.2f), IntRoll.ofUniform(200, 600), IntRoll.ofUniform(10, 30), null, IntRoll.ofUniform(0, 22)), 4))));
        this.poolToModel = new LinkedHashMap<ResourceLocation, Integer>();
    }

    public Optional<InscriptionData> generate(ResourceLocation id, int level, RandomSource random) {
        return Optional.ofNullable(this.pools.get(id)).flatMap(p -> p.getForLevel(level)).flatMap(pool -> pool.pool.getRandom(random)).map(entry -> {
            InscriptionData data = InscriptionData.empty();
            entry.entries.forEach(data::add);
            if (entry.completion != null) {
                data.setCompletion(entry.completion.get(random));
            }
            if (entry.time != null) {
                data.setTime(entry.time.get(random));
            }
            if (entry.instability != null) {
                data.setInstability(entry.instability.get(random));
            }
            if (entry.size != null) {
                data.setSize(entry.size.get(random));
            }
            data.setModel(entry.model.get(random));
            data.setColor(entry.color);
            if (entry.isSuper != null) {
                data.setSuper(entry.isSuper);
            }
            if (entry.modifiers != null) {
                data.setModifiers(entry.modifiers);
            }
            return data;
        });
    }

    public static class Pool
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final WeightedList<Entry> pool;

        public Pool(int level, WeightedList<Entry> pool) {
            this.level = level;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    public static class Entry {
        @Expose
        private final List<InscriptionData.Entry> entries;
        @Expose
        private final FloatRoll completion;
        @Expose
        private final IntRoll time;
        @Expose
        private final FloatRoll instability;
        @Expose
        private final IntRoll size;
        @Expose
        private final IntRoll model;
        @Expose
        private final Integer color;
        @Expose
        private final Boolean isSuper;
        @Expose
        private final List<ResourceLocation> modifiers;

        public Entry(List<InscriptionData.Entry> entries, FloatRoll completion, IntRoll size, IntRoll time, FloatRoll instability, IntRoll model) {
            this.entries = entries;
            this.completion = completion;
            this.time = time;
            this.instability = instability;
            this.size = size;
            this.model = model;
            this.color = null;
            this.isSuper = null;
            this.modifiers = null;
        }

        public Entry(List<InscriptionData.Entry> entries, FloatRoll completion, IntRoll size, IntRoll time, FloatRoll instability, IntRoll model, Integer color, Boolean isSuper, List<ResourceLocation> modifiers) {
            this.entries = entries;
            this.completion = completion;
            this.time = time;
            this.instability = instability;
            this.size = size;
            this.model = model;
            this.color = color;
            this.isSuper = isSuper;
            this.modifiers = modifiers;
        }
    }
}

