/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.world.loot.LootTableInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootInfoConfig
extends Config {
    @Expose
    @SerializedName(value="excludeFromTooltip")
    private Set<ResourceLocation> excludeFromTooltipSet = new HashSet<ResourceLocation>();
    @Expose
    @SerializedName(value="info")
    private Map<ResourceLocation, LootInfo> lootInfoMap = new HashMap<ResourceLocation, LootInfo>();
    private TooltipLinesProvider tooltipLinesProvider;

    @Override
    public String getName() {
        return "loot_info";
    }

    @Override
    public <T extends Config> T readConfig() {
        LootInfoConfig config = (LootInfoConfig)super.readConfig();
        config.tooltipLinesProvider = new TooltipLinesProvider(config.lootInfoMap, config.excludeFromTooltipSet);
        return (T)config;
    }

    @Override
    protected void reset() {
        this.lootInfoMap = new HashMap<ResourceLocation, LootInfo>();
        this.lootInfoMap.put(VaultMod.id("coin_pile"), new LootInfo("Coin Piles", Map.of(VaultMod.id("coin_pile_lvl0"), new LootTableData(0))));
    }

    public Set<String> getTooltipLines(Item item) {
        return this.tooltipLinesProvider.getTooltipLines(item);
    }

    public Map<ResourceLocation, LootInfo> getLootInfoMap() {
        return Collections.unmodifiableMap(this.lootInfoMap);
    }

    private static class TooltipLinesProvider {
        private final Map<ResourceLocation, LootInfo> lootInfoMap;
        private final Set<ResourceLocation> excludeFromTooltipSet;
        private final Map<ResourceLocation, Set<String>> tooltipLinesCache;

        public TooltipLinesProvider(Map<ResourceLocation, LootInfo> lootInfoMap, Set<ResourceLocation> excludeFromTooltipSet) {
            this.lootInfoMap = lootInfoMap;
            this.excludeFromTooltipSet = excludeFromTooltipSet;
            this.tooltipLinesCache = new HashMap<ResourceLocation, Set<String>>();
        }

        public Set<String> getTooltipLines(Item item) {
            ResourceLocation itemResourceLocation = item.getRegistryName();
            if (itemResourceLocation == null) {
                return Collections.emptySet();
            }
            Set<String> cachedResult = this.tooltipLinesCache.get(itemResourceLocation);
            if (cachedResult != null) {
                return cachedResult;
            }
            Set calculatedResult = LootTableInfo.getLootTableKeysForItem(itemResourceLocation).stream().filter(this::isLootTableKeyDisplayAllowed).flatMap(this::getLootInfoGroupKeysForLootTableKey).distinct().map(lootInfoGroupKey -> this.getTooltipLineForLootInfoGroup((ResourceLocation)lootInfoGroupKey, itemResourceLocation)).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new));
            this.tooltipLinesCache.put(itemResourceLocation, calculatedResult);
            return calculatedResult;
        }

        @Nullable
        private String getTooltipLineForLootInfoGroup(ResourceLocation lootInfoGroupKey, ResourceLocation itemResourceLocation) {
            List<LootTableKeyLevelData> list = this.lootInfoMap.get((Object)lootInfoGroupKey).lootTableKeys.entrySet().stream().map(entry -> new LootTableKeyLevelData(((LootTableData)entry.getValue()).getLevel(), this.doesLootTableContainItem((ResourceLocation)entry.getKey(), itemResourceLocation))).sorted().toList();
            return this.getTooltipLineForLootInfoGroup(this.lootInfoMap.get(lootInfoGroupKey).getDisplay(), list);
        }

        public static void main(String[] args) {
            TooltipLinesProvider tooltipLinesProvider = new TooltipLinesProvider(Collections.emptyMap(), Collections.emptySet());
            System.out.println("Levels: 0");
            System.out.println(tooltipLinesProvider.getTooltipLineForLootInfoGroup("+", List.of(new LootTableKeyLevelData(0, true))));
            System.out.println();
            System.out.println("Levels: 0/1");
            System.out.println(tooltipLinesProvider.getTooltipLineForLootInfoGroup("+ -", List.of(new LootTableKeyLevelData(0, true), new LootTableKeyLevelData(1, false))));
            System.out.println();
            System.out.println("Levels: 0/10/20");
            System.out.println(tooltipLinesProvider.getTooltipLineForLootInfoGroup("+ - -", List.of(new LootTableKeyLevelData(0, true), new LootTableKeyLevelData(10, false), new LootTableKeyLevelData(20, false))));
            System.out.println();
            System.out.println("Levels: 0/10/20");
            System.out.println(tooltipLinesProvider.getTooltipLineForLootInfoGroup("- + +", List.of(new LootTableKeyLevelData(0, false), new LootTableKeyLevelData(10, true), new LootTableKeyLevelData(20, true))));
            System.out.println();
            System.out.println("Levels: 0/10/20");
            System.out.println(tooltipLinesProvider.getTooltipLineForLootInfoGroup("+ + -", List.of(new LootTableKeyLevelData(0, true), new LootTableKeyLevelData(10, true), new LootTableKeyLevelData(20, false))));
            System.out.println();
            System.out.println("Levels: 0/10/20");
            System.out.println(tooltipLinesProvider.getTooltipLineForLootInfoGroup("+ - +", List.of(new LootTableKeyLevelData(0, true), new LootTableKeyLevelData(10, false), new LootTableKeyLevelData(20, true))));
            System.out.println();
            System.out.println("Levels: 0/10/20/30/40/50");
            System.out.println(tooltipLinesProvider.getTooltipLineForLootInfoGroup("+ - + + - +", List.of(new LootTableKeyLevelData(0, true), new LootTableKeyLevelData(10, false), new LootTableKeyLevelData(20, true), new LootTableKeyLevelData(30, true), new LootTableKeyLevelData(40, false), new LootTableKeyLevelData(50, true))));
            System.out.println();
        }

        @Nullable
        private String getTooltipLineForLootInfoGroup(String displayName, List<LootTableKeyLevelData> list) {
            long tablesContainingItem = list.stream().filter(LootTableKeyLevelData::containsItem).count();
            if (tablesContainingItem == 0L) {
                return null;
            }
            if ((long)list.size() == tablesContainingItem) {
                return "%s (Level: %d+)".formatted(displayName, list.get((int)0).level);
            }
            int startLevel = -1;
            int rangesConcatenated = 0;
            StringBuilder stringBuilder = new StringBuilder(" (Level: ");
            for (int i = 0; i < list.size(); ++i) {
                LootTableKeyLevelData data = list.get(i);
                int currentLevel = data.level();
                if (data.containsItem() && startLevel < 0) {
                    startLevel = currentLevel;
                }
                if (!data.containsItem() && startLevel > -1) {
                    if (currentLevel - 1 > startLevel) {
                        stringBuilder.append(rangesConcatenated > 0 ? ", " : "").append("%d to %d".formatted(startLevel, currentLevel - 1));
                    } else {
                        stringBuilder.append(rangesConcatenated > 0 ? ", " : "").append("%d".formatted(startLevel));
                    }
                    ++rangesConcatenated;
                    startLevel = -1;
                }
                if (i != list.size() - 1) continue;
                if (startLevel > -1) {
                    stringBuilder.append(rangesConcatenated > 0 ? ", " : "").append("%d+".formatted(startLevel));
                    ++rangesConcatenated;
                }
                if (rangesConcatenated <= 0) continue;
                return displayName + String.valueOf(stringBuilder.append(")"));
            }
            return displayName + " (ERROR)";
        }

        private boolean doesLootTableContainItem(ResourceLocation lootTableKey, ResourceLocation itemResourceLocation) {
            return LootTableInfo.getItemsForLootTableKey(lootTableKey).contains(itemResourceLocation);
        }

        @NotNull
        private Stream<ResourceLocation> getLootInfoGroupKeysForLootTableKey(ResourceLocation lootTableKey) {
            return this.lootInfoMap.entrySet().stream().filter(entry -> ((LootInfo)entry.getValue()).getLootTableKeys().contains(lootTableKey)).map(Map.Entry::getKey).distinct();
        }

        private boolean isLootTableKeyDisplayAllowed(ResourceLocation lootTableKey) {
            return !this.excludeFromTooltipSet.contains(lootTableKey);
        }

        private record LootTableKeyLevelData(int level, boolean containsItem) implements Comparable<LootTableKeyLevelData>
        {
            @Override
            public int compareTo(@NotNull LootTableKeyLevelData o) {
                return Integer.compare(this.level, o.level);
            }
        }
    }

    public static class LootInfo {
        @Expose
        @SerializedName(value="display")
        private final String display;
        @Expose
        @SerializedName(value="lootTableKeys")
        private final Map<ResourceLocation, LootTableData> lootTableKeys;

        public LootInfo(String display, Map<ResourceLocation, LootTableData> lootTableKeys) {
            this.display = display;
            this.lootTableKeys = lootTableKeys;
        }

        public String getDisplay() {
            return this.display;
        }

        public Set<ResourceLocation> getLootTableKeys() {
            return this.lootTableKeys.keySet();
        }
    }

    public static class LootTableData {
        @Expose
        @SerializedName(value="level")
        private final int level;

        public LootTableData(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

