/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.item.Items;

public class MaterialBoxConfig
extends Config {
    @Expose
    public LevelEntryList<Level> LEVELS = new LevelEntryList();

    @Override
    public String getName() {
        return "material_box";
    }

    @Override
    protected void reset() {
        WeightedList<Group> pool = new WeightedList<Group>();
        pool.add(new Group(List.of(new ProductEntry(Items.f_41841_, 32, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42170_, 32, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41839_, 32, null))), 12);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41995_, 32, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42363_, 32, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151047_, 32, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42594_, 32, null))), 3);
        List<ProductEntry> concretePowderEntries = List.of(new ProductEntry(Items.f_42315_, 32, null), new ProductEntry(Items.f_42316_, 32, null), new ProductEntry(Items.f_42317_, 32, null), new ProductEntry(Items.f_42318_, 32, null), new ProductEntry(Items.f_42319_, 32, null), new ProductEntry(Items.f_42320_, 32, null), new ProductEntry(Items.f_42321_, 32, null), new ProductEntry(Items.f_42322_, 32, null), new ProductEntry(Items.f_42323_, 32, null), new ProductEntry(Items.f_42324_, 32, null), new ProductEntry(Items.f_42325_, 32, null), new ProductEntry(Items.f_42326_, 32, null), new ProductEntry(Items.f_42327_, 32, null), new ProductEntry(Items.f_42328_, 32, null), new ProductEntry(Items.f_42277_, 32, null), new ProductEntry(Items.f_42278_, 32, null));
        pool.add(new Group(concretePowderEntries), 12);
        List<ProductEntry> concreteEntries = List.of(new ProductEntry(Items.f_42246_, 32, null), new ProductEntry(Items.f_42247_, 32, null), new ProductEntry(Items.f_42248_, 32, null), new ProductEntry(Items.f_42249_, 32, null), new ProductEntry(Items.f_42303_, 32, null), new ProductEntry(Items.f_42304_, 32, null), new ProductEntry(Items.f_42305_, 32, null), new ProductEntry(Items.f_42306_, 32, null), new ProductEntry(Items.f_42307_, 32, null), new ProductEntry(Items.f_42308_, 32, null), new ProductEntry(Items.f_42309_, 32, null), new ProductEntry(Items.f_42310_, 32, null), new ProductEntry(Items.f_42311_, 32, null), new ProductEntry(Items.f_42312_, 32, null), new ProductEntry(Items.f_42313_, 32, null), new ProductEntry(Items.f_42314_, 32, null));
        pool.add(new Group(concreteEntries), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41842_, 32, null))), 8);
        List<ProductEntry> deepslateEntries = List.of(new ProductEntry(Items.f_151034_, 32, null), new ProductEntry(Items.f_151035_, 32, null));
        pool.add(new Group(deepslateEntries), 32);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42064_, 32, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42329_, 32, null))), 5);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151054_, 32, null))), 8);
        List<ProductEntry> glassEntries = List.of(new ProductEntry(Items.f_41904_, 32, null), new ProductEntry(Items.f_42212_, 32, null), new ProductEntry(Items.f_42213_, 32, null), new ProductEntry(Items.f_42214_, 32, null), new ProductEntry(Items.f_42215_, 32, null), new ProductEntry(Items.f_42216_, 32, null), new ProductEntry(Items.f_42217_, 32, null), new ProductEntry(Items.f_42218_, 32, null), new ProductEntry(Items.f_42219_, 32, null), new ProductEntry(Items.f_42220_, 32, null), new ProductEntry(Items.f_42221_, 32, null), new ProductEntry(Items.f_42222_, 32, null), new ProductEntry(Items.f_42171_, 32, null), new ProductEntry(Items.f_42172_, 32, null), new ProductEntry(Items.f_42173_, 32, null), new ProductEntry(Items.f_42174_, 32, null), new ProductEntry(Items.f_42175_, 32, null));
        pool.add(new Group(glassEntries), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41958_, 32, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41832_, 32, null))), 32);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41980_, 32, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41840_, 32, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151016_, 32, null))), 32);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41998_, 32, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42093_, 32, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41837_, 32, null))), 12);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42435_, 32, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42192_, 32, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151064_, 32, null))), 2);
        List<ProductEntry> sandEntries = List.of(new ProductEntry(Items.f_41830_, 32, null), new ProductEntry(Items.f_41831_, 32, null));
        pool.add(new Group(sandEntries), 32);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41994_, 32, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41838_, 32, null))), 12);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41905_, 32, null))), 3);
        List<ProductEntry> terracottaEntries = List.of(new ProductEntry(Items.f_42163_, 32, null), new ProductEntry(Items.f_42164_, 32, null), new ProductEntry(Items.f_42165_, 32, null), new ProductEntry(Items.f_42166_, 32, null), new ProductEntry(Items.f_42167_, 32, null), new ProductEntry(Items.f_42168_, 32, null), new ProductEntry(Items.f_42169_, 32, null), new ProductEntry(Items.f_42118_, 32, null), new ProductEntry(Items.f_42119_, 32, null), new ProductEntry(Items.f_42120_, 32, null), new ProductEntry(Items.f_42121_, 32, null), new ProductEntry(Items.f_42122_, 32, null), new ProductEntry(Items.f_42123_, 32, null), new ProductEntry(Items.f_42124_, 32, null), new ProductEntry(Items.f_42125_, 32, null), new ProductEntry(Items.f_42126_, 32, null), new ProductEntry(Items.f_42199_, 32, null));
        pool.add(new Group(terracottaEntries), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151048_, 32, null))), 8);
        List<ProductEntry> woolEntries = List.of(new ProductEntry(Items.f_41870_, 32, null), new ProductEntry(Items.f_41871_, 32, null), new ProductEntry(Items.f_41872_, 32, null), new ProductEntry(Items.f_41873_, 32, null), new ProductEntry(Items.f_41874_, 32, null), new ProductEntry(Items.f_41875_, 32, null), new ProductEntry(Items.f_41876_, 32, null), new ProductEntry(Items.f_41877_, 32, null), new ProductEntry(Items.f_41878_, 32, null), new ProductEntry(Items.f_41932_, 32, null), new ProductEntry(Items.f_41933_, 32, null), new ProductEntry(Items.f_41934_, 32, null), new ProductEntry(Items.f_41935_, 32, null), new ProductEntry(Items.f_41936_, 32, null), new ProductEntry(Items.f_41937_, 32, null), new ProductEntry(Items.f_41938_, 32, null));
        pool.add(new Group(woolEntries), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42051_, 32, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42755_, 32, null))), 6);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41843_, 32, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42754_, 32, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42258_, 32, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42259_, 32, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42048_, 32, null))), 32);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42783_, 32, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42049_, 32, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42050_, 32, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41844_, 32, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42260_, 32, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42102_, 32, null))), 5);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41999_, 32, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42004_, 32, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42412_, 16, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42500_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42533_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42526_, 16, null))), 8);
        List<ProductEntry> dyeEntries = List.of(new ProductEntry(Items.f_42535_, 16, null), new ProductEntry(Items.f_42536_, 16, null), new ProductEntry(Items.f_42537_, 16, null), new ProductEntry(Items.f_42538_, 16, null), new ProductEntry(Items.f_42539_, 16, null), new ProductEntry(Items.f_42540_, 16, null), new ProductEntry(Items.f_42489_, 16, null), new ProductEntry(Items.f_42490_, 16, null), new ProductEntry(Items.f_42491_, 16, null), new ProductEntry(Items.f_42492_, 16, null), new ProductEntry(Items.f_42493_, 16, null), new ProductEntry(Items.f_42494_, 16, null), new ProductEntry(Items.f_42495_, 16, null), new ProductEntry(Items.f_42496_, 16, null), new ProductEntry(Items.f_42497_, 16, null), new ProductEntry(Items.f_42498_, 16, null));
        pool.add(new Group(dyeEntries), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42521_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42402_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151056_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42403_, 16, null))), 6);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42787_, 16, null))), 3);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42784_, 16, null))), 3);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42532_, 16, null))), 6);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42454_, 16, null))), 6);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42715_, 8, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42714_, 16, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42675_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42529_, 16, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42649_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42648_, 16, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42579_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42581_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42658_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42485_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42697_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42583_, 16, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42527_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42518_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42591_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42401_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42528_, 16, null))), 5);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42279_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42585_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42586_, 16, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42542_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42679_, 4, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42584_, 16, null))), 4);
        List<ProductEntry> smallFlowerEntries = List.of(new ProductEntry(Items.f_41939_, 16, null), new ProductEntry(Items.f_41940_, 16, null), new ProductEntry(Items.f_41941_, 16, null), new ProductEntry(Items.f_41942_, 16, null), new ProductEntry(Items.f_41943_, 16, null), new ProductEntry(Items.f_41948_, 16, null), new ProductEntry(Items.f_41949_, 16, null), new ProductEntry(Items.f_41950_, 16, null));
        pool.add(new Group(smallFlowerEntries), 8);
        List<ProductEntry> largeFlowerEntries = List.of(new ProductEntry(Items.f_42206_, 16, null), new ProductEntry(Items.f_42208_, 16, null), new ProductEntry(Items.f_42209_, 16, null), new ProductEntry(Items.f_42207_, 16, null));
        pool.add(new Group(largeFlowerEntries), 10);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42410_, 16, null))), 12);
        List<ProductEntry> azaleaEntries = List.of(new ProductEntry(Items.f_151012_, 16, null), new ProductEntry(Items.f_151013_, 16, null));
        pool.add(new Group(azaleaEntries), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41911_, 16, null))), 12);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42732_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42733_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151018_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42460_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41952_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41982_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42619_, 16, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42461_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151079_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151025_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41910_, 16, null))), 16);
        List<ProductEntry> leavesEntries = List.of(new ProductEntry(Items.f_41896_, 16, null), new ProductEntry(Items.f_41897_, 16, null), new ProductEntry(Items.f_41898_, 16, null), new ProductEntry(Items.f_41899_, 16, null), new ProductEntry(Items.f_41900_, 16, null), new ProductEntry(Items.f_41901_, 16, null), new ProductEntry(Items.f_151009_, 16, null), new ProductEntry(Items.f_186362_, 16, null));
        pool.add(new Group(leavesEntries), 24);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42094_, 16, null))), 3);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42028_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42620_, 16, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42046_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41953_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41868_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41867_, 16, null))), 6);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42452_, 16, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41909_, 16, null))), 24);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42780_, 16, null))), 4);
        List<ProductEntry> tulipEntries = List.of(new ProductEntry(Items.f_41944_, 16, null), new ProductEntry(Items.f_41945_, 16, null), new ProductEntry(Items.f_41946_, 16, null), new ProductEntry(Items.f_41947_, 16, null));
        pool.add(new Group(tulipEntries), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42029_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42405_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42404_, 16, null))), 24);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41951_, 16, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41954_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42588_, 16, null))), 6);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41908_, 16, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41955_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41907_, 16, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42730_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151049_, 16, null))), 4);
        List<ProductEntry> coalEntries = List.of(new ProductEntry(Items.f_42413_, 16, null), new ProductEntry(Items.f_42414_, 16, null));
        pool.add(new Group(coalEntries), 24);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41863_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151052_, 16, null))), 32);
        List<ProductEntry> liveCoralEntries = List.of(new ProductEntry(Items.f_42291_, 8, null), new ProductEntry(Items.f_42292_, 8, null), new ProductEntry(Items.f_42293_, 8, null), new ProductEntry(Items.f_42294_, 8, null), new ProductEntry(Items.f_42290_, 8, null), new ProductEntry(Items.f_42300_, 8, null), new ProductEntry(Items.f_42301_, 8, null), new ProductEntry(Items.f_42302_, 8, null), new ProductEntry(Items.f_42356_, 8, null), new ProductEntry(Items.f_42357_, 8, null));
        pool.add(new Group(liveCoralEntries), 2);
        List<ProductEntry> deadCoralEntries = List.of(new ProductEntry(Items.f_42295_, 8, null), new ProductEntry(Items.f_42296_, 8, null), new ProductEntry(Items.f_42297_, 8, null), new ProductEntry(Items.f_42298_, 8, null), new ProductEntry(Items.f_42299_, 8, null), new ProductEntry(Items.f_42358_, 8, null), new ProductEntry(Items.f_42359_, 8, null), new ProductEntry(Items.f_42360_, 8, null), new ProductEntry(Items.f_42361_, 8, null), new ProductEntry(Items.f_42362_, 8, null));
        pool.add(new Group(deadCoralEntries), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42415_, 16, null))), 6);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42616_, 16, null))), 12);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42417_, 16, null))), 16);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42416_, 16, null))), 24);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42534_, 16, null))), 16);
        List<ProductEntry> musicDiscEntries = List.of(new ProductEntry(Items.f_42752_, 1, null), new ProductEntry(Items.f_42701_, 1, null), new ProductEntry(Items.f_42702_, 1, null), new ProductEntry(Items.f_42703_, 1, null), new ProductEntry(Items.f_42704_, 1, null), new ProductEntry(Items.f_42705_, 1, null), new ProductEntry(Items.f_42706_, 1, null), new ProductEntry(Items.f_42707_, 1, null), new ProductEntry(Items.f_42708_, 1, null), new ProductEntry(Items.f_42709_, 1, null), new ProductEntry(Items.f_42710_, 1, null), new ProductEntry(Items.f_42711_, 1, null), new ProductEntry(Items.f_186363_, 1, null), new ProductEntry(Items.f_42712_, 1, null));
        pool.add(new Group(musicDiscEntries), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42656_, 8, null))), 3);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151087_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42696_, 16, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42695_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42451_, 16, null))), 10);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42450_, 2, null))), 4);
        pool.add(new Group(List.of(new ProductEntry(Items.f_41902_, 16, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_151014_, 16, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42747_, 1, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42713_, 1, null))), 2);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42525_, 16, null))), 6);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42686_, 2, null))), 1);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42692_, 16, null))), 8);
        pool.add(new Group(List.of(new ProductEntry(Items.f_42003_, 8, null))), 2);
        this.LEVELS.clear();
        this.LEVELS.add(new Level(0, pool));
    }

    public WeightedList<Group> getGroups(int vaultLevel) {
        WeightedList<Group> result = new WeightedList<Group>();
        this.LEVELS.stream().filter(l -> vaultLevel >= l.level).sorted(Comparator.comparing(Level::getLevel)).forEach(l -> l.pool.forEach((group, weight) -> result.add((Group)group, weight.intValue())));
        return result;
    }

    public WeightedList<ProductEntry> getPool(int vaultLevel) {
        WeightedList<ProductEntry> result = new WeightedList<ProductEntry>();
        this.getGroups(vaultLevel).forEach((group, weight) -> {
            ProductEntry entry = group.getRandomEntry();
            if (entry != null) {
                result.add(entry, weight.intValue());
            }
        });
        return result;
    }

    public static class Group {
        @Expose
        public List<ProductEntry> entries = new ArrayList<ProductEntry>();

        public Group() {
        }

        public Group(List<ProductEntry> entries) {
            this.entries.addAll(entries);
        }

        public ProductEntry getRandomEntry() {
            if (this.entries.isEmpty()) {
                return null;
            }
            return this.entries.get(Config.rand.nextInt(this.entries.size()));
        }
    }

    public static class Level
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int level;
        @Expose
        public WeightedList<Group> pool = new WeightedList();

        public Level(int level, WeightedList<Group> pool) {
            this.level = level;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

