/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.EnchantedBookEntry;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public class OverLevelEnchantConfig
extends Config {
    @Expose
    private List<EnchantedBookEntry> BOOK_TIERS;

    public List<EnchantedBookEntry> getBookTiers() {
        return this.BOOK_TIERS;
    }

    public EnchantedBookEntry getTier(int overlevel) {
        for (EnchantedBookEntry tier : this.BOOK_TIERS) {
            if (tier.getExtraLevel() != overlevel) continue;
            return tier;
        }
        return null;
    }

    public MutableComponent getPrefixFor(int overlevel) {
        EnchantedBookEntry tier = this.getTier(overlevel);
        if (tier == null) {
            return null;
        }
        TextComponent prefix = new TextComponent(tier.getPrefix() + " ");
        prefix.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)tier.getColorHex())));
        return prefix;
    }

    public MutableComponent format(Component baseName, int overlevel) {
        EnchantedBookEntry tier = this.getTier(overlevel);
        if (tier == null) {
            return null;
        }
        MutableComponent prefix = new TextComponent(tier.getPrefix() + " ").m_7220_(baseName);
        prefix.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)tier.getColorHex())));
        return prefix;
    }

    @Override
    public String getName() {
        return "overlevel_enchant";
    }

    @Override
    protected void reset() {
        this.BOOK_TIERS = new LinkedList<EnchantedBookEntry>();
        this.BOOK_TIERS.add(new EnchantedBookEntry(1, 40, "Ancient", "#ffae00"));
        this.BOOK_TIERS.add(new EnchantedBookEntry(2, 60, "Super", "#ff6c00"));
        this.BOOK_TIERS.add(new EnchantedBookEntry(3, 80, "Legendary", "#ff3600"));
    }
}

