/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import net.minecraft.resources.ResourceLocation;

public class PersonalVaultConfig
extends Config {
    @Expose
    private RingCost ringCost1;
    @Expose
    private RingCost ringCost2;
    @Expose
    private RingCost ringCost3;
    @Expose
    private ResourceLocation inscriptionModifierPool;
    @Expose
    private ResourceLocation catalystModifierPool;

    @Override
    public String getName() {
        return "personal_vault";
    }

    @Override
    protected void reset() {
        this.ringCost1 = new RingCost(1, 100);
        this.ringCost2 = new RingCost(2, 200);
        this.ringCost3 = new RingCost(3, 300);
        this.inscriptionModifierPool = new ResourceLocation("the_vault:personal_vault_inscription");
        this.catalystModifierPool = new ResourceLocation("the_vault:personal_vault_catalyst");
    }

    public RingCost getRingCost(int ring) {
        return switch (ring) {
            case 1 -> this.ringCost1;
            case 2 -> this.ringCost2;
            case 3 -> this.ringCost3;
            default -> null;
        };
    }

    public ResourceLocation getInscriptionModifierPool() {
        return this.inscriptionModifierPool;
    }

    public ResourceLocation getCatalystModifierPool() {
        return this.catalystModifierPool;
    }

    public static class RingCost {
        @Expose
        private int prestigePoints;
        @Expose
        private int vaultGold;

        public RingCost(int prestigePoints, int vaultGold) {
            this.prestigePoints = prestigePoints;
            this.vaultGold = vaultGold;
        }

        public int getPrestigePointCost() {
            return this.prestigePoints;
        }

        public int getVaultGoldCost() {
            return this.vaultGold;
        }
    }
}

