/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.world.data.PlayerTitlesData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public class PlayerTitlesConfig
extends Config {
    @Expose
    private Map<Affix, Map<String, Title>> titles;

    @Override
    public String getName() {
        return "player_titles";
    }

    public Map<String, Title> getAll(Affix affix) {
        return this.titles.get((Object)affix);
    }

    public Optional<Title> get(Affix affix, String id) {
        return Optional.ofNullable(this.titles.get((Object)affix)).map(map -> (Title)map.get(id));
    }

    @Override
    protected void reset() {
        this.titles = new LinkedHashMap<Affix, Map<String, Title>>();
        Map prefixes = this.titles.computeIfAbsent(Affix.PREFIX, k -> new LinkedHashMap());
        prefixes.put("omega", new Title(1).put(PlayerTitlesData.Type.TAB_LIST, new Display("Omega ", "#AAAAAA")).put(PlayerTitlesData.Type.CHAT, new Display("Omega ", null)));
        prefixes.put("sir", new Title(1).put(PlayerTitlesData.Type.TAB_LIST, new Display("Sir ", "#AAAAAA")).put(PlayerTitlesData.Type.CHAT, new Display("Sir ", null)));
        Map suffixes = this.titles.computeIfAbsent(Affix.SUFFIX, k -> new LinkedHashMap());
        suffixes.put("of_doom", new Title(1).put(PlayerTitlesData.Type.TAB_LIST, new Display(" of Doom", "#AAAAAA")).put(PlayerTitlesData.Type.CHAT, new Display(" of Doom", null)));
        suffixes.put("the_great", new Title(1).put(PlayerTitlesData.Type.TAB_LIST, new Display(" the Great", "#AAAAAA")).put(PlayerTitlesData.Type.CHAT, new Display(" the Great", null)));
    }

    public static enum Affix {
        PREFIX,
        SUFFIX;

    }

    public static class Title {
        @Expose
        private final Map<PlayerTitlesData.Type, Display> display = new LinkedHashMap<PlayerTitlesData.Type, Display>();
        @Expose
        private final int cost;

        public Title() {
            this(1);
        }

        public Title(int cost) {
            this.cost = cost;
        }

        public Map<PlayerTitlesData.Type, Display> getDisplay() {
            return this.display;
        }

        public Display getDisplay(PlayerTitlesData.Type type) {
            return this.display.get((Object)type);
        }

        public int getCost() {
            return this.cost;
        }

        public Title put(PlayerTitlesData.Type type, Display display) {
            this.display.put(type, display);
            return this;
        }
    }

    public static class Display {
        @Expose
        private final String text;
        @Expose
        private final String color;

        public Display() {
            this("UNSPECIFIED", null);
        }

        public Display(String text, String color) {
            this.text = text;
            this.color = color;
        }

        public Optional<MutableComponent> getComponent() {
            if (this.text == null) {
                return Optional.empty();
            }
            TextComponent component = new TextComponent(this.text);
            if (this.color != null) {
                component.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)this.color)));
            }
            return Optional.of(component);
        }
    }
}

