/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.internal.LinkedTreeMap;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.roll.DoubleRoll;
import iskallia.vault.core.world.roll.FloatRoll;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.tool.ToolMaterial;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PreBuiltToolConfig
extends Config {
    @Expose
    private Map<String, Map<String, Map<String, Object>>> tools;

    @Override
    public String getName() {
        return "prebuilt_tools";
    }

    @Override
    protected void reset() {
        this.tools = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
    }

    public boolean apply(String key, ItemStack stack) {
        Map<String, Map<String, Object>> entry = this.tools.get(key);
        if (entry == null) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        entry.forEach((affixStr, attrs) -> {
            VaultGearModifier.AffixType type;
            if (affixStr.equalsIgnoreCase("tool_material")) {
                String value2 = attrs.get("value").toString();
                try {
                    ToolMaterial material = ToolMaterial.valueOf(value2);
                    data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<ToolMaterial>(ModGearAttributes.TOOL_MATERIAL, material));
                    data.setItemLevel(material.getLevel());
                    data.setRepairSlots(material.getRepairs());
                    data.createOrReplaceAttributeValue(ModGearAttributes.TOOL_CAPACITY, 0);
                    data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<Float>(ModGearAttributes.MINING_SPEED, Float.valueOf(material.getMiningSpeed())));
                    data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, material.getDurability()));
                    return;
                }
                catch (IllegalArgumentException e) {
                    VaultMod.LOGGER.warn("Unknown tool material {} in prebuilt tool {}", (Object)value2, (Object)key);
                    return;
                }
            }
            try {
                type = VaultGearModifier.AffixType.valueOf(affixStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                VaultMod.LOGGER.warn("Unknown affix type {} in prebuilt tool {}", affixStr, (Object)key);
                return;
            }
            attrs.forEach((attrKey, value) -> {
                if (attrKey.equalsIgnoreCase("value")) {
                    return;
                }
                ResourceLocation id = new ResourceLocation(attrKey);
                VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(id);
                if (attribute == null) {
                    VaultMod.LOGGER.warn("Unknown gear attribute {} in prebuilt tool {}", attrKey, (Object)key);
                    return;
                }
                try {
                    if (value instanceof LinkedTreeMap) {
                        LinkedTreeMap map = (LinkedTreeMap)value;
                        if (map.containsKey((Object)"roll_type")) {
                            JsonObject objectOfRoll = Config.GSON.toJsonTree((Object)map).getAsJsonObject();
                            if (map.get((Object)"roll_type").equals("int_roll")) {
                                IntRoll roll = Adapters.INT_ROLL.readJson((JsonElement)objectOfRoll).orElse(IntRoll.ofConstant(0));
                                value = roll.get(randSrc);
                            } else if (map.get((Object)"roll_type").equals("float_roll")) {
                                FloatRoll number = Adapters.FLOAT_ROLL.readJson((JsonElement)objectOfRoll).orElse(FloatRoll.ofConstant(0.0f));
                                value = Float.valueOf(number.get(randSrc));
                            } else if (map.get((Object)"roll_type").equals("double_roll")) {
                                DoubleRoll number = Adapters.DOUBLE_ROLL.readJson((JsonElement)objectOfRoll).orElse(DoubleRoll.ofConstant(0.0));
                                value = number.get(randSrc);
                            }
                        }
                    } else if (value.equals("random_boolean")) {
                        value = randSrc.nextBoolean();
                    }
                    Object cast = attribute.getType().cast(value);
                    data.addModifier(type, new VaultGearModifier(attribute, cast));
                }
                catch (ClassCastException ex) {
                    VaultMod.LOGGER.error("Failed to cast value {} for attribute {} in prebuilt tool {}", value, attrKey, (Object)key);
                }
            });
        });
        data.write(stack);
        return true;
    }

    public boolean hasId(String prebuiltId) {
        return this.tools.containsKey(prebuiltId);
    }

    public List<String> getKeys() {
        return this.tools.keySet().stream().toList();
    }
}

