/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.core.VaultLevelItem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RoyaleLootConfig
extends Config {
    @Expose
    public WeightedList<ResourceLocation> presets = new WeightedList();
    @Expose
    public int numberOfSelections = 3;

    @Override
    public String getName() {
        return "royale_loot";
    }

    @Override
    protected void reset() {
        this.presets = new WeightedList<ResourceLocation>(){
            {
                this.add(VaultMod.id("royale_crate"), 2);
            }
        };
        this.numberOfSelections = 3;
    }

    public List<List<ItemStack>> generate(Player player) {
        ArrayList<List<ItemStack>> selections = new ArrayList<List<ItemStack>>();
        ArrayList<ResourceLocation> usedPresets = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.numberOfSelections; ++i) {
            ArrayList loot = new ArrayList();
            Optional preset = this.presets.entrySet().stream().filter(e -> !usedPresets.contains(e.getKey())).collect(() -> new WeightedList(), (list, entry) -> list.put((ResourceLocation)entry.getKey(), (Double)entry.getValue()), AbstractMap::putAll).getRandom();
            if (preset.isEmpty()) continue;
            usedPresets.add((ResourceLocation)preset.get());
            LootTableKey table = VaultRegistry.LOOT_TABLE.getKey((ResourceLocation)preset.get());
            LootTableGenerator generator = new LootTableGenerator(Version.latest(), table, 0.0f);
            generator.setSource((Entity)player);
            generator.generate(JavaRandom.ofNanoTime());
            generator.getItems().forEachRemaining(item -> {
                item = DataTransferItem.doConvertStack(item);
                DataInitializationItem.doInitialize(item);
                if (VaultUtils.isVaultLevel(player.f_19853_)) {
                    VaultLevelItem.doInitializeVaultLoot(item, VaultUtils.getVault(player.f_19853_).orElse(null), null);
                }
                loot.add(item);
            });
            selections.add(loot);
        }
        return selections;
    }
}

