/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class RoyalePresetConfig
extends Config {
    @Expose
    public LevelEntryList<Level> LEVELS = new LevelEntryList();
    @Expose
    public int skillPresetSize;
    @Expose
    public int blueTrinketPresetSize;
    @Expose
    public int redTrinketPresetSize;

    @Override
    public String getName() {
        return "royale_presets";
    }

    public WeightedList<SkillPreset> getSkillPresets(int vaultLevel) {
        WeightedList<SkillPreset> result = new WeightedList<SkillPreset>();
        this.LEVELS.stream().filter(l -> vaultLevel >= l.level).sorted(Comparator.comparing(Level::getLevel)).forEach(l -> l.skillPresets.forEach((preset, weight) -> result.add((SkillPreset)preset, (Double)weight)));
        return result;
    }

    public WeightedList<ResourceLocation> getBlueTrinketPresets(int vaultLevel) {
        WeightedList<ResourceLocation> result = new WeightedList<ResourceLocation>();
        this.LEVELS.stream().filter(l -> vaultLevel >= l.level).sorted(Comparator.comparing(Level::getLevel)).forEach(l -> l.blueTrinketPresets.forEach((preset, weight) -> result.add((ResourceLocation)preset, (Double)weight)));
        return result;
    }

    public WeightedList<ResourceLocation> getRedTrinketPresets(int vaultLevel) {
        WeightedList<ResourceLocation> result = new WeightedList<ResourceLocation>();
        this.LEVELS.stream().filter(l -> vaultLevel >= l.level).sorted(Comparator.comparing(Level::getLevel)).forEach(l -> l.redTrinketPresets.forEach((preset, weight) -> result.add((ResourceLocation)preset, (Double)weight)));
        return result;
    }

    public Map<String, Map<String, Integer>> generatePresets(int vaultLevel) {
        ArrayList presets = new ArrayList();
        for (int i = 0; i < this.skillPresetSize; ++i) {
            Optional<SkillPreset> preset2 = this.getRandomSkillPreset(presets.stream().map(SkillPreset::getName).toList(), vaultLevel);
            preset2.ifPresent(presets::add);
        }
        Map<String, Map<String, Integer>> presetMap = presets.stream().collect(Collectors.toMap(SkillPreset::getName, preset -> {
            Map<String, Integer> abilityMap = preset.abilities.stream().collect(Collectors.toMap(SkillEntry::getId, entry -> entry.level.get(randSrc)));
            Map<String, Integer> talentMap = preset.talents.stream().collect(Collectors.toMap(SkillEntry::getId, entry -> entry.level.get(randSrc)));
            abilityMap.putAll(talentMap);
            return abilityMap;
        }));
        return presetMap;
    }

    public Optional<SkillPreset> getRandomSkillPreset(int level) {
        return this.getSkillPresets(level).getRandom(randSrc);
    }

    public Optional<SkillPreset> getRandomSkillPreset(List<String> existing, int level) {
        WeightedList availablePresets = new WeightedList();
        this.getSkillPresets(level).forEach((preset, weight) -> {
            if (!existing.contains(preset.name)) {
                availablePresets.put(preset, (Double)weight);
            }
        });
        return availablePresets.getRandom(randSrc);
    }

    public Optional<ResourceLocation> getRandomBlueTrinketPreset(int level) {
        return this.getBlueTrinketPresets(level).getRandom(randSrc);
    }

    public Optional<ResourceLocation> getRandomRedTrinketPreset(int level) {
        return this.getRedTrinketPresets(level).getRandom(randSrc);
    }

    public static List<SkillEntry> getAbilities(SkillPreset preset) {
        return preset.abilities;
    }

    public static List<SkillEntry> getTalents(SkillPreset preset) {
        return preset.talents;
    }

    public static void apply(ServerPlayer player, String presetKey, Map<String, Integer> preset) {
        SkillPreset skillPreset = ModConfigs.PRESET_CONFIG.getSkillPreset(presetKey);
        if (skillPreset == null) {
            return;
        }
        AbilityTree tree = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        TalentTree talents = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
        SkillContext context = SkillContext.of(player);
        int totalSkillPoints = RoyalePresetConfig.getLearnCost(presetKey, preset);
        if (context.getLearnPoints() < totalSkillPoints) {
            VaultMod.LOGGER.warn("Not enough skill points to apply preset: {}. Required: {}, Available: {}", (Object)presetKey, (Object)totalSkillPoints, (Object)context.getLearnPoints());
            return;
        }
        for (SkillEntry entry : skillPreset.abilities) {
            tree.getForId(entry.id).ifPresent(skill -> {
                if (skill instanceof TieredSkill) {
                    TieredSkill tiered = (TieredSkill)skill;
                    int target = (Integer)preset.get(entry.id);
                    for (int i = 0; i < target; ++i) {
                        tree.learn(entry.id, context);
                    }
                    tree.specialize(entry.id, context);
                }
            });
        }
        for (SkillEntry entry : skillPreset.talents) {
            talents.getForId(entry.id).ifPresent(skill -> {
                if (skill instanceof TieredSkill) {
                    TieredSkill tiered = (TieredSkill)skill;
                    int target = (Integer)preset.get(entry.id);
                    for (int i = 0; i < target; ++i) {
                        talents.learn(entry.id, context);
                    }
                }
            });
        }
        PlayerAbilitiesData.get(player.m_183503_()).setAbilities((Player)player, tree);
        PlayerTalentsData.get(player.m_183503_()).setTalents((Player)player, talents);
        PlayerVaultStatsData.get(player.m_183503_()).getVaultStats((Player)player).setSkillPoints(context.getLearnPoints());
    }

    public static int getLearnCost(String presetKey, Map<String, Integer> preset) {
        LearnableSkill learnableSkill;
        TieredSkill tieredSkill;
        Skill skill;
        SkillPreset skillPreset = ModConfigs.PRESET_CONFIG.getSkillPreset(presetKey);
        if (skillPreset == null) {
            return 0;
        }
        int cost = 0;
        for (SkillEntry entry : skillPreset.abilities) {
            if (!preset.containsKey(entry.id) || (skill = (Skill)ModConfigs.ABILITIES.getAbilityById(entry.id).orElse(null)) == null) continue;
            if (skill instanceof TieredSkill) {
                tieredSkill = (TieredSkill)skill;
                cost += tieredSkill.getSpentLearnPoints(preset.get(entry.id));
                continue;
            }
            if (!(skill instanceof LearnableSkill)) continue;
            learnableSkill = (LearnableSkill)skill;
            cost += learnableSkill.getSpentLearnPoints();
        }
        for (SkillEntry entry : skillPreset.talents) {
            if (!preset.containsKey(entry.id) || (skill = (Skill)ModConfigs.TALENTS.getTalentById(entry.id).orElse(null)) == null) continue;
            if (skill instanceof TieredSkill) {
                tieredSkill = (TieredSkill)skill;
                cost += tieredSkill.getSpentLearnPoints(preset.get(entry.id));
                continue;
            }
            if (!(skill instanceof LearnableSkill)) continue;
            learnableSkill = (LearnableSkill)skill;
            cost += learnableSkill.getSpentLearnPoints();
        }
        return cost;
    }

    @Override
    protected void reset() {
        this.LEVELS.clear();
        Level level0 = new Level(0);
        WeightedList<SkillPreset> SKILL_PRESETS = level0.skillPresets;
        WeightedList<Object> BLUE_TRINKET_PRESETS = level0.blueTrinketPresets;
        WeightedList<Object> RED_TRINKET_PRESETS = level0.redTrinketPresets;
        SkillPreset skillPreset = new SkillPreset();
        skillPreset.name = "Nucleus";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Nova_Base", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Taunt_Base", IntRoll.ofUniform(1, 4)));
        skillPreset.abilities.add(new SkillEntry("Smite_Base", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Last_Stand", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Methodical", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Prime_Amplification", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Nucleus", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Lightning_Stun", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Stoneskin", IntRoll.ofUniform(1, 2)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Arcane";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Arcane_Base", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Haste", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Blazing", IntRoll.ofUniform(2, 4)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Nova Archon";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Nova_Base", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Smite_Archon", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Last_Stand", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Methodical", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Daze", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Lightning_Stun", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Stoneskin", IntRoll.ofUniform(1, 2)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Freezing Rail";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Arcane_Rail", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Empower_Slowness_Aura", IntRoll.ofUniform(1, 4)));
        skillPreset.abilities.add(new SkillEntry("Nova_Frost", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Haste", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Blizzard", IntRoll.ofUniform(1, 2)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Frost Enjoy";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Nova_Frost", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Storm_Arrow_Blizzard", IntRoll.ofUniform(2, 6)));
        skillPreset.abilities.add(new SkillEntry("Ice_Bolt_Blast", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Stonefall_Cold", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Blizzard", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Blazing", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 1)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Glacial";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Nova_Frost", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Ice_Bolt_Base", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Storm_Arrow_Blizzard", IntRoll.ofUniform(2, 6)));
        skillPreset.abilities.add(new SkillEntry("Stonefall_Cold", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Frostbite", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Cleave", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Stoneskin", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(2, 4)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Implode";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Implode", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Mana_Steal", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Depleted", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Prime_Amplification", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(1, 4)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Shotgun";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Javelin_Scatter", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Mana_Steal", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Javelin_Damage", IntRoll.ofUniform(2, 3)));
        skillPreset.talents.add(new SkillEntry("Javelin_Frugal", IntRoll.ofUniform(1, 3)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Lucky_Momentum", IntRoll.ofUniform(1, 2)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Fireball";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Fireball_Base", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Nova_Base", IntRoll.ofUniform(2, 6)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Methodical", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Prime_Amplification", IntRoll.ofUniform(1, 8)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Fireshot";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Fireball_Fireshot", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Nova_Base", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Nucleus", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Prime_Amplification", IntRoll.ofUniform(1, 8)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Frozen Pierce";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Javelin_Piercing", IntRoll.ofUniform(1, 2)));
        skillPreset.abilities.add(new SkillEntry("Nova_Frost", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Frostbite", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Depleted", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Javelin_Throw_Power", IntRoll.ofUniform(1, 2)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Slaughter";
        skillPreset.abilities.add(new SkillEntry("Dash_Damage", IntRoll.ofUniform(4, 7)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Rampage_Base", IntRoll.ofUniform(2, 4)));
        skillPreset.abilities.add(new SkillEntry("Totem_Player_Damage", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Cleave", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Fatal_Strike", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Life_Steal", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Depleted", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 2)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Tank";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Totem_Base", IntRoll.ofUniform(1, 8)));
        skillPreset.abilities.add(new SkillEntry("Empower_Slowness_Aura", IntRoll.ofUniform(1, 4)));
        skillPreset.abilities.add(new SkillEntry("Shell_Base", IntRoll.ofUniform(1, 8)));
        skillPreset.abilities.add(new SkillEntry("Stonefall_Base", IntRoll.ofUniform(2, 2)));
        skillPreset.talents.add(new SkillEntry("Last_Stand", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Methodical", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Stoneskin", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Daze", IntRoll.ofUniform(1, 4)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Conducting Pierce";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Javelin_Piercing", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Javelin_Conduct", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Javelin_Frugal", IntRoll.ofUniform(1, 3)));
        skillPreset.talents.add(new SkillEntry("Javelin_Damage", IntRoll.ofUniform(2, 6)));
        skillPreset.talents.add(new SkillEntry("Javelin_Throw_Power", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Depleted", IntRoll.ofUniform(1, 2)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Super Mario";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Stonefall_Snow", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Mega_Jump_Base", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Last_Stand", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Prime_Amplification", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Stoneskin", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(4, 8)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Toxic";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Nova_Dot", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Totem_Mana_Regen ", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Prime_Amplification", IntRoll.ofUniform(1, 8)));
        skillPreset.talents.add(new SkillEntry("Toxic_Reaction", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(4, 8)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Blight";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Nova_Dot", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Arcane_Base", IntRoll.ofUniform(1, 6)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Prime_Amplification", IntRoll.ofUniform(1, 8)));
        skillPreset.talents.add(new SkillEntry("Blight", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(4, 8)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Pacifist";
        skillPreset.abilities.add(new SkillEntry("Dash_Warp", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Empower_Base", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Stonefall_Base", IntRoll.ofUniform(2, 2)));
        skillPreset.abilities.add(new SkillEntry("Hunter_Base  ", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Ghost_Walk_Base", IntRoll.ofUniform(1, 2)));
        skillPreset.abilities.add(new SkillEntry("Ice_Bolt_Base", IntRoll.ofUniform(1, 2)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Stoneskin", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(2, 2)));
        skillPreset.talents.add(new SkillEntry("Sorcery", IntRoll.ofUniform(4, 8)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Dazer";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Shell_Base", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Totem_Player_Damage", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Mana_Shield_Base", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Daze", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Cleave", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Fatal_Strike", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Mana_Steal", IntRoll.ofUniform(1, 1)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Retribution";
        skillPreset.abilities.add(new SkillEntry("Dash_Damage", IntRoll.ofUniform(4, 7)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Shield_Bash", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Totem_Base  ", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Battle_Cry_Base", IntRoll.ofUniform(1, 4)));
        skillPreset.abilities.add(new SkillEntry("Smite_Base", IntRoll.ofUniform(2, 6)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Last_Stand", IntRoll.ofUniform(2, 4)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Archon";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Smite_Archon", IntRoll.ofUniform(4, 8)));
        skillPreset.abilities.add(new SkillEntry("Totem_Mana_Regen  ", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Intelligence", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Arcana", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Prime_Amplification", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Daze", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Lightning_Stun", IntRoll.ofUniform(4, 8)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 1)));
        SKILL_PRESETS.put(skillPreset, 1);
        skillPreset = new SkillPreset();
        skillPreset.name = "Purist";
        skillPreset.abilities.add(new SkillEntry("Dash_Base", IntRoll.ofUniform(1, 3)));
        skillPreset.abilities.add(new SkillEntry("Vein_Miner_Base", IntRoll.ofUniform(1, 1)));
        skillPreset.abilities.add(new SkillEntry("Javelin_Base", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Purist", IntRoll.ofUniform(2, 4)));
        skillPreset.talents.add(new SkillEntry("Strength", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Frenzy", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Speed", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Haste", IntRoll.ofUniform(1, 2)));
        skillPreset.talents.add(new SkillEntry("Lucky_Momentum", IntRoll.ofUniform(1, 4)));
        skillPreset.talents.add(new SkillEntry("Cleave", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Fatal_Strike", IntRoll.ofUniform(1, 1)));
        skillPreset.talents.add(new SkillEntry("Javelin_Damage", IntRoll.ofUniform(4, 8)));
        SKILL_PRESETS.put(skillPreset, 1);
        BLUE_TRINKET_PRESETS = new WeightedList();
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("aether"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("cat_in_a_jar"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("carapace"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("chromatic_feather"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("centipede_feet"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("elven_socks"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("ender_anchor"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("gluttony_pendant"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("high_heels"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("night_vision_goggles"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("shadow_cloak"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("slimey"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("stone_of_jordan"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("the_dice"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("velaras_petal"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("wendarrs_hourglass"), 1);
        BLUE_TRINKET_PRESETS.put((Object)VaultMod.id("wings"), 1);
        RED_TRINKET_PRESETS = new WeightedList();
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("giants_heart"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("chromatic_powder"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("cufflinks"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("golden_burger"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("healing_salve"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("clover"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("crystal_ball"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("idonas_blade"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("lucky_goose"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("phylactery"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("spellbook"), 1);
        RED_TRINKET_PRESETS.put((Object)VaultMod.id("tenos_charm"), 1);
        this.skillPresetSize = 5;
        this.blueTrinketPresetSize = 5;
        this.redTrinketPresetSize = 5;
        this.LEVELS.add(level0);
    }

    public List<ResourceLocation> getRandomBlueTrinketPresets(int level) {
        ArrayList<ResourceLocation> presets = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.blueTrinketPresetSize; ++i) {
            Optional<ResourceLocation> preset = this.getRandomBlueTrinketPreset(presets, level);
            preset.ifPresent(presets::add);
        }
        return presets;
    }

    public Optional<ResourceLocation> getRandomBlueTrinketPreset(List<ResourceLocation> existing, int level) {
        WeightedList availablePresets = new WeightedList();
        this.getBlueTrinketPresets(level).forEach((preset, weight) -> {
            if (!existing.contains(preset)) {
                availablePresets.put(preset, (Double)weight);
            }
        });
        return availablePresets.getRandom(randSrc);
    }

    public List<ResourceLocation> getRandomRedTrinketPresets(int level) {
        ArrayList<ResourceLocation> presets = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.redTrinketPresetSize; ++i) {
            Optional<ResourceLocation> preset = this.getRandomRedTrinketPreset(presets, level);
            preset.ifPresent(presets::add);
        }
        return presets;
    }

    public Optional<ResourceLocation> getRandomRedTrinketPreset(List<ResourceLocation> existing, int level) {
        WeightedList availablePresets = new WeightedList();
        this.getRedTrinketPresets(level).forEach((preset, weight) -> {
            if (!existing.contains(preset)) {
                availablePresets.put(preset, (Double)weight);
            }
        });
        return availablePresets.getRandom(randSrc);
    }

    public SkillPreset getSkillPreset(String preset) {
        return this.LEVELS.stream().flatMap(l -> l.skillPresets.keySet().stream()).filter(p -> p.name.equals(preset)).findFirst().orElse(null);
    }

    public List<SkillPreset> getAllSkillPresets() {
        return this.LEVELS.stream().flatMap(l -> l.skillPresets.keySet().stream()).toList();
    }

    public static class SkillPreset {
        @Expose
        public String name = "";
        @Expose
        public List<SkillEntry> abilities = new ArrayList<SkillEntry>();
        @Expose
        public List<SkillEntry> talents = new ArrayList<SkillEntry>();
        @Expose
        public DescriptionData description = DescriptionData.getDefault("royale_preset");

        public String getName() {
            return this.name;
        }
    }

    public static class SkillEntry {
        @Expose
        public String id;
        @Expose
        public IntRoll level;

        public SkillEntry(String id, IntRoll level) {
            this.id = id;
            this.level = level;
        }

        public SkillEntry() {
        }

        public String getId() {
            return this.id;
        }
    }

    public static class Level
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int level;
        @Expose
        public WeightedList<SkillPreset> skillPresets = new WeightedList();
        @Expose
        public WeightedList<ResourceLocation> blueTrinketPresets = new WeightedList();
        @Expose
        public WeightedList<ResourceLocation> redTrinketPresets = new WeightedList();

        public Level(int level) {
            this.level = level;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

