/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.objective.scavenger.ChestScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.CoinStacksScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.MobScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.OreScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.roll.IntRoll;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ScavengerConfig
extends Config {
    @Expose
    private List<ScavengeTask> tasks;
    @Expose
    private LevelEntryList<Entry> levels;

    @Override
    public String getName() {
        return "scavenger";
    }

    public List<ScavengeTask> getTasks() {
        return this.tasks;
    }

    public List<ScavengerGoal> generateGoals(int level, RandomSource random) {
        ArrayList<ScavengerGoal> result = new ArrayList<ScavengerGoal>();
        ArrayList<ScavengeTask> tasks = new ArrayList<ScavengeTask>(this.tasks);
        Entry entry = this.levels.getForLevel(level).orElse(null);
        if (entry == null) {
            return result;
        }
        int rolls = entry.goalCount.get(random);
        for (int i = 0; i < rolls && !tasks.isEmpty(); ++i) {
            int n = random.nextInt(tasks.size());
            ScavengeTask task = (ScavengeTask)tasks.get(n);
            task.generateGoal(entry.itemCount.get(random), random).ifPresent(goal -> {
                result.add((ScavengerGoal)goal);
                tasks.remove(n);
            });
        }
        return result;
    }

    public HashMap<Item, Integer> getNameColors() {
        HashMap<Item, Integer> nameColors = new HashMap<Item, Integer>();
        for (ScavengeTask task : this.tasks) {
            Object taskEntry;
            if (task instanceof ChestScavengerTask) {
                ChestScavengerTask scavengeTask = (ChestScavengerTask)task;
                for (Map.Entry<Object, Double> entry : scavengeTask.entries.entrySet()) {
                    taskEntry = (ChestScavengerTask.Entry)entry.getKey();
                    nameColors.put(((ChestScavengerTask.Entry)taskEntry).item.m_41720_(), ((ChestScavengerTask.Entry)taskEntry).color);
                }
                continue;
            }
            if (task instanceof CoinStacksScavengerTask) {
                CoinStacksScavengerTask scavengeTask = (CoinStacksScavengerTask)task;
                for (Map.Entry<Object, Double> entry : scavengeTask.entries.entrySet()) {
                    taskEntry = (CoinStacksScavengerTask.Entry)entry.getKey();
                    nameColors.put(((CoinStacksScavengerTask.Entry)taskEntry).item.m_41720_(), ((CoinStacksScavengerTask.Entry)taskEntry).color);
                }
                continue;
            }
            if (task instanceof OreScavengerTask) {
                OreScavengerTask scavengeTask = (OreScavengerTask)task;
                for (Map.Entry entry : scavengeTask.entries.entrySet()) {
                    taskEntry = (OreScavengerTask.Entry)entry.getKey();
                    nameColors.put(((OreScavengerTask.Entry)taskEntry).item.m_41720_(), ((OreScavengerTask.Entry)taskEntry).color);
                }
                continue;
            }
            if (!(task instanceof MobScavengerTask)) continue;
            MobScavengerTask scavengeTask = (MobScavengerTask)task;
            for (MobScavengerTask.Entry entry : scavengeTask.entries) {
                nameColors.put(entry.item.m_41720_(), Color.WHITE.getRGB());
            }
        }
        return nameColors;
    }

    @Override
    protected void reset() {
        this.tasks = new ArrayList<ScavengeTask>();
        this.levels = new LevelEntryList();
        this.tasks.add(new ChestScavengerTask(TilePredicate.of("the_vault:wooden_chest", true).orElse(PartialTile.ERROR), 0.5, VaultMod.id("gui/scav/wooden_chest"), new WeightedList<ChestScavengerTask.Entry>().add(new ChestScavengerTask.Entry(new ItemStack((ItemLike)Items.f_41873_), 1.0, 0xFFFFFF), 8).add(new ChestScavengerTask.Entry(new ItemStack((ItemLike)Items.f_41874_), 1.0, 0xFFFFFF), 4).add(new ChestScavengerTask.Entry(new ItemStack((ItemLike)Items.f_41933_), 1.0, 0xFFFFFF), 2).add(new ChestScavengerTask.Entry(new ItemStack((ItemLike)Items.f_41875_), 1.0, 0xFFFFFF), 1)));
        this.tasks.add(new CoinStacksScavengerTask(0.5, VaultMod.id("gui/scav/wooden_chest"), new WeightedList<CoinStacksScavengerTask.Entry>().add(new CoinStacksScavengerTask.Entry(new ItemStack((ItemLike)Items.f_41873_), 1.0, 0xFFFFFF), 8).add(new CoinStacksScavengerTask.Entry(new ItemStack((ItemLike)Items.f_41874_), 1.0, 0xFFFFFF), 4).add(new CoinStacksScavengerTask.Entry(new ItemStack((ItemLike)Items.f_41933_), 1.0, 0xFFFFFF), 2).add(new CoinStacksScavengerTask.Entry(new ItemStack((ItemLike)Items.f_41875_), 1.0, 0xFFFFFF), 1)));
        this.tasks.add(new MobScavengerTask(0.5, VaultMod.id("gui/scav/wooden_chest"), 0xFFFFFF, new MobScavengerTask.Entry(new ItemStack((ItemLike)Items.f_42436_), 1.0, EntityPredicate.of("@the_vault:mobs", true).orElseThrow())));
        this.levels.add(new Entry(0, IntRoll.ofUniform(2, 6), IntRoll.ofUniform(4, 10)));
    }

    private static class Entry
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private IntRoll goalCount;
        @Expose
        private IntRoll itemCount;

        public Entry(int level, IntRoll goalCount, IntRoll itemCount) {
            this.level = level;
            this.goalCount = goalCount;
            this.itemCount = itemCount;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

