/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class TemporalShardConfig
extends Config {
    private static final ResourceLocation DEFAULT = VaultMod.id("overpower");
    private static final int DEFAULT_DURATION = 6000;
    private static final int DEFAULT_WEIGHT = 50;
    @Expose
    private float dropChance;
    @Expose
    private float uberChance;
    @Expose
    private LevelEntryList<Level> modifiers;

    @Override
    public String getName() {
        return "temporal_shard";
    }

    @Override
    protected void reset() {
        this.dropChance = 0.05f;
        this.uberChance = 0.25f;
        this.modifiers = new LevelEntryList();
        Level level0 = new Level(0, new ArrayList<ModifierEntry>());
        ModifierEntry entry = new ModifierEntry();
        List<String> modifierIds = List.of("overpower", "champion_domain", "loot_goblin", "door_hunter", "ultimate_regeneration", "kill_nuke", "kill_charm", "kill_hunter", "kill_totem", "bronze_nuke", "glued_mobs", "rock_solid", "pylon_hunter", "soul_fest");
        for (String id : modifierIds) {
            entry.add(VaultMod.id(id), 50, 6000);
        }
        level0.entries.add(entry);
        this.modifiers.add(level0);
    }

    public float getDropChance() {
        return this.dropChance;
    }

    public float getUberChance() {
        return this.uberChance;
    }

    public ModifierInfo getRandomModifier(int level, RandomSource random) {
        Level modifiers = this.modifiers.getForLevel(level).orElse(Level.EMPTY);
        if (modifiers.entries.isEmpty()) {
            return this.getDefault();
        }
        int entryID = random.nextInt(modifiers.entries.size());
        ModifierEntry entry = modifiers.entries.get(entryID);
        Optional<ModifierEntry.WeightedModifier> randomEntry = entry.modifiers.getRandom(random);
        if (randomEntry.isPresent()) {
            ModifierEntry.WeightedModifier weightedModifier = randomEntry.get();
            ResourceLocation id = weightedModifier.modifier;
            int duration = weightedModifier.duration;
            return VaultModifierRegistry.getOpt(id).map(modifier -> new ModifierInfo(id, (VaultModifier<?>)modifier, duration)).orElseGet(this::getDefault);
        }
        return this.getDefault();
    }

    public Set<ResourceLocation> getAllModifiers() {
        HashSet<ResourceLocation> modifiers = new HashSet<ResourceLocation>();
        for (Level level : this.modifiers) {
            for (ModifierEntry entry : level.entries) {
                for (Map.Entry<ModifierEntry.WeightedModifier, Double> weightedEntry : entry.modifiers.entrySet()) {
                    modifiers.add(weightedEntry.getKey().modifier);
                }
            }
        }
        return modifiers;
    }

    private ModifierInfo getDefault() {
        return VaultModifierRegistry.getOpt(DEFAULT).map(modifier -> new ModifierInfo(DEFAULT, (VaultModifier<?>)modifier, 6000)).orElseThrow(() -> new IllegalStateException("why did you delete all modifiers and the default modifier? (" + String.valueOf(DEFAULT) + ")"));
    }

    public static class Level
    implements LevelEntryList.ILevelEntry {
        public static final Level EMPTY = new Level(0, new ArrayList<ModifierEntry>());
        @Expose
        public int level;
        @Expose
        public List<ModifierEntry> entries;

        public Level(int level, List<ModifierEntry> entries) {
            this.level = level;
            this.entries = entries;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    public static class ModifierEntry {
        @Expose
        public WeightedList<WeightedModifier> modifiers = new WeightedList();

        public ModifierEntry add(ResourceLocation id, int weight, int duration) {
            this.modifiers.add(new WeightedModifier(id, duration), weight);
            return this;
        }

        public static class WeightedModifier {
            @Expose
            public ResourceLocation modifier;
            @Expose
            public int duration;

            public WeightedModifier(ResourceLocation value, int duration) {
                this.modifier = value;
                this.duration = duration;
            }
        }
    }

    public record ModifierInfo(ResourceLocation id, VaultModifier<?> modifier, int duration) {
        public ResourceLocation getId() {
            return this.id;
        }

        public VaultModifier<?> getModifier() {
            return this.modifier;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

