/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.DescriptionData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class ThemeAugmentLoreConfig
extends Config {
    @Expose
    public Map<String, AugmentLore> series;
    @Expose
    public Map<String, List<ResourceLocation>> augments;

    @Override
    protected void reset() {
        this.series = new HashMap<String, AugmentLore>();
        this.series.put("plastic", new AugmentLore("Plastic", new DescriptionData[]{DescriptionData.getDefault("Classic Vault Plastic")}, 0xFFFFFF));
        this.augments = new HashMap<String, List<ResourceLocation>>(){
            {
                this.put("plastic", List.of(new ResourceLocation("the_vault", "classic_vault_plastic")));
            }
        };
    }

    @Override
    public String getName() {
        return "theme_augment_lore";
    }

    public Optional<AugmentLore> getAugmentLore(ResourceLocation augmentId) {
        for (Map.Entry<String, List<ResourceLocation>> entry : this.augments.entrySet()) {
            if (!entry.getValue().contains(augmentId)) continue;
            return Optional.ofNullable(this.series.get(entry.getKey()));
        }
        return Optional.empty();
    }

    public static class AugmentLore {
        @Expose
        public String displayName;
        @Expose
        public DescriptionData[] description;
        @Expose
        public int colour;

        public AugmentLore(String displayName, DescriptionData[] description, int colour) {
            this.displayName = displayName;
            this.description = description;
            this.colour = colour;
        }

        public static AugmentLore empty() {
            return new AugmentLore("Unknown", new DescriptionData[0], 0xFFFFFF);
        }
    }
}

