/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.DescriptionData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class UniqueCodexConfig
extends Config {
    @Expose
    private IntroductionPage introduction;
    @Expose
    private List<UniqueCodexPage> pages;

    @Override
    public String getName() {
        return "unique_codex";
    }

    @Override
    protected void reset() {
        this.introduction = new IntroductionPage(DescriptionData.getDefault("introduction"), Map.of(IntroductionPage.SlotType.HEAD, List.of(VaultMod.id("unique_model_id")), IntroductionPage.SlotType.CHEST, List.of(VaultMod.id("unique_model_id"))));
        this.pages = new ArrayList<UniqueCodexPage>();
        this.pages.add(new UniqueCodexPage(DescriptionData.of(new TextComponent("Jester Hat")), DescriptionData.getDefault("jester hat unique"), VaultMod.id("jester")));
        this.pages.add(new UniqueCodexPage(DescriptionData.of(new TextComponent("The Castle")), DescriptionData.getDefault("castle unique"), VaultMod.id("castle")));
    }

    public List<UniqueCodexPage> getPages() {
        return this.pages;
    }

    public IntroductionPage getIntroduction() {
        return this.introduction;
    }

    public int getPageIndex(ResourceLocation uniqueId) {
        return this.pages.indexOf(this.pages.stream().filter(page -> page.getUniqueId().equals((Object)uniqueId)).findFirst().orElse(null));
    }

    public UniqueCodexPage getPage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            return null;
        }
        return this.pages.get(index);
    }

    public static class IntroductionPage {
        @Expose
        private DescriptionData description;
        @Expose
        private Map<SlotType, List<ResourceLocation>> index;

        public IntroductionPage(DescriptionData description, Map<SlotType, List<ResourceLocation>> index) {
            this.description = description;
            this.index = index;
        }

        public MutableComponent getDescription() {
            return this.description.getComponent();
        }

        public DescriptionData getDescriptionData() {
            return this.description;
        }

        public Map<SlotType, List<ResourceLocation>> getIndex() {
            return this.index;
        }

        public static enum SlotType {
            HEAD,
            CHEST,
            LEGS,
            FEET,
            SWORD,
            AXE,
            OFFHAND,
            SHIELD,
            WAND,
            FOCUS,
            JEWEL;

        }
    }

    public static class UniqueCodexPage {
        @Expose
        public DescriptionData title;
        @Expose
        public DescriptionData description;
        @Expose
        public ResourceLocation uniqueId;
        @Expose
        public boolean isNewInUpdate;

        public UniqueCodexPage(DescriptionData title, DescriptionData description, ResourceLocation uniqueId) {
            this.title = title;
            this.description = description;
            this.uniqueId = uniqueId;
            this.isNewInUpdate = false;
        }

        public UniqueCodexPage(DescriptionData title, DescriptionData description, ResourceLocation uniqueId, boolean isNewInUpdate) {
            this.title = title;
            this.description = description;
            this.uniqueId = uniqueId;
            this.isNewInUpdate = isNewInUpdate;
        }

        public MutableComponent getDescription() {
            return this.description.getComponent();
        }

        public MutableComponent getTitle() {
            return this.title.getComponent();
        }

        public DescriptionData getDescriptionData() {
            return this.description;
        }

        public DescriptionData getTitleData() {
            return this.title;
        }

        public ResourceLocation getUniqueId() {
            return this.uniqueId;
        }

        public boolean isNewInUpdate() {
            return this.isNewInUpdate;
        }
    }
}

