/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.core.Version;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.loot.LootTable;
import iskallia.vault.core.world.roll.FloatRoll;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.entity.boss.BossRuneModifiers;
import iskallia.vault.entity.boss.MobSpawningUtils;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.attack.PersistentMeleeAttackGoal;
import iskallia.vault.entity.boss.goal.BloodOrbGoal;
import iskallia.vault.entity.boss.goal.CobwebRangedAttackGoal;
import iskallia.vault.entity.boss.goal.EvokerFangsGoal;
import iskallia.vault.entity.boss.goal.FireballRangedAttackGoal;
import iskallia.vault.entity.boss.goal.GolemDoubleHandRangedAttackGoal;
import iskallia.vault.entity.boss.goal.GolemHandRangedAttackGoal;
import iskallia.vault.entity.boss.goal.GroundSlamGoal;
import iskallia.vault.entity.boss.goal.HealGoal;
import iskallia.vault.entity.boss.goal.NovaAttackGoal;
import iskallia.vault.entity.boss.goal.PlaceBlockAroundGoal;
import iskallia.vault.entity.boss.goal.PotionAuraGoal;
import iskallia.vault.entity.boss.goal.ShulkerAttackGoal;
import iskallia.vault.entity.boss.goal.SnowballRangedAttackGoal;
import iskallia.vault.entity.boss.goal.SummonAtTargetGoal;
import iskallia.vault.entity.boss.goal.SummonGoal;
import iskallia.vault.entity.boss.goal.ThrowPotionGoal;
import iskallia.vault.entity.boss.trait.ApplyPotionOnHitEffect;
import iskallia.vault.entity.boss.trait.AttributeModifierTrait;
import iskallia.vault.entity.boss.trait.LifeLeechOnHitEffect;
import iskallia.vault.entity.boss.trait.ModifierType;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.util.LootInitialization;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class VaultBossConfig
extends Config {
    @Expose
    @SerializedName(value="Bosses")
    private Map<ResourceLocation, BossDefinition> bosses;
    @Expose
    @SerializedName(value="Traits")
    private Map<String, TraitDefinition> traits;
    @Expose
    @SerializedName(value="WeightedModifiers")
    private WeightedList<String> weightedModifiers;
    @Expose
    @SerializedName(value="WeightedSuffixModifiers")
    private WeightedList<String> weightedSuffixModifiers;
    @Expose
    @SerializedName(value="RuneModifierRolls")
    private RuneModifierRolls runeModifierRolls;

    @Override
    public String getName() {
        return "vault_boss";
    }

    @Override
    protected void reset() {
        this.traits = new LinkedHashMap<String, TraitDefinition>();
        this.traits.put("fireball_ranged_attack", new TraitDefinition("fireball_ranged_attack", new FireballRangedAttackGoal(null).setAttributes(1.0, 20, 60, 25.0f, 0.5, true).serializeNBT()));
        this.traits.put("snowball_ranged_attack", new TraitDefinition("snowball_ranged_attack", new SnowballRangedAttackGoal(null).setAttributes(1.0, 10, 20, 25.0f, 12.0f, 0.5f, false).serializeNBT()));
        this.traits.put("golem_hand_ranged_attack", new TraitDefinition("golem_hand_ranged_attack", new GolemHandRangedAttackGoal(null).setAttributes(1.0, 20, 60, 25.0f, 12.0f, 0.5f, false).serializeNBT()));
        this.traits.put("golem_double_hand_ranged_attack", new TraitDefinition("golem_double_hand_ranged_attack", new GolemDoubleHandRangedAttackGoal(null).setAttributes(1.0, 20, 60, 25.0f, 12.0f, 0.5f, false).serializeNBT()));
        this.traits.put("cobweb_ranged_attack", new TraitDefinition("cobweb_ranged_attack", new CobwebRangedAttackGoal(null).setAttributes(1.0, 20, 60, 25.0f, 12.0f, true).serializeNBT()));
        WeightedList<VaultBossBaseEntity.AttackData> meleeAttacks = new WeightedList<VaultBossBaseEntity.AttackData>().add(new VaultBossBaseEntity.AttackData("punch", 1.0), 1);
        this.traits.put("golem_melee_attack", new TraitDefinition("melee_attack", new PersistentMeleeAttackGoal(null).setAttributes(meleeAttacks).serializeNBT()));
        meleeAttacks = new WeightedList<VaultBossBaseEntity.AttackData>().add(new VaultBossBaseEntity.AttackData("double_punch", 3.0), 1);
        this.traits.put("golem_heavy_melee_attack", new TraitDefinition("melee_attack", new PersistentMeleeAttackGoal(null).setAttributes(meleeAttacks).serializeNBT()));
        this.traits.put("ground_slam", new TraitDefinition("ground_slam", new GroundSlamGoal(null).setAttributes(200, 400, 3, 15, 0.1f, 0.7f).serializeNBT()));
        meleeAttacks = new WeightedList<VaultBossBaseEntity.AttackData>().add(new VaultBossBaseEntity.AttackData("slash", 1.0), 1).add(new VaultBossBaseEntity.AttackData("jab", 1.0), 1);
        this.traits.put("boogieman_melee_attack", new TraitDefinition("melee_attack", new PersistentMeleeAttackGoal(null).setAttributes(meleeAttacks).serializeNBT()));
        meleeAttacks = new WeightedList<VaultBossBaseEntity.AttackData>().add(new VaultBossBaseEntity.AttackData("aoeclose", 1.0), 1);
        this.traits.put("sweep_attack", new TraitDefinition("melee_attack", new PersistentMeleeAttackGoal(null).setAttributes(meleeAttacks).serializeNBT()));
        WeightedList<MobSpawningUtils.EntitySpawnData> entityTypes = new WeightedList<MobSpawningUtils.EntitySpawnData>();
        entityTypes.add(new MobSpawningUtils.EntitySpawnData(EntityType.f_20501_, null), 1);
        entityTypes.add(new MobSpawningUtils.EntitySpawnData(EntityType.f_20524_, null), 1);
        entityTypes.add(new MobSpawningUtils.EntitySpawnData(EntityType.f_20558_, null), 1);
        this.traits.put("summon_vanilla", new TraitDefinition("summon", new SummonGoal(null).setAttributes(10, 1, 4, 100, 1, 15, entityTypes).serializeNBT()));
        this.traits.put("summon_vanilla_at_target", new TraitDefinition("summon_at_target", new SummonAtTargetGoal(null).setAttributes(10, 1, 4, 100, 5, 15, entityTypes).serializeNBT()));
        entityTypes.clear();
        ListTag handItemsTag = new ListTag();
        handItemsTag.add((Object)new ItemStack((ItemLike)Items.f_42393_).m_41739_(new CompoundTag()));
        CompoundTag mobTag = new CompoundTag();
        mobTag.m_128365_("HandItems", (Tag)handItemsTag);
        entityTypes.add(new MobSpawningUtils.EntitySpawnData(ModEntities.FIGHTER, mobTag), 1);
        entityTypes.add(new MobSpawningUtils.EntitySpawnData(ModEntities.DUNGEON_SKELETON, null), 1);
        entityTypes.add(new MobSpawningUtils.EntitySpawnData(ModEntities.DUNGEON_VINDICATOR, null), 1);
        this.traits.put("summon_vault", new TraitDefinition("summon", new SummonGoal(null).setAttributes(10, 1, 4, 100, 1, 15, entityTypes).serializeNBT()));
        this.traits.put("shulker_bullet", new TraitDefinition("shulker_bullet", new ShulkerAttackGoal(null).setAttributes(10, 40).serializeNBT()));
        this.traits.put("heal", new TraitDefinition("heal", new HealGoal(null).setAttributes(40, 0.1f).serializeNBT()));
        this.traits.put("blood_orb", new TraitDefinition("blood_orb", new BloodOrbGoal(null).setAttributes(40, 100, 20, 4).serializeNBT()));
        this.traits.put("evoker_fangs", new TraitDefinition("evoker_fangs", new EvokerFangsGoal(null).setAttributes(100, 200, 1.5f, 3, 5, 0.7f).serializeNBT()));
        this.traits.put("higher_health", new TraitDefinition("attribute_modifier", new AttributeModifierTrait().setAttributes(Attributes.f_22276_.getRegistryName().toString(), 1.5, "multiply").serializeNBT()));
        this.traits.put("higher_speed", new TraitDefinition("attribute_modifier", new AttributeModifierTrait().setAttributes(Attributes.f_22279_.getRegistryName().toString(), 0.3f, "add").serializeNBT()));
        this.traits.put("life_leech_on_hit", new TraitDefinition("life_leech_on_hit", new LifeLeechOnHitEffect().setAttributes(0.5f).serializeNBT()));
        this.traits.put("wither_on_hit", new TraitDefinition("apply_potion_on_hit", new ApplyPotionOnHitEffect().setAttributes(MobEffects.f_19615_, 100, 0, 0.2f).serializeNBT()));
        this.traits.put("levitate_on_hit", new TraitDefinition("apply_potion_on_hit", new ApplyPotionOnHitEffect().setAttributes(MobEffects.f_19620_, 100, 0, 0.5f).serializeNBT()));
        this.traits.put("steal_mana_on_hit", new TraitDefinition("apply_potion_on_hit", new ApplyPotionOnHitEffect().setAttributes(ModEffects.MANA_STEAL, 20, 0, 0.5f).serializeNBT()));
        this.traits.put("throw_lingering_poison", new TraitDefinition("throw_potion", new ThrowPotionGoal(null).setAttributes(1.0, 100, 200, 10.0f, MobEffects.f_19614_, 100, 0, true, true).serializeNBT()));
        this.traits.put("levitation_aura", new TraitDefinition(PotionAuraGoal.TYPE, new PotionAuraGoal(null).setAttributes(MobEffects.f_19620_, 40, 0, 5, false).serializeNBT()));
        this.traits.put("bleed_aura", new TraitDefinition(PotionAuraGoal.TYPE, new PotionAuraGoal(null).setAttributes(ModEffects.BLEED, 40, 0, 10, true).serializeNBT()));
        this.traits.put("leap_at_target", new TraitDefinition("leap_at_target", new CompoundTag()));
        this.traits.put("spider_attack", new TraitDefinition("spider_attack", new CompoundTag()));
        this.traits.put("summon_target_boogiemen", new TraitDefinition("summon_at_target", new SummonAtTargetGoal(null).setAttributes(40, 1, 5, 100, 5, 15, new WeightedList<MobSpawningUtils.EntitySpawnData>().add(new MobSpawningUtils.EntitySpawnData(ModEntities.BOOGIEMAN, null), 1)).serializeNBT()));
        this.traits.put("place_cobwebs_around", new TraitDefinition("place_block_around", new PlaceBlockAroundGoal(null).setAttributes(5, 1, 20, 60, PartialBlockState.of(Blocks.f_50033_)).serializeNBT()));
        this.traits.put("nova_attack", new TraitDefinition("nova_attack", new NovaAttackGoal(null).setAttributes(5, 1.0f, 10.0f, 100.0f, 5).serializeNBT()));
        this.bosses = new LinkedHashMap<ResourceLocation, BossDefinition>();
        this.bosses.put(ModEntities.GOLEM_BOSS.getRegistryName(), new BossDefinition(List.of("golem_melee_attack", "summon_vault", "life_leech_on_hit", "levitate_on_hit"), Map.of("light_ranged", "golem_hand_ranged_attack")));
        this.bosses.put(ModEntities.BLACK_WIDOW_BOSS.getRegistryName(), new BossDefinition(List.of("place_cobwebs_around", "spider_attack", "leap_at_target"), Map.of("light_ranged", "evoker_fangs")));
        this.bosses.put(ModEntities.BOOGIEMAN_BOSS.getRegistryName(), new BossDefinition(List.of("boogieman_melee_attack", "snowball_ranged_attack", "summon_vanilla", "higher_health", "higher_speed"), Map.of("light_ranged", "blood_orb", "heavy_range", "ground_slam")));
        this.weightedModifiers = new WeightedList();
        this.weightedModifiers.add(ModifierType.HEALTH.getId(), 1);
        this.weightedModifiers.add(ModifierType.DAMAGE.getId(), 1);
        this.weightedModifiers.add(ModifierType.ABILITY_HASTE.getId(), 1);
        this.runeModifierRolls = new RuneModifierRolls(FloatRoll.ofConstant(0.5f), FloatRoll.ofUniform(0.1f, 0.5f), IntRoll.ofUniform(0, 3));
        this.weightedSuffixModifiers = new WeightedList();
        this.weightedSuffixModifiers.add("attribute_health", 1);
    }

    @Override
    public <T extends Config> T readConfig() {
        VaultBossConfig config = (VaultBossConfig)super.readConfig();
        for (Map.Entry<String, TraitDefinition> trait : config.traits.entrySet()) {
            trait.getValue().id = trait.getKey();
        }
        return (T)config;
    }

    public ResourceLocation getRandomBossId() {
        int index = rand.nextInt(this.bosses.size());
        Iterator<ResourceLocation> it = this.bosses.keySet().iterator();
        for (int i = 0; i < index; ++i) {
            it.next();
        }
        return it.next();
    }

    public String getRandomModifier() {
        return this.weightedModifiers.getRandom().orElse(null);
    }

    public String getRandomSuffixModifier() {
        return this.weightedSuffixModifiers.getRandom().orElse(null);
    }

    public RuneModifierRolls getRuneModifierRolls() {
        if (this.runeModifierRolls == null) {
            this.runeModifierRolls = new RuneModifierRolls(FloatRoll.ofConstant(0.0f), FloatRoll.ofConstant(0.0f), IntRoll.ofConstant(0));
        }
        return this.runeModifierRolls;
    }

    public BossRuneModifiers rollRuneModifiers(RandomSource random) {
        RuneModifierRolls rolls = this.getRuneModifierRolls();
        double health = rolls.health().get(random);
        double damage = rolls.damage().get(random);
        int abilityHaste = rolls.abilityHaste().get(random);
        return new BossRuneModifiers(health, damage, abilityHaste);
    }

    public List<ItemStack> getRandomLootItems(int vaultLevel, RandomSource random) {
        LegacyLootTablesConfig.Level levelLootTables = ModConfigs.LOOT_TABLES.getForLevel(vaultLevel);
        if (levelLootTables == null) {
            return Collections.emptyList();
        }
        String lootTableId = levelLootTables.RUNES_LOOT;
        LootTable table = (LootTable)VaultRegistry.LOOT_TABLE.getKey(lootTableId).get(Version.latest());
        ArrayList<ItemStack> items = new ArrayList();
        if (table != null) {
            for (LootTable.Entry entry : table.getEntries()) {
                this.generateEntry(items, entry, random);
            }
        }
        items = items.stream().map(itemStack -> {
            if (itemStack.m_41720_() instanceof VaultGearItem) {
                return LootInitialization.initializeVaultLoot(itemStack, vaultLevel, random);
            }
            Item patt13586$temp = itemStack.m_41720_();
            if (patt13586$temp instanceof DataInitializationItem) {
                DataInitializationItem dataInitializationItem = (DataInitializationItem)patt13586$temp;
                dataInitializationItem.initialize((ItemStack)itemStack, random);
                return itemStack;
            }
            return itemStack;
        }).toList();
        return items;
    }

    protected void generateEntry(List<ItemStack> items, LootTable.Entry entry, RandomSource random) {
        int roll = entry.getRoll().get(random);
        for (int i = 0; i < roll; ++i) {
            entry.getPool().getRandomFlat(Version.latest(), random).map(e -> e.getStack(random)).ifPresent(items::addAll);
        }
    }

    public List<TraitDefinition> getBossBaseTraits(ResourceLocation bossRegistryName) {
        BossDefinition bossDefinition = this.bosses.get(bossRegistryName);
        if (bossDefinition == null) {
            return List.of();
        }
        ArrayList<TraitDefinition> bossTraits = new ArrayList<TraitDefinition>();
        for (String baseTraitId : bossDefinition.baseTraits) {
            TraitDefinition baseTraitDefinition = this.traits.get(baseTraitId);
            if (baseTraitDefinition == null) continue;
            bossTraits.add(baseTraitDefinition);
        }
        return bossTraits;
    }

    public Map<String, TraitDefinition> getBossModifierTraits(ResourceLocation bossRegistryName, Set<String> modifiers) {
        BossDefinition bossDefinition = this.bosses.get(bossRegistryName);
        if (bossDefinition == null) {
            return Map.of();
        }
        HashMap<String, TraitDefinition> modifierTraits = new HashMap<String, TraitDefinition>();
        for (String modifier : modifiers) {
            String modifierTraitId = bossDefinition.modifierTraitMap.get(modifier);
            TraitDefinition modifierTraitDefinition = this.traits.get(modifierTraitId);
            if (modifierTraitDefinition == null) continue;
            modifierTraits.put(modifier, modifierTraitDefinition);
        }
        return modifierTraits;
    }

    @Override
    protected boolean isValid() {
        boolean valid = super.isValid();
        for (BossDefinition boss : this.bosses.values()) {
            for (String baseTrait : boss.baseTraits) {
                if (this.traits.containsKey(baseTrait)) continue;
                VaultMod.LOGGER.error("Base trait {} for boss is not defined in traits", (Object)baseTrait);
                valid = false;
            }
            for (String modifierTrait : boss.modifierTraitMap.values()) {
                if (this.traits.containsKey(modifierTrait)) continue;
                VaultMod.LOGGER.error("Modifier trait {} for boss is not defined in traits", (Object)modifierTrait);
                valid = false;
            }
        }
        return valid;
    }

    public Iterable<String> getAllModifiers() {
        Iterator<BossDefinition> it = this.bosses.values().iterator();
        return it.hasNext() ? it.next().modifierTraitMap.keySet() : Collections.emptyList();
    }

    public Optional<ModifierType> getModifierType(String modifierId) {
        return ModifierType.fromId(modifierId);
    }

    public List<String> getAllModifierIds() {
        return Arrays.stream(new ModifierType[]{ModifierType.HEALTH, ModifierType.DAMAGE, ModifierType.ABILITY_HASTE}).map(ModifierType::getId).toList();
    }

    public static class TraitDefinition {
        private String id;
        @Expose
        @SerializedName(value="Type")
        private String type;
        @Expose
        @SerializedName(value="Attributes")
        @JsonAdapter(value=CompoundTagJsonObjectSerializer.class)
        private CompoundTag attributes;

        public TraitDefinition(String type, CompoundTag attributes) {
            this.type = type;
            this.attributes = attributes;
        }

        public String id() {
            return this.id;
        }

        public String type() {
            return this.type;
        }

        public CompoundTag attributesNbt() {
            return this.attributes;
        }
    }

    private static class BossDefinition {
        @Expose
        @SerializedName(value="BaseTraits")
        List<String> baseTraits;
        @Expose
        @SerializedName(value="ModifierTraits")
        Map<String, String> modifierTraitMap;

        public BossDefinition(List<String> baseTraits, Map<String, String> modifierTraitMap) {
            this.baseTraits = baseTraits;
            this.modifierTraitMap = modifierTraitMap;
        }
    }

    public static class RuneModifierRolls {
        @Expose
        @SerializedName(value="Health")
        private final FloatRoll health;
        @Expose
        @SerializedName(value="Damage")
        private final FloatRoll damage;
        @Expose
        @SerializedName(value="AbilityHaste")
        private final IntRoll abilityHaste;

        public RuneModifierRolls(FloatRoll health, FloatRoll damage, IntRoll abilityHaste) {
            this.health = health;
            this.damage = damage;
            this.abilityHaste = abilityHaste;
        }

        public FloatRoll health() {
            return this.health;
        }

        public FloatRoll damage() {
            return this.damage;
        }

        public IntRoll abilityHaste() {
            return this.abilityHaste;
        }
    }

    private static class CompoundTagJsonObjectSerializer
    implements JsonSerializer<CompoundTag>,
    JsonDeserializer<CompoundTag> {
        private static final CompoundTagJsonObjectSerializer INSTANCE = new CompoundTagJsonObjectSerializer();

        private CompoundTagJsonObjectSerializer() {
        }

        public JsonElement serialize(CompoundTag src, Type typeOfSrc, JsonSerializationContext context) {
            return (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)src);
        }

        public CompoundTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            CompoundTag compoundTag;
            Object object = JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, json);
            return object instanceof CompoundTag ? (compoundTag = (CompoundTag)object) : new CompoundTag();
        }
    }
}

