/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemVaultCrystalSeal;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.layout.ClassicCircleCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicPolygonCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicSpiralCrystalLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.modifiers.CrystalModifiers;
import iskallia.vault.item.crystal.objective.BossCrystalObjective;
import iskallia.vault.item.crystal.objective.CakeCrystalObjective;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.crystal.objective.GreedCrystalObjective;
import iskallia.vault.item.crystal.objective.ScavengerCrystalObjective;
import iskallia.vault.item.crystal.properties.CrystalProperties;
import iskallia.vault.item.crystal.theme.CrystalTheme;
import iskallia.vault.item.crystal.time.CrystalTime;
import iskallia.vault.item.crystal.time.InfiniteCrystalTime;
import iskallia.vault.item.crystal.time.ValueCrystalTime;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VaultCrystalConfig
extends Config {
    @Expose
    public ModifierStability MODIFIER_STABILITY;
    @Expose
    public Motes MOTES;
    @Expose
    public Map<ResourceLocation, LevelEntryList<ThemeEntry>> THEMES;
    @Expose
    public LevelEntryList<LayoutEntry> LAYOUTS;
    @Expose
    public Map<ResourceLocation, LevelEntryList<ObjectiveEntry>> OBJECTIVES;
    @Expose
    public Map<ResourceLocation, LevelEntryList<TimeEntry>> TIMES;
    @Expose
    public Map<ResourceLocation, LevelEntryList<PropertiesEntry>> PROPERTIES;
    @Expose
    private Map<ResourceLocation, LevelEntryList<SealEntry>> SEALS;

    @Override
    public String getName() {
        return "vault_crystal";
    }

    public Optional<ResourceLocation> getRandomTheme(ResourceLocation id, int level, RandomSource random) {
        return this.THEMES.getOrDefault(id, LevelEntryList.empty()).getForLevel(level).flatMap(entry -> entry.getRandomTheme(random, LocalDate.now(ZoneId.systemDefault())));
    }

    public Optional<CrystalLayout> getRandomLayout(int level, RandomSource random) {
        return this.LAYOUTS.getForLevel(level).flatMap(entry -> entry.pool.getRandom(random));
    }

    public Optional<CrystalObjective> getRandomObjective(ResourceLocation id, int level, RandomSource random) {
        return this.OBJECTIVES.getOrDefault(id, LevelEntryList.empty()).getForLevel(level).flatMap(entry -> entry.pool.getRandom(random));
    }

    public Optional<CrystalTime> getRandomTime(ResourceLocation id, int level, RandomSource random) {
        int gameRuleMinutes = ServerLifecycleHooks.getCurrentServer().m_129900_().m_46215_(ModGameRules.VAULT_TIMER);
        Optional<CrystalTime> result = this.TIMES.getOrDefault(id, LevelEntryList.empty()).getForLevel(level).flatMap(entry -> entry.pool.getRandom(random));
        if (gameRuleMinutes != 25) {
            if (gameRuleMinutes == 0) {
                result = Optional.of(new InfiniteCrystalTime());
                return result;
            }
            int ticks = gameRuleMinutes * 60 * 20;
            result = Optional.of(new ValueCrystalTime(IntRoll.ofConstant(ticks)));
        }
        return result;
    }

    public Optional<CrystalProperties> getRandomProperties(ResourceLocation id, int level) {
        return this.PROPERTIES.getOrDefault(id, LevelEntryList.empty()).getForLevel(level).map(entry -> entry.value);
    }

    public boolean applySeal(ItemStack input, ItemStack seal, ItemStack output, CrystalData crystal) {
        if (!this.SEALS.containsKey(seal.m_41720_().getRegistryName())) {
            return false;
        }
        Integer level = crystal.getProperties().getLevel().orElse(null);
        if (level == null) {
            return false;
        }
        return this.SEALS.get(seal.m_41720_().getRegistryName()).getForLevel(level).map(arg_0 -> VaultCrystalConfig.lambda$applySeal$5(input, crystal, seal, output, arg_0)).orElse(false);
    }

    @Override
    protected void reset() {
        this.MODIFIER_STABILITY = new ModifierStability();
        this.MOTES = new Motes();
        this.THEMES = new LinkedHashMap<ResourceLocation, LevelEntryList<ThemeEntry>>();
        LevelEntryList defaultTheme = new LevelEntryList();
        defaultTheme.add(new ThemeEntry(0, new WeightedList<ResourceLocation>().add(VaultMod.id("classic_vault_ice"), 1).add(VaultMod.id("classic_vault_cave"), 1)));
        this.THEMES.put(VaultMod.id("default"), defaultTheme);
        LevelEntryList diyTheme = new LevelEntryList();
        defaultTheme.add(new ThemeEntry(0, new WeightedList<ResourceLocation>().add(VaultMod.id("diy_vault_ice"), 1).add(VaultMod.id("diy_vault_cave"), 1)));
        this.THEMES.put(VaultMod.id("diy"), defaultTheme);
        this.LAYOUTS = new LevelEntryList();
        this.LAYOUTS.add(new LayoutEntry(0, new WeightedList<ClassicCircleCrystalLayout>().add(new ClassicCircleCrystalLayout(1, 4), 1).add((ClassicCircleCrystalLayout)((Object)new ClassicSpiralCrystalLayout(1, 4, Rotation.CLOCKWISE_90)), 1).add((ClassicCircleCrystalLayout)new ClassicInfiniteCrystalLayout(0), 1).add((ClassicCircleCrystalLayout)((Object)new ClassicPolygonCrystalLayout(1, new int[]{-4, 4, 4, 4, 4, -4, -4, -4})), 1).add((ClassicCircleCrystalLayout)((Object)new ClassicPolygonCrystalLayout(1, new int[]{-4, 0, 0, 4, 4, 0, 0, -4})), 1)));
        this.OBJECTIVES = new HashMap<ResourceLocation, LevelEntryList<ObjectiveEntry>>();
        this.SEALS = new LinkedHashMap<ResourceLocation, LevelEntryList<SealEntry>>();
        LevelEntryList list = new LevelEntryList();
        this.SEALS.put(ModItems.CRYSTAL_SEAL_EXECUTIONER.getRegistryName(), list);
        list.add(new SealEntry(0, Arrays.asList(ModItems.VAULT_CRYSTAL.getRegistryName()), new BossCrystalObjective(IntRoll.ofUniform(3, 6), IntRoll.ofUniform(3, 6), 0.1f), new ClassicInfiniteCrystalLayout(1), null, null, null, null));
        list = new LevelEntryList();
        this.SEALS.put(ModItems.CRYSTAL_SEAL_HUNTER.getRegistryName(), list);
        list.add(new SealEntry(0, Arrays.asList(ModItems.VAULT_CRYSTAL.getRegistryName()), new ScavengerCrystalObjective(0.1f), new ClassicCircleCrystalLayout(1, 5), null, null, null, null));
        list = new LevelEntryList();
        this.SEALS.put(ModItems.CRYSTAL_SEAL_HERALD.getRegistryName(), list);
        list.add(new SealEntry(0, Arrays.asList(ModItems.VAULT_CRYSTAL.getRegistryName()), new CakeCrystalObjective(IntRoll.ofUniform(10, 15)), new ClassicSpiralCrystalLayout(1, 99, Rotation.CLOCKWISE_90), null, null, null, null));
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ Boolean lambda$applySeal$5(ItemStack input, CrystalData crystal, ItemStack seal, ItemStack output, SealEntry entry) {
        if (!entry.input.contains(input.m_41720_().getRegistryName())) {
            return false;
        }
        if (crystal.getProperties().isUnmodifiable()) {
            return false;
        }
        patt4601$temp = entry.objective;
        if (!(patt4601$temp instanceof GreedCrystalObjective)) ** GOTO lbl-1000
        greed = (GreedCrystalObjective)patt4601$temp;
        if (seal.m_150930_((Item)ModItems.CRYSTAL_SEAL_GREED) && ItemVaultCrystalSeal.hasGreedTier(seal)) {
            greed.setGreedTier(ItemVaultCrystalSeal.getGreedTier(seal));
            crystal.setObjective(greed);
        } else lbl-1000:
        // 2 sources

        {
            crystal.setObjective(entry.objective);
        }
        if (entry.layout != null) {
            crystal.setLayout(entry.layout);
        }
        if (entry.theme != null) {
            crystal.setTheme(entry.theme);
        }
        if (entry.time != null) {
            crystal.setTime(entry.time);
        }
        if (entry.modifiers != null) {
            crystal.setModifiers(entry.modifiers);
        }
        if (entry.exhausted != null) {
            crystal.getProperties().setUnmodifiable(entry.exhausted);
        }
        crystal.write(output);
        return true;
    }

    public static class ModifierStability {
        @Expose
        public float instabilityPerCraft = 0.1f;
        @Expose
        public float exhaustProbability = 0.25f;
        @Expose
        public TextColor curseColor = TextColor.m_131268_((String)"#9C6E3B");
    }

    public static class Motes {
        @Expose
        public int clarityLevelCost = 1;
        @Expose
        public int purityLevelCost = 2;
        @Expose
        public int sanctityLevelCost = 4;
    }

    public static class ThemeEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int level;
        @Expose
        public WeightedList<ResourceLocation> pool;
        @Expose
        public Map<ResourceLocation, SeasonalWeights> seasonalWeights = new LinkedHashMap<ResourceLocation, SeasonalWeights>();

        public ThemeEntry(int level, WeightedList<ResourceLocation> pool) {
            this(level, pool, new LinkedHashMap<ResourceLocation, SeasonalWeights>());
        }

        public ThemeEntry(int level, WeightedList<ResourceLocation> pool, Map<ResourceLocation, SeasonalWeights> seasonalWeights) {
            this.level = level;
            this.pool = pool;
            if (seasonalWeights != null) {
                this.seasonalWeights = seasonalWeights;
            }
        }

        public Optional<ResourceLocation> getRandomTheme(RandomSource random, LocalDate date) {
            return this.getSeasonallyWeightedPool(date).getRandom(random);
        }

        private WeightedList<ResourceLocation> getSeasonallyWeightedPool(LocalDate date) {
            WeightedList<ResourceLocation> adjusted = new WeightedList<ResourceLocation>();
            adjusted.putAll(this.pool);
            if (date == null || this.seasonalWeights == null || this.seasonalWeights.isEmpty()) {
                return adjusted;
            }
            for (Map.Entry<ResourceLocation, SeasonalWeights> entry : this.seasonalWeights.entrySet()) {
                double delta;
                ResourceLocation themeId = entry.getKey();
                SeasonalWeights weights = entry.getValue();
                if (weights == null) continue;
                double baseWeight = adjusted.getOrDefault(themeId, 0.0);
                double finalWeight = baseWeight + (delta = weights.getAdditionalWeight(date));
                if (finalWeight > 0.0) {
                    adjusted.put(themeId, finalWeight);
                    continue;
                }
                adjusted.remove(themeId);
            }
            return adjusted;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        public static class SeasonalWeights {
            @Expose
            public List<DateRangeWeight> ranges = new ArrayList<DateRangeWeight>();

            public double getAdditionalWeight(LocalDate date) {
                if (date == null || this.ranges == null || this.ranges.isEmpty()) {
                    return 0.0;
                }
                double additional = 0.0;
                for (DateRangeWeight range : this.ranges) {
                    if (range == null) continue;
                    additional += range.getWeight(date);
                }
                return additional;
            }
        }

        public static class DateRangeWeight {
            private static final DateTimeFormatter MONTH_DAY_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
            @Expose
            public String from;
            @Expose
            public String to;
            @Expose
            public double weight;
            private transient MonthDay cachedFrom;
            private transient MonthDay cachedTo;
            private transient boolean parsedFrom;
            private transient boolean parsedTo;

            public double getWeight(LocalDate date) {
                if (!this.matches(date)) {
                    return 0.0;
                }
                return this.weight;
            }

            private boolean matches(LocalDate date) {
                if (date == null) {
                    return false;
                }
                MonthDay start = this.getFrom();
                MonthDay end = this.getTo(start);
                if (start == null || end == null) {
                    return false;
                }
                MonthDay current = MonthDay.from(date);
                if (!this.wrapsYear(start, end)) {
                    return !current.isBefore(start) && !current.isAfter(end);
                }
                return !current.isBefore(start) || !current.isAfter(end);
            }

            private MonthDay getFrom() {
                if (!this.parsedFrom) {
                    this.parsedFrom = true;
                    if (this.from != null) {
                        this.cachedFrom = this.parseMonthDay(this.from);
                    }
                }
                return this.cachedFrom;
            }

            private MonthDay getTo(MonthDay fallback) {
                if (!this.parsedTo) {
                    String target;
                    this.parsedTo = true;
                    String string = target = this.to != null ? this.to : this.from;
                    if (target != null) {
                        this.cachedTo = this.parseMonthDay(target);
                    }
                }
                if (this.cachedTo == null) {
                    return fallback;
                }
                return this.cachedTo;
            }

            private MonthDay parseMonthDay(String value) {
                try {
                    return MonthDay.parse(value, MONTH_DAY_FORMAT);
                }
                catch (DateTimeParseException e) {
                    VaultMod.LOGGER.warn("Failed to parse month-day '{}' for seasonal theme weight", (Object)value, (Object)e);
                    return null;
                }
            }

            private boolean wrapsYear(MonthDay start, MonthDay end) {
                return end.isBefore(start);
            }
        }
    }

    public static class LayoutEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int level;
        @Expose
        public WeightedList<CrystalLayout> pool;

        public LayoutEntry(int level, WeightedList<CrystalLayout> pool) {
            this.level = level;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    public static class SealEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final List<ResourceLocation> input;
        @Expose
        private final CrystalObjective objective;
        @Expose
        private final CrystalLayout layout;
        @Expose
        private final CrystalTheme theme;
        @Expose
        private final CrystalTime time;
        @Expose
        private final CrystalModifiers modifiers;
        @Expose
        private final Boolean exhausted;

        public SealEntry(int level, List<ResourceLocation> input, CrystalObjective objective, CrystalLayout layout, CrystalTheme theme, CrystalTime time, CrystalModifiers modifiers, Boolean exhausted) {
            this.level = level;
            this.input = input;
            this.objective = objective;
            this.layout = layout;
            this.theme = theme;
            this.time = time;
            this.modifiers = modifiers;
            this.exhausted = exhausted;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    public static class PropertiesEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int level;
        @Expose
        public CrystalProperties value;

        public PropertiesEntry(int level, CrystalProperties value) {
            this.level = level;
            this.value = value;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    public static class TimeEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int level;
        @Expose
        public WeightedList<CrystalTime> pool;

        public TimeEntry(int level, WeightedList<CrystalTime> pool) {
            this.level = level;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    public static class ObjectiveEntry
    implements LevelEntryList.ILevelEntry {
        @Expose
        public int level;
        @Expose
        public WeightedList<CrystalObjective> pool;

        public ObjectiveEntry(int level, WeightedList<CrystalObjective> pool) {
            this.level = level;
            this.pool = pool;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

