/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.gear.attribute.custom.effect.EffectCloudAttribute;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.registries.ForgeRegistries;

public class VaultEntitiesConfig
extends Config {
    @Expose
    private final List<DeathEffect> deathEffects = new ArrayList<DeathEffect>();
    @Expose
    private final List<ThrowEffect> throwEffects = new ArrayList<ThrowEffect>();
    @Expose
    private final AuraEffect shiverEffect = new AuraEffect();
    @Expose
    private final AuraEffect swampZombieEffect = new AuraEffect();

    public List<EffectCloudAttribute.CloudConfig> getDeathEffects(int level, Entity entity) {
        ArrayList<EffectCloudAttribute.CloudConfig> effects = new ArrayList<EffectCloudAttribute.CloudConfig>();
        for (DeathEffect deathEffect : this.deathEffects) {
            if (!deathEffect.getFilter().test(entity)) continue;
            effects.addAll(deathEffect.getLevels().getForLevel(level).map(DeathEffect.Level::getConfig).map(Collections::singletonList).orElse(Collections.emptyList()));
        }
        return effects;
    }

    public List<MobEffectInstance> getThrowEffects(int level, Entity entity) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (ThrowEffect throwEffect : this.throwEffects) {
            if (!throwEffect.getFilter().test(entity)) continue;
            effects.addAll(throwEffect.getLevels().getForLevel(level).map(ThrowEffect.Level::getEffects).orElse(Collections.emptyList()));
        }
        return effects;
    }

    public AuraEffect getShiverEffect() {
        return this.shiverEffect;
    }

    public AuraEffect getSwampZombieEffect() {
        return this.swampZombieEffect;
    }

    @Override
    public String getName() {
        return "vault_entities";
    }

    @Override
    protected void reset() {
        this.deathEffects.clear();
        this.throwEffects.clear();
        EffectCloudAttribute.CloudConfig config = new EffectCloudAttribute.CloudConfig("", VaultMod.id(""), 80, 5.0f, Color.GREEN.getRGB(), true, 1.0f);
        config.setAdditionalEffect(new EffectCloudAttribute.CloudEffectConfig(MobEffects.f_19614_.getRegistryName(), 900, 0));
        this.deathEffects.add(new DeathEffect(EntityPredicate.of("minecraft:slime", true).orElseThrow()).put(0, config));
        this.throwEffects.add(new ThrowEffect(EntityPredicate.of("minecraft:witch", true).orElseThrow()).put(0, new ThrowEffect.CustomEffect(MobEffects.f_19614_, 0, 120)));
    }

    public static class AuraEffect {
        @Expose
        protected int range;
        @Expose
        protected int effectDuration;
        @Expose
        protected int effectAmplifier;

        public int getRange() {
            return this.range;
        }

        public int getEffectDuration() {
            return this.effectDuration;
        }

        public int getEffectAmplifier() {
            return this.effectAmplifier;
        }
    }

    public static class DeathEffect {
        @Expose
        private EntityPredicate filter;
        @Expose
        private LevelEntryList<Level> levels;

        public DeathEffect(EntityPredicate filter) {
            this.filter = filter;
            this.levels = new LevelEntryList();
        }

        public EntityPredicate getFilter() {
            return this.filter;
        }

        public LevelEntryList<Level> getLevels() {
            return this.levels;
        }

        public DeathEffect put(int level, EffectCloudAttribute.CloudConfig config) {
            this.levels.put(new Level(level, config));
            return this;
        }

        public static class Level
        implements LevelEntryList.ILevelEntry {
            @Expose
            private final int level;
            @Expose
            private final EffectCloudAttribute.CloudConfig config;

            public Level(int level, EffectCloudAttribute.CloudConfig config) {
                this.level = level;
                this.config = config;
            }

            @Override
            public int getLevel() {
                return this.level;
            }

            private EffectCloudAttribute.CloudConfig getConfig() {
                return this.config;
            }
        }
    }

    public static class ThrowEffect {
        @Expose
        private EntityPredicate filter;
        @Expose
        private LevelEntryList<Level> levels;

        public ThrowEffect(EntityPredicate filter) {
            this.filter = filter;
            this.levels = new LevelEntryList();
        }

        public EntityPredicate getFilter() {
            return this.filter;
        }

        public LevelEntryList<Level> getLevels() {
            return this.levels;
        }

        public ThrowEffect put(int level, CustomEffect ... effects) {
            this.levels.put(new Level(level, Arrays.asList(effects)));
            return this;
        }

        public static class Level
        implements LevelEntryList.ILevelEntry {
            @Expose
            private final int level;
            @Expose
            private final List<CustomEffect> effects = new ArrayList<CustomEffect>();

            public Level(int level, List<CustomEffect> effects) {
                this.level = level;
                this.effects.addAll(effects);
            }

            public List<MobEffectInstance> getEffects() {
                return this.effects.stream().map(CustomEffect::makeEffect).collect(Collectors.toList());
            }

            @Override
            public int getLevel() {
                return this.level;
            }
        }

        public static class CustomEffect {
            @Expose
            private final ResourceLocation effect;
            @Expose
            private final int amplifier;
            @Expose
            private final int duration;

            public CustomEffect(MobEffect effect, int amplifier, int duration) {
                this(effect.getRegistryName(), amplifier, duration);
            }

            public CustomEffect(ResourceLocation effect, int amplifier, int duration) {
                this.effect = effect;
                this.amplifier = amplifier;
                this.duration = duration;
            }

            public MobEffectInstance makeEffect() {
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.effect);
                return new MobEffectInstance(effect, this.duration, this.amplifier, false, false, true);
            }
        }
    }
}

