/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.util.GlobUtils;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class VaultGeneralConfig
extends Config {
    @Expose
    private List<String> ITEM_BLACKLIST;
    @Expose
    private List<String> BLOCK_BLACKLIST;
    @Expose
    public float VAULT_EXIT_TNL_MIN;
    @Expose
    public float VAULT_EXIT_TNL_MAX;
    @Expose
    public boolean SAVE_PLAYER_SNAPSHOTS;
    @Expose
    private final LevelEntryList<Level> VAULT_OBJECTIVES = new LevelEntryList();
    @Expose
    private final LevelEntryList<Level> VAULT_COOP_OBJECTIVES = new LevelEntryList();
    private final Map<String, Boolean> blockBlacklistCache = new HashMap<String, Boolean>();
    private final Map<String, Boolean> itemBlacklistCache = new HashMap<String, Boolean>();

    @Override
    public String getName() {
        return "vault_general";
    }

    @Override
    protected void reset() {
        this.ITEM_BLACKLIST = new ArrayList<String>();
        this.ITEM_BLACKLIST.add(Items.f_42108_.getRegistryName().toString());
        this.BLOCK_BLACKLIST = new ArrayList<String>();
        this.BLOCK_BLACKLIST.add(Blocks.f_50265_.getRegistryName().toString());
        this.VAULT_EXIT_TNL_MIN = 0.0f;
        this.VAULT_EXIT_TNL_MAX = 0.0f;
        this.SAVE_PLAYER_SNAPSHOTS = false;
        this.VAULT_OBJECTIVES.clear();
        WeightedList<String> objectives = new WeightedList<String>();
        objectives.add(VaultMod.id("summon_and_kill_boss").toString(), 1);
        objectives.add(VaultMod.id("scavenger_hunt").toString(), 1);
        this.VAULT_OBJECTIVES.add(new Level(0, objectives));
        this.VAULT_COOP_OBJECTIVES.clear();
        objectives = new WeightedList();
        objectives.add(VaultMod.id("summon_and_kill_boss").toString(), 1);
        objectives.add(VaultMod.id("scavenger_hunt").toString(), 1);
        this.VAULT_COOP_OBJECTIVES.add(new Level(0, objectives));
    }

    @Nullable
    public Level getForLevel(LevelEntryList<Level> levels, int level) {
        return levels.getForLevel(level).orElse(null);
    }

    public boolean isBlacklisted(ItemStack stack) {
        return this.isBlacklisted(stack.m_41720_());
    }

    public boolean isBlacklisted(BlockState state) {
        return this.isBlacklisted(state.m_60734_());
    }

    public boolean isBlacklisted(Item item) {
        ResourceLocation registryName = item.getRegistryName();
        if (registryName == null) {
            return false;
        }
        String itemId = registryName.toString();
        return this.itemBlacklistCache.computeIfAbsent(itemId, id -> {
            for (String pattern : this.ITEM_BLACKLIST) {
                if (pattern.startsWith("!")) {
                    if (!GlobUtils.matches(pattern.substring(1), id)) continue;
                    return false;
                }
                if (!GlobUtils.matches(pattern, id)) continue;
                return true;
            }
            return false;
        });
    }

    public boolean isBlacklisted(Block block) {
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            return false;
        }
        String blockId = registryName.toString();
        return this.blockBlacklistCache.computeIfAbsent(blockId, id -> {
            for (String pattern : this.BLOCK_BLACKLIST) {
                if (pattern.startsWith("!")) {
                    if (!GlobUtils.matches(pattern.substring(1), id)) continue;
                    return false;
                }
                if (!GlobUtils.matches(pattern, id)) continue;
                return true;
            }
            return false;
        });
    }

    public static class Level
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final WeightedList<String> outcomes;

        public Level(int level, WeightedList<String> outcomes) {
            this.level = level;
            this.outcomes = outcomes;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

