/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.entity.guardian.helper.GuardianStats;
import iskallia.vault.entity.entity.guardian.helper.GuardianType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class VaultGuardianConfig
extends Config {
    @Expose
    private LevelEntryList<Entry> entries;

    @Override
    public String getName() {
        return "vault_guardian";
    }

    public GuardianStats get(int level, GuardianType type) {
        return switch (type) {
            case GuardianType.BRUISER -> this.entries.getForLevel((int)level).get().bruiser;
            case GuardianType.ARBALIST -> this.entries.getForLevel((int)level).get().arbalist;
            default -> null;
        };
    }

    public GuardianType getType(int level, RandomSource random) {
        return this.entries.getForLevel((int)level).get().pool.getRandom(random).orElse(GuardianType.ARBALIST);
    }

    @Override
    protected void reset() {
        this.entries = new LevelEntryList();
        this.entries.add(new Entry(0, new WeightedList<GuardianType>().add(GuardianType.BRUISER, 1).add(GuardianType.ARBALIST, 1), new GuardianStats.Bruiser(new ItemStack((ItemLike)Items.f_42433_)), new GuardianStats.Arbalist(new ItemStack((ItemLike)Items.f_42398_), new ItemStack((ItemLike)Items.f_42717_), GuardianStats.Arbalist.MeleeActivation.ON_HIT, Math.sqrt(7.36f) + 1.0, Math.sqrt(7.36f) + 4.0, 1.0)));
    }

    public static class Entry
    implements LevelEntryList.ILevelEntry {
        @Expose
        private int level;
        @Expose
        private WeightedList<GuardianType> pool;
        @Expose
        private GuardianStats.Bruiser bruiser;
        @Expose
        private GuardianStats.Arbalist arbalist;

        public Entry(int level, WeightedList<GuardianType> pool, GuardianStats.Bruiser bruiser, GuardianStats.Arbalist arbalist) {
            this.level = level;
            this.pool = pool;
            this.bruiser = bruiser;
            this.arbalist = arbalist;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

