/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.init.ModGameRules;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VaultLevelsConfig
extends Config {
    @Expose
    private int maxLevel;
    @Expose
    private float expMultiplier;
    @Expose
    private final List<VaultLevelMeta> levelMetas = new ArrayList<VaultLevelMeta>();
    @Expose
    private int prestigeTnl = 1110375;

    @Override
    public String getName() {
        return "vault_levels";
    }

    public VaultLevelMeta getLevelMeta(int level) {
        int maxLevelTNLAvailable = this.levelMetas.size() - 1;
        if (level < 0 || level > maxLevelTNLAvailable) {
            return this.levelMetas.get(maxLevelTNLAvailable);
        }
        return this.levelMetas.get(level);
    }

    public int getLevelFromExp(int exp) {
        for (int i = 0; i < this.levelMetas.size(); ++i) {
            if (this.levelMetas.get((int)i).tnl < exp) continue;
            return i;
        }
        return this.levelMetas.size() - 1;
    }

    public int getTotalExpAtLevel(int level) {
        int totalExp = 0;
        for (int i = 0; i < level; ++i) {
            totalExp += this.levelMetas.get((int)i).tnl;
        }
        return totalExp;
    }

    public int getMaxLevel() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_129900_().m_46215_(ModGameRules.LEVEL_LOCK);
        }
        return this.maxLevel;
    }

    public float getExpMultiplier() {
        return this.expMultiplier;
    }

    public int getPrestigeTnl() {
        return this.prestigeTnl;
    }

    @Override
    protected void reset() {
        this.maxLevel = 100;
        this.expMultiplier = 1.0f;
        this.prestigeTnl = 1110375;
        this.levelMetas.clear();
        for (int x = 0; x < this.maxLevel; ++x) {
            VaultLevelMeta vaultLevel = new VaultLevelMeta();
            vaultLevel.level = x;
            vaultLevel.tnl = x < 6 ? 1000 * x + 1000 : (x < 8 ? 2000 * x - 5000 : (x < 10 ? 1500 * x - 1000 : (x < 40 ? 400 * x + 10000 : (x < 50 ? 1200 * x - 22000 : (x < 65 ? 98700 : (x < 80 ? 246750 : (x < 90 ? 493500 : 1110375)))))));
            this.levelMetas.add(vaultLevel);
        }
    }

    public long defaultTNLFunction(int level) {
        return 10000L + 400L * (long)level + Math.round(Math.pow((float)level / 59.0f, 28.0));
    }

    public static class VaultLevelMeta {
        @Expose
        public int level;
        @Expose
        public int tnl;
    }
}

