/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class VaultMapRoomIconsConfig
extends Config {
    private static final Cache<ResourceLocation, Optional<ResourceLocation>> ROOM_ICON_CACHE = CacheBuilder.newBuilder().build();
    private static final Cache<ResourceLocation, Optional<ResourceLocation>> SIMPLE_ICON_CACHE = CacheBuilder.newBuilder().build();
    private static final List<ResourceLocation> ICONS_CACHE = new ArrayList<ResourceLocation>();
    @Expose
    private Map<ResourceLocation, List<ResourceLocation>> roomIcons;

    @Override
    public String getName() {
        return "vault_map_icons";
    }

    @Override
    protected void reset() {
        this.roomIcons = new HashMap<ResourceLocation, List<ResourceLocation>>(){
            {
                this.put(VaultMod.id("gui/map/crystal_caves"), List.of(VaultMod.id("vault/rooms/challenge/crystal_caves")));
            }
        };
    }

    public List<ResourceLocation> getIcons() {
        if (ICONS_CACHE.isEmpty()) {
            for (ResourceLocation icon : this.roomIcons.keySet()) {
                ICONS_CACHE.add(icon);
                ICONS_CACHE.add(new ResourceLocation(icon.m_135827_(), icon.m_135815_().replace("gui/map/", "gui/map/simple/")));
            }
        }
        return ICONS_CACHE;
    }

    public Map<ResourceLocation, List<ResourceLocation>> getRoomIcons() {
        return this.roomIcons;
    }

    public Optional<ResourceLocation> getIconForRoom(ResourceLocation room) {
        try {
            return (Optional)ROOM_ICON_CACHE.get((Object)room, () -> this.computeRoomIcon(room, false));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<ResourceLocation> getSimpleIconForRoom(ResourceLocation room) {
        try {
            return (Optional)SIMPLE_ICON_CACHE.get((Object)room, () -> this.computeRoomIcon(room, true));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<ResourceLocation> computeRoomIcon(ResourceLocation room, boolean simple) {
        for (Map.Entry<ResourceLocation, List<ResourceLocation>> entry : this.roomIcons.entrySet()) {
            for (ResourceLocation location : entry.getValue()) {
                if (!location.m_135815_().contains(room.m_135815_())) continue;
                return simple ? Optional.of(new ResourceLocation(entry.getKey().m_135827_(), entry.getKey().m_135815_().replace("gui/map/", "gui/map/simple/"))) : Optional.of(entry.getKey());
            }
        }
        return Optional.empty();
    }

    public static void clearCache() {
        ROOM_ICON_CACHE.invalidateAll();
        SIMPLE_ICON_CACHE.invalidateAll();
        ICONS_CACHE.clear();
    }
}

