/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.roll.IntRoll;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;

public class VaultNecklaceConfig
extends Config {
    @Expose
    private IntRoll usesRoll;
    @Expose
    private List<ResourceLocation> models;

    @Override
    public String getName() {
        return "vault_necklace";
    }

    @Override
    protected void reset() {
        this.usesRoll = IntRoll.ofUniform(7, 8);
        final ResourceLocation defaultModel = VaultMod.id("gear/necklace/default");
        this.models = new ArrayList<ResourceLocation>(){
            {
                this.add(defaultModel);
            }
        };
    }

    public IntRoll getUsesRoll() {
        return this.usesRoll;
    }

    public int getUses(RandomSource source) {
        return this.usesRoll.get(source);
    }

    public ResourceLocation getRandomModel(Random random) {
        return this.models.get(random.nextInt(this.models.size()));
    }
}

