/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.ChanceItemStackEntry;
import iskallia.vault.config.entry.ConditionalChanceItemStackEntry;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.modification.ReforgeTagModificationFocus;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class VaultRecyclerConfig
extends Config {
    @Expose
    private int processingTickTime;
    @Expose
    private final Map<VaultGearRarity, Float> additionalOutputRarityChances = new LinkedHashMap<VaultGearRarity, Float>();
    @Expose
    private Map<ResourceLocation, RecyclerOutput> recyclingOutput;

    @Override
    public String getName() {
        return "vault_recycler";
    }

    public int getProcessingTickTime() {
        return this.processingTickTime;
    }

    public final RecyclerOutput getDefaultRecyclingOutput() {
        return new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.VAULT_SCRAP), 4, 8, 1.0f), new ConditionalChanceItemStackEntry(new ItemStack((ItemLike)ModItems.PAINITE_GEM), 1, 1, 0.05f), new ConditionalChanceItemStackEntry(new ItemStack((ItemLike)ModItems.FACETED_FOCUS), 1, 1, 0.0f));
    }

    public Optional<RecyclerOutput> getRecyclingOutput(ResourceLocation item) {
        if (this.recyclingOutput == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.recyclingOutput.get(item));
    }

    public RecyclerOutput getRecyclingOutputOrDefault(ResourceLocation item) {
        return this.getRecyclingOutput(item).orElse(this.getDefaultRecyclingOutput());
    }

    public Optional<RecyclerOutput> getRecyclingOutput(Item item) {
        return this.getRecyclingOutput(item.getRegistryName());
    }

    public RecyclerOutput getRecyclingOutputOrDefault(Item item) {
        return this.getRecyclingOutput(item.getRegistryName()).orElse(this.getDefaultRecyclingOutput());
    }

    public float getAdditionalOutputRarityChance(VaultGearRarity rarity) {
        return this.additionalOutputRarityChances.getOrDefault((Object)rarity, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    protected void reset() {
        this.processingTickTime = 40;
        this.additionalOutputRarityChances.clear();
        this.additionalOutputRarityChances.put(VaultGearRarity.SCRAPPY, Float.valueOf(0.0f));
        this.additionalOutputRarityChances.put(VaultGearRarity.COMMON, Float.valueOf(0.05f));
        this.additionalOutputRarityChances.put(VaultGearRarity.RARE, Float.valueOf(0.1f));
        this.additionalOutputRarityChances.put(VaultGearRarity.EPIC, Float.valueOf(0.15f));
        this.additionalOutputRarityChances.put(VaultGearRarity.OMEGA, Float.valueOf(0.2f));
        this.recyclingOutput = new HashMap<ResourceLocation, RecyclerOutput>();
        this.recyclingOutput.put(VaultMod.id("gear"), new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.VAULT_SCRAP), 4, 8, 1.0f), new ConditionalChanceItemStackEntry(new ItemStack((ItemLike)ModItems.PAINITE_GEM), 1, 1, 0.05f), new ConditionalChanceItemStackEntry(new ItemStack((ItemLike)ModItems.FACETED_FOCUS), 1, 1, 0.0f).addCondition(ConditionalChanceItemStackEntry.Condition.forAll(VaultGearRarity.OMEGA, false, null), new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.ADAPTIVE_FOCUS), 1, 1, 0.25f))));
        this.recyclingOutput.put(ModItems.TRINKET.getRegistryName(), new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)Items.f_42410_), 1, 1, 1.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f)));
        this.recyclingOutput.put(ModItems.JEWEL.getRegistryName(), new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.GEMSTONE), 1, 1, 1.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f)));
        this.recyclingOutput.put(ModItems.INSCRIPTION.getRegistryName(), new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.INSCRIPTION_PIECE), 1, 1, 1.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f)));
        this.recyclingOutput.put(ModItems.MAGNET.getRegistryName(), new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.MAGNETITE), 1, 1, 1.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f)));
        this.recyclingOutput.put(ModItems.VAULT_GOD_CHARM.getRegistryName(), new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.ALEXANDRITE_GEM), 1, 1, 1.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f)));
        this.recyclingOutput.put(ModItems.VOID_STONE.getRegistryName(), new RecyclerOutput(new ChanceItemStackEntry(new ItemStack((ItemLike)ModItems.BENITOITE_GEM), 1, 1, 1.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f), new ConditionalChanceItemStackEntry(ItemStack.f_41583_, 1, 1, 0.0f)));
    }

    public static class RecyclerOutput {
        @Expose
        private final ChanceItemStackEntry mainOutput;
        @Expose
        private final ConditionalChanceItemStackEntry extraOutput1;
        @Expose
        private final ConditionalChanceItemStackEntry extraOutput2;

        public RecyclerOutput(ChanceItemStackEntry mainOutput, ConditionalChanceItemStackEntry extraOutput1, ConditionalChanceItemStackEntry extraOutput2) {
            this.mainOutput = mainOutput;
            this.extraOutput1 = extraOutput1;
            this.extraOutput2 = extraOutput2;
        }

        public ItemStack generateMainOutput(float additionalChance) {
            ItemStack out = DataTransferItem.doConvertStack(this.mainOutput.adjustChance(additionalChance).createItemStack(Config.rand));
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ChanceItemStackEntry getMainOutput() {
            return this.mainOutput;
        }

        public ConditionalChanceItemStackEntry getExtraOutput1() {
            return this.extraOutput1;
        }

        public ConditionalChanceItemStackEntry getExtraOutput2() {
            return this.extraOutput2;
        }

        public ItemStack getMainOutputMatching() {
            return this.mainOutput.getMatchingStack();
        }

        public ItemStack generateExtraOutput1(ItemStack input, float additionalChance) {
            ItemStack out = DataTransferItem.doConvertStack(this.extraOutput1.adjustChance(additionalChance).createItemStack(Config.rand));
            this.adjustFocusItem(input, out);
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ItemStack generateExtraOutput1(ItemStack input, float additionalChance, VaultGearRarity rarity, boolean isCrafted, boolean isLegendary) {
            ItemStack out = DataTransferItem.doConvertStack(this.extraOutput1.adjustChance(additionalChance).createItemStack(Config.rand, rarity, isCrafted, isLegendary));
            this.adjustFocusItem(input, out);
            DataInitializationItem.doInitialize(out);
            return out;
        }

        private void adjustFocusItem(ItemStack input, ItemStack output) {
            Item item;
            if (output.m_150930_((Item)ModItems.FACETED_FOCUS) && (item = input.m_41720_()) instanceof VaultGearItem) {
                VaultGearData data;
                VaultGearItem gearItem = (VaultGearItem)item;
                if (VaultGearData.hasData(input) && (data = VaultGearData.read(input)).get(ModGearAttributes.IS_LEGENDARY, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                    Optional<VaultGearModifier> firstLegendaryModifier = data.getModifiersFulfilling(modifier -> true).stream().filter(modifier -> modifier.hasCategory(VaultGearModifier.AffixCategory.LEGENDARY)).findFirst();
                    if (firstLegendaryModifier.isEmpty()) {
                        firstLegendaryModifier = data.getModifiers(VaultGearModifier.AffixType.SUFFIX).stream().filter(modifier -> modifier.hasCategory(VaultGearModifier.AffixCategory.LEGENDARY)).findFirst();
                    }
                    if (firstLegendaryModifier.isEmpty()) {
                        output.m_41764_(0);
                        return;
                    }
                    VaultGearModifier modifier2 = firstLegendaryModifier.get();
                    Optional<VaultGearTierConfig> tierConfigOpt = VaultGearTierConfig.getConfig(input);
                    if (tierConfigOpt.isEmpty()) {
                        output.m_41764_(0);
                        return;
                    }
                    VaultGearTierConfig tierConfig = tierConfigOpt.get();
                    VaultGearTierConfig.ModifierTierGroup tierGroup = tierConfig.getTierGroup(modifier2.getModifierIdentifier());
                    if (tierGroup == null) {
                        output.m_41764_(0);
                        return;
                    }
                    String group = tierGroup.getTags().stream().map(tag -> ModConfigs.VAULT_GEAR_TAG_CONFIG.getTagNameContaining((String)tag)).filter(tagName -> tagName != null && !tagName.isEmpty()).findFirst().orElse(null);
                    if (group == null) {
                        output.m_41764_(0);
                        return;
                    }
                    firstLegendaryModifier.ifPresent(legendaryModifier -> ReforgeTagModificationFocus.setModifierTag(output, group));
                }
            }
        }

        public ItemStack getExtraOutput1Matching() {
            return this.extraOutput1.getMatchingStack();
        }

        public ItemStack generateExtraOutput2(ItemStack input, float additionalChance) {
            ItemStack out = DataTransferItem.doConvertStack(this.extraOutput2.adjustChance(additionalChance).createItemStack(Config.rand));
            this.adjustFocusItem(input, out);
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ItemStack generateExtraOutput2(ItemStack input, float additionalChance, VaultGearRarity rarity, boolean isCrafted, boolean isLegendary) {
            ItemStack out = DataTransferItem.doConvertStack(this.extraOutput2.adjustChance(additionalChance).createItemStack(Config.rand, rarity, isCrafted, isLegendary));
            this.adjustFocusItem(input, out);
            DataInitializationItem.doInitialize(out);
            return out;
        }

        public ItemStack getExtraOutput2Matching() {
            return this.extraOutput2.getMatchingStack();
        }

        public RecyclerOutput process(BiFunction<Integer, ItemStack, ItemStack> processor) {
            return new RecyclerOutput(new ChanceItemStackEntry(processor.apply(0, this.mainOutput.getMatchingStack()), this.mainOutput.getMinCount(), this.mainOutput.getMaxCount(), this.mainOutput.getChance()), new ConditionalChanceItemStackEntry(processor.apply(1, this.extraOutput1.getMatchingStack()), this.extraOutput1.getMinCount(), this.extraOutput1.getMaxCount(), this.extraOutput1.getChance()), new ConditionalChanceItemStackEntry(processor.apply(2, this.extraOutput2.getMatchingStack()), this.extraOutput2.getMinCount(), this.extraOutput2.getMaxCount(), this.extraOutput2.getChance()));
        }
    }
}

