/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.objective.scavenger.ChestScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.CoinStacksScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.MobScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.entity.boss.BossRuneModifiers;
import iskallia.vault.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.world.BossEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VaultRuneBossConfig
extends Config {
    @Expose
    private int maxFights = 1;
    @Expose
    private List<ScavengeTask> tasks;
    @Expose
    @SerializedName(value="Shield")
    private ShieldAbility shield;
    @Expose
    @SerializedName(value="WaveBlast")
    private WaveBlastAbility waveBlast;
    @Expose
    @SerializedName(value="Revive")
    private ReviveAbility revive;

    @Override
    public String getName() {
        return "vault_rune_boss";
    }

    public List<ScavengeTask> getTasks() {
        return this.tasks;
    }

    @Override
    protected void reset() {
        this.maxFights = 1;
        this.tasks = new ArrayList<ScavengeTask>();
        this.tasks.add(new ChestScavengerTask(TilePredicate.of("the_vault:wooden_chest", true).orElse(PartialTile.ERROR), 0.5, VaultMod.id("gui/scav/wooden_chest"), new WeightedList<ChestScavengerTask.Entry>().add(new ChestScavengerTask.Entry(new ItemStack((ItemLike)ModItems.BOSS_RUNE), 1.0, 0xFFFFFF), 8)));
        this.tasks.add(new ChestScavengerTask(TilePredicate.of("the_vault:living_chest", true).orElse(PartialTile.ERROR), 0.5, VaultMod.id("gui/scav/living_chest"), new WeightedList<ChestScavengerTask.Entry>().add(new ChestScavengerTask.Entry(new ItemStack((ItemLike)ModItems.BOSS_RUNE), 1.0, 0xFFFFFF), 8)));
        this.tasks.add(new CoinStacksScavengerTask(0.5, VaultMod.id("gui/scav/coin_stacks"), new WeightedList<CoinStacksScavengerTask.Entry>().add(new CoinStacksScavengerTask.Entry(new ItemStack((ItemLike)ModItems.BOSS_RUNE), 1.0, 0xFFFFFF), 8)));
        this.tasks.add(new MobScavengerTask(0.5, VaultMod.id("gui/scav/mob"), 0xFFFFFF, new MobScavengerTask.Entry(new ItemStack((ItemLike)ModItems.BOSS_RUNE), 1.0, List.of(EntityPredicate.of("@the_vault:mobs", true).orElseThrow()))));
        this.shield = new ShieldAbility();
        this.shield.enabled = true;
        this.shield.requiredRunes = 20;
        this.shield.cooldownTicks = 200;
        this.shield.durationTicks = 100;
        this.shield.bossBarColor = "WHITE";
        this.shield.particleRadius = 2.5f;
        this.shield.cooldownReductionPerHaste = 0.1;
        this.waveBlast = new WaveBlastAbility();
        this.waveBlast.enabled = true;
        this.waveBlast.requiredRunes = 40;
        this.waveBlast.cooldownTicks = 220;
        this.waveBlast.radius = 30.0f;
        this.waveBlast.damageMultiplier = 1.0f;
        this.waveBlast.cooldownReductionPerHaste = 0.1;
        this.waveBlast.knockbackStrength = 0.45f;
        this.revive = new ReviveAbility();
        this.revive.enabled = true;
        this.revive.requiredRunes = 60;
        this.revive.additionalRunesPerStack = 20;
        this.revive.maxStacks = 0;
        this.revive.healthPercent = 1.0f;
        this.revive.invulnerabilityTicks = 60;
    }

    public Optional<BossRuneModifiers.ShieldAbilitySettings> getShieldSettings(int runeCount) {
        if (this.shield == null || !this.shield.enabled || runeCount < this.shield.requiredRunes) {
            return Optional.empty();
        }
        return Optional.of(new BossRuneModifiers.ShieldAbilitySettings(this.shield.cooldownTicks, this.shield.durationTicks, this.parseColor(this.shield.bossBarColor), this.shield.particleRadius, this.shield.cooldownReductionPerHaste));
    }

    private BossEvent.BossBarColor parseColor(String value) {
        try {
            return BossEvent.BossBarColor.valueOf((String)value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return BossEvent.BossBarColor.WHITE;
        }
    }

    public Optional<BossRuneModifiers.WaveBlastAbilitySettings> getWaveBlastSettings(int runeCount) {
        if (this.waveBlast == null || !this.waveBlast.enabled || runeCount < this.waveBlast.requiredRunes) {
            return Optional.empty();
        }
        return Optional.of(new BossRuneModifiers.WaveBlastAbilitySettings(this.waveBlast.cooldownTicks, this.waveBlast.radius, this.waveBlast.damageMultiplier, this.waveBlast.cooldownReductionPerHaste, this.waveBlast.knockbackStrength));
    }

    public Optional<BossRuneModifiers.ReviveAbilitySettings> getReviveSettings(int runeCount) {
        if (this.revive == null || !this.revive.enabled || runeCount < this.revive.requiredRunes) {
            return Optional.empty();
        }
        int stacks = 1 + (runeCount - this.revive.requiredRunes) / Math.max(1, this.revive.additionalRunesPerStack);
        if (this.revive.maxStacks > 0) {
            stacks = Math.min(stacks, this.revive.maxStacks);
        }
        if (stacks <= 0) {
            return Optional.empty();
        }
        return Optional.of(new BossRuneModifiers.ReviveAbilitySettings(stacks, this.revive.healthPercent, this.revive.invulnerabilityTicks));
    }

    public int getMaxFights() {
        return this.maxFights;
    }

    private static class ShieldAbility {
        @Expose
        @SerializedName(value="Enabled")
        private boolean enabled;
        @Expose
        @SerializedName(value="RequiredRunes")
        private int requiredRunes;
        @Expose
        @SerializedName(value="CooldownTicks")
        private int cooldownTicks;
        @Expose
        @SerializedName(value="DurationTicks")
        private int durationTicks;
        @Expose
        @SerializedName(value="BossBarColor")
        private String bossBarColor;
        @Expose
        @SerializedName(value="ParticleRadius")
        private float particleRadius;
        @Expose
        @SerializedName(value="CooldownReductionPerHaste")
        private double cooldownReductionPerHaste;

        private ShieldAbility() {
        }
    }

    private static class WaveBlastAbility {
        @Expose
        @SerializedName(value="Enabled")
        private boolean enabled;
        @Expose
        @SerializedName(value="RequiredRunes")
        private int requiredRunes;
        @Expose
        @SerializedName(value="CooldownTicks")
        private int cooldownTicks;
        @Expose
        @SerializedName(value="Radius")
        private float radius;
        @Expose
        @SerializedName(value="DamageMultiplier")
        private float damageMultiplier;
        @Expose
        @SerializedName(value="CooldownReductionPerHaste")
        private double cooldownReductionPerHaste;
        @Expose
        @SerializedName(value="KnockbackStrength")
        private float knockbackStrength;

        private WaveBlastAbility() {
        }
    }

    private static class ReviveAbility {
        @Expose
        @SerializedName(value="Enabled")
        private boolean enabled;
        @Expose
        @SerializedName(value="RequiredRunes")
        private int requiredRunes;
        @Expose
        @SerializedName(value="AdditionalRunesPerStack")
        private int additionalRunesPerStack;
        @Expose
        @SerializedName(value="MaxStacks")
        private int maxStacks;
        @Expose
        @SerializedName(value="HealthPercent")
        private float healthPercent;
        @Expose
        @SerializedName(value="InvulnerabilityTicks")
        private int invulnerabilityTicks;

        private ReviveAbility() {
        }
    }
}

