/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.vault.VaultRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class VoidCrucibleConfig
extends Config {
    @Expose
    private List<ResourceLocation> themes;
    @Expose
    private List<ResourceLocation> allowedBlocks;

    @Override
    public String getName() {
        return "void_crucible";
    }

    @Override
    protected void reset() {
        this.themes = new ArrayList<ResourceLocation>(){
            {
                this.add(VaultMod.id("classic_vault_plastic"));
                this.add(VaultMod.id("classic_vault_ice"));
                this.add(VaultMod.id("classic_vault_ice_cave"));
            }
        };
        this.allowedBlocks = new ArrayList<ResourceLocation>();
    }

    public List<ResourceLocation> getThemes() {
        return this.themes;
    }

    public List<ResourceLocation> getAllowedBlocks() {
        return this.allowedBlocks == null ? new ArrayList() : this.allowedBlocks;
    }

    public List<ThemeKey> getThemeKeys() {
        ArrayList<ThemeKey> themeKeys = new ArrayList<ThemeKey>();
        for (ResourceLocation theme : this.themes) {
            ThemeKey key = VaultRegistry.THEME.getKey(theme);
            if (key == null) {
                VaultMod.LOGGER.warn("Failed to find ThemeKey for theme: {}", (Object)theme);
                continue;
            }
            themeKeys.add(key);
        }
        return themeKeys;
    }
}

