/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.init.ModDynamicModels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class VoidStoneConfig
extends Config {
    @Expose
    private Map<VaultGearRarity, IntRoll> usesRoll;
    @Expose
    Map<VaultGearRarity, List<ResourceLocation>> RARITY_MODEL_ROLLS;
    @Expose
    private boolean useRarityModelRolls = false;
    @Expose
    private List<ResourceLocation> MODELS;

    @Override
    public String getName() {
        return "void_stone";
    }

    @Override
    protected void reset() {
        this.usesRoll = new HashMap<VaultGearRarity, IntRoll>(){
            {
                this.put(VaultGearRarity.SCRAPPY, IntRoll.ofUniform(7, 8));
                this.put(VaultGearRarity.RARE, IntRoll.ofUniform(7, 10));
                this.put(VaultGearRarity.EPIC, IntRoll.ofUniform(7, 12));
                this.put(VaultGearRarity.OMEGA, IntRoll.ofUniform(7, 20));
                this.put(VaultGearRarity.UNIQUE, IntRoll.ofUniform(7, 8));
            }
        };
        this.useRarityModelRolls = false;
        this.MODELS = new ArrayList<ResourceLocation>(){
            {
                this.addAll(ModDynamicModels.VoidStones.REGISTRY_VOID_STONES.getIds().stream().toList());
            }
        };
        this.RARITY_MODEL_ROLLS = new HashMap<VaultGearRarity, List<ResourceLocation>>(){
            {
                for (VaultGearRarity gearRarity : VaultGearRarity.values()) {
                    this.put(gearRarity, List.of(ModDynamicModels.VoidStones.VOIDSTONE_01.getId()));
                }
            }
        };
    }

    public IntRoll getUsesRoll(VaultGearRarity rarity) {
        return this.usesRoll.get((Object)rarity);
    }

    public int getUses(VaultGearRarity rarity, RandomSource source) {
        if (!this.usesRoll.containsKey((Object)rarity)) {
            return 10;
        }
        return this.usesRoll.get((Object)rarity).get(source);
    }

    public ResourceLocation getRandomModel(@Nullable VaultGearRarity rarity, Random source) {
        if (!this.useRarityModelRolls) {
            return this.MODELS.get(source.nextInt(this.MODELS.size()));
        }
        if (rarity == null) {
            return this.MODELS.get(source.nextInt(this.MODELS.size()));
        }
        List<ResourceLocation> rarityModels = this.RARITY_MODEL_ROLLS.get((Object)rarity);
        return rarityModels.get(source.nextInt(rarityModels.size()));
    }
}

