/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.bounty;

import com.google.gson.annotations.Expose;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.IntRangeEntry;
import iskallia.vault.config.entry.ItemStackPool;
import iskallia.vault.config.entry.LevelEntryMap;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.util.LootInitialization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class RewardConfig
extends Config {
    @Expose
    public HashMap<String, LevelEntryMap<RewardEntry>> POOLS = new HashMap();

    @Override
    public String getName() {
        return "bounty/rewards";
    }

    public HashMap<String, LevelEntryMap<RewardEntry>> getPOOLS() {
        return this.POOLS;
    }

    @Override
    protected void reset() {
        this.resetLevels("common");
        this.resetLevels("rare");
        this.resetLevels("epic");
        this.resetLevels("omega");
    }

    private void resetLevels(String poolId) {
        LevelEntryMap entryMap = new LevelEntryMap();
        for (int i = 0; i < 30; i += 10) {
            ItemStackPool pool = new ItemStackPool(1, 10);
            pool.addItemStack(new ItemStack((ItemLike)Items.f_42398_), 1, 32);
            pool.addItemStack(new ItemStack((ItemLike)Items.f_42410_), 1, 32);
            ItemStack sword = new ItemStack((ItemLike)Items.f_42425_);
            EnchantmentHelper.m_44877_((Random)rand, (ItemStack)sword, (int)(i + 10), (boolean)true);
            pool.addItemStack(sword, 1);
            entryMap.put(i, new RewardEntry(new IntRangeEntry(1, 2), pool, new ArrayList<ResourceLocation>()));
        }
        this.POOLS.put(poolId, entryMap);
    }

    public TaskReward generateReward(int vaultLevel, String poolId) {
        LevelEntryMap<RewardEntry> entryMap = this.POOLS.get(poolId);
        Optional<RewardEntry> entry = entryMap.getForLevel(vaultLevel);
        if (entry.isEmpty()) {
            throw new IllegalArgumentException("No Reward Entry found for level: " + vaultLevel);
        }
        RewardEntry rewardEntry = entry.get();
        int vaultExp = rewardEntry.vaultExp.getRandom();
        List<ResourceLocation> discoverModels = rewardEntry.discoverModels;
        ArrayList<OverSizedItemStack> items = new ArrayList<OverSizedItemStack>();
        for (ItemStack reward : rewardEntry.itemPool.getRandomStacks()) {
            reward = LootInitialization.initializeVaultLoot(reward, vaultLevel);
            items.add(OverSizedItemStack.of(reward));
        }
        return new TaskReward(vaultExp, items, discoverModels);
    }

    public static class RewardEntry {
        @Expose
        public IntRangeEntry vaultExp;
        @Expose
        public ItemStackPool itemPool;
        @Expose
        public List<ResourceLocation> discoverModels;

        public ItemStackPool getItemPool() {
            return this.itemPool;
        }

        public RewardEntry(IntRangeEntry vaultExp, ItemStackPool itemPool) {
            this.vaultExp = vaultExp;
            this.itemPool = itemPool;
            this.discoverModels = new ArrayList<ResourceLocation>();
        }

        public RewardEntry(IntRangeEntry vaultExp, ItemStackPool itemPool, List<ResourceLocation> discoverModels) {
            this.vaultExp = vaultExp;
            this.itemPool = itemPool;
            this.discoverModels = discoverModels;
        }
    }
}

