/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.card;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.modifier.card.GearCardModifier;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.init.ModGearAttributes;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class CardModifiersConfig
extends Config {
    @Expose
    private Map<String, CardEntry.Config> values;
    @Expose
    private Map<String, WeightedList<String>> pools;

    public Map<String, WeightedList<String>> getPools() {
        return this.pools;
    }

    public Map<String, CardEntry.Config> getValues() {
        return this.values;
    }

    @Override
    public String getName() {
        return "card%smodifiers".formatted(File.separator);
    }

    public Collection<CardEntry.Config> getEntries() {
        return this.values.values();
    }

    public Optional<CardEntry.Config> getRandom(String id, RandomSource random) {
        if (id.startsWith("@")) {
            WeightedList<String> pool = this.pools.get(id.substring(1));
            if (pool == null) {
                return Optional.empty();
            }
            return pool.getRandom(random).flatMap(s -> this.getRandom((String)s, random));
        }
        return Optional.ofNullable(this.values.get(id)).map(CardEntry.Config::copy);
    }

    public Map<String, CardEntry.Config> getAll(String id) {
        if (id.startsWith("@")) {
            WeightedList<String> pool = this.pools.get(id.substring(1));
            if (pool == null) {
                HashMap<String, CardEntry.Config> cfg = new HashMap<String, CardEntry.Config>();
                cfg.put(id, null);
                return cfg;
            }
            HashMap<String, CardEntry.Config> cfg = new HashMap<String, CardEntry.Config>();
            pool.keySet().forEach(poolEntryId -> cfg.putAll(this.getAll((String)poolEntryId)));
            return cfg;
        }
        HashMap<String, CardEntry.Config> cfg = new HashMap<String, CardEntry.Config>();
        cfg.put(id, this.values.getOrDefault(id, null));
        return cfg;
    }

    @Override
    protected void reset() {
        this.values = new LinkedHashMap<String, CardEntry.Config>();
        this.pools = new LinkedHashMap<String, WeightedList<String>>();
        this.values.put("attack_damage", new CardEntry.Config((Component)new TextComponent("Attack Damage Card"), Set.of(), Set.of("Stat", "Offense"), "the_vault:card/icon/attack_damage#inventory", new GearCardModifier<Double>(new GearCardModifier.Config<Double>(ModGearAttributes.ATTACK_DAMAGE, (Map<Integer, String>)new LinkedHashMap<Integer, String>(){
            {
                this.put(1, "{ \"min\": 2.0, \"max\": 6.0, \"step\": 0.5 }");
                this.put(2, "{ \"min\": 7.0, \"max\": 12.0, \"step\": 0.5 }");
                this.put(3, "{ \"min\": 13.0, \"max\": 18.0, \"step\": 0.5 }");
                this.put(4, "{ \"min\": 19.0, \"max\": 27.0, \"step\": 0.5 }");
                this.put(5, "{ \"min\": 28.0, \"max\": 35.0, \"step\": 0.5 }");
            }
        })), null, null));
        this.values.put("health", new CardEntry.Config((Component)new TextComponent("Health Card"), Set.of(), Set.of("Stat", "Defense"), "the_vault:card/icon/health#inventory", new GearCardModifier<Float>(new GearCardModifier.Config<Float>(ModGearAttributes.HEALTH, (Map<Integer, String>)new LinkedHashMap<Integer, String>(){
            {
                this.put(1, "{ \"min\": 1.0, \"max\": 2.0, \"step\": 1.0 }");
                this.put(2, "{ \"min\": 3.0, \"max\": 4.0, \"step\": 1.0 }");
                this.put(3, "{ \"min\": 5.0, \"max\": 6.0, \"step\": 1.0 }");
                this.put(4, "{ \"min\": 7.0, \"max\": 8.0, \"step\": 1.0 }");
                this.put(5, "{ \"min\": 9.0, \"max\": 10.0, \"step\": 1.0 }");
            }
        })), null, null));
        this.pools.put("default", new WeightedList<String>().add("attack_damage", 1.0).add("health", 1.0));
    }
}

