/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.card;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.modifier.deck.DeckModifier;
import iskallia.vault.core.card.modifier.deck.DummyDeckModifier;
import iskallia.vault.core.card.modifier.deck.GlobalDeckModifier;
import iskallia.vault.core.card.modifier.deck.SlotDeckModifier;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.roll.FloatRoll;
import iskallia.vault.core.world.roll.IntRoll;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DeckModifiersConfig
extends Config {
    @Expose
    private Map<String, DeckModifier<?>> values = new LinkedHashMap();
    @Expose
    private Map<String, Pool> pools = new LinkedHashMap<String, Pool>();
    @Expose
    private float modifierChance;

    public Map<String, Pool> getPools() {
        return this.pools;
    }

    public Map<String, DeckModifier<?>> getValues() {
        return this.values;
    }

    @Override
    public String getName() {
        return "card%sdeck_modifiers".formatted(File.separator);
    }

    public Optional<DeckModifier<?>> getRandom(String id, RandomSource random) {
        if (id.startsWith("@")) {
            WeightedList<String> pool = this.pools.get((Object)id.substring((int)1)).pool;
            if (pool == null) {
                return Optional.empty();
            }
            return pool.getRandom(random).flatMap(s -> this.getRandom((String)s, random));
        }
        return Optional.ofNullable(this.values.get(id));
    }

    public Optional<Integer> getModifierCount(String id, RandomSource random) {
        if (id.startsWith("@")) {
            return Optional.of(this.pools.get((Object)id.substring((int)1)).modifierCount.get(random));
        }
        return Optional.empty();
    }

    public float getModifierChance() {
        return this.modifierChance;
    }

    @Override
    protected void reset() {
        this.values = new LinkedHashMap();
        this.pools = new LinkedHashMap<String, Pool>();
        this.modifierChance = 0.2f;
        GlobalDeckModifier.Config foilConfig = new GlobalDeckModifier.Config();
        foilConfig.modifierRoll = FloatRoll.ofUniform(0.15f, 0.45f);
        foilConfig.requiredGroups = Set.of("Foil");
        this.values.put("foil_boost", new GlobalDeckModifier(foilConfig));
        GlobalDeckModifier.Config redConfig = new GlobalDeckModifier.Config();
        redConfig.modifierRoll = FloatRoll.ofUniform(0.5f, 1.0f);
        redConfig.requiredColors = Set.of(CardEntry.Color.RED);
        this.values.put("red_boost", new GlobalDeckModifier(redConfig));
        SlotDeckModifier.Config blueSlotConfig = new SlotDeckModifier.Config();
        blueSlotConfig.modifierRoll = FloatRoll.ofUniform(0.5f, 0.75f);
        blueSlotConfig.requiredColors = Set.of(CardEntry.Color.BLUE);
        blueSlotConfig.requiredGroups = Set.of();
        this.values.put("blue_slot_boost", new SlotDeckModifier(blueSlotConfig));
        SlotDeckModifier.Config greenFoilSlotConfig = new SlotDeckModifier.Config();
        greenFoilSlotConfig.modifierRoll = FloatRoll.ofUniform(0.5f, 0.75f);
        greenFoilSlotConfig.requiredColors = Set.of(CardEntry.Color.GREEN);
        greenFoilSlotConfig.requiredGroups = Set.of("Foil");
        this.values.put("green_foil_slot_boost", new SlotDeckModifier(greenFoilSlotConfig));
        this.values.put("dummy", new DummyDeckModifier());
        this.pools.put("default", new Pool(IntRoll.ofUniform(1, 2), new WeightedList<String>().add("foil_boost", 1.0).add("red_boost", 1.0).add("blue_slot_boost", 1.0).add("green_foil_slot_boost", 1.0).add("dummy", 96.0)));
    }

    public static class Pool {
        @Expose
        private final IntRoll modifierCount;
        @Expose
        private final WeightedList<String> pool;

        public Pool(IntRoll modifierCount, WeightedList<String> pool) {
            this.modifierCount = modifierCount;
            this.pool = pool;
        }
    }
}

