/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.crucible;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VoidCrucibleCustomItemConfig
extends Config {
    @Expose
    private Map<String, CustomItem> items = new HashMap<String, CustomItem>();

    @Override
    public String getName() {
        return "void_crucible%s".formatted(File.separator);
    }

    @Override
    protected void reset() {
        this.items.clear();
    }

    @Override
    public File getConfigFile() {
        return new File(this.root + this.getName());
    }

    public Map<String, CustomItem> getItems() {
        return this.items;
    }

    public boolean hasItems(ResourceLocation id) {
        return this.items.containsKey(id.m_135815_());
    }

    public Map<? extends ResourceLocation, @NotNull String> getMappedDisplay() {
        HashMap<ResourceLocation, String> displayMap = new HashMap<ResourceLocation, String>();
        for (Map.Entry<String, CustomItem> entry : this.items.entrySet()) {
            String id = entry.getKey();
            CustomItem item = entry.getValue();
            displayMap.put(VaultMod.id(id), item.getDisplayName());
        }
        return displayMap;
    }

    public List<ResourceLocation> getAllItems() {
        return this.items.values().stream().map(CustomItem::getResources).flatMap(Collection::stream).toList();
    }

    @Override
    public <T extends Config> T readConfig() {
        VaultMod.LOGGER.info("Reading void crucible configs");
        File dir = this.getConfigFile();
        if (!dir.exists() && !dir.mkdirs()) {
            VaultMod.LOGGER.error("Failed to create directory: " + String.valueOf(dir));
            return (T)this;
        }
        File[] files = dir.listFiles((d, name) -> name.endsWith(".json"));
        if (files == null) {
            return (T)this;
        }
        for (File file : files) {
            try (FileReader reader = new FileReader(file);){
                String id = file.getName().replace(".json", "");
                CustomItem item = (CustomItem)Config.GSON.fromJson((Reader)reader, CustomItem.class);
                if (item != null) {
                    this.items.put(id, item);
                }
                VaultMod.LOGGER.info("Read void crucible config: " + file.getName());
            }
            catch (Exception e) {
                VaultMod.LOGGER.error("Failed to read void crucible config: " + file.getName(), (Throwable)e);
            }
        }
        return (T)this;
    }

    public static class CustomItem {
        @Expose
        private String displayName;
        @Expose
        private List<ResourceLocation> resources = new ArrayList<ResourceLocation>();

        public String getDisplayName() {
            return this.displayName;
        }

        public List<ResourceLocation> getResources() {
            return this.resources;
        }
    }
}

