/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config.entry;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.entry.ChanceItemStackEntry;
import iskallia.vault.gear.VaultGearRarity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.world.item.ItemStack;

public class ConditionalChanceItemStackEntry
extends ChanceItemStackEntry {
    @Expose
    private final Map<Condition, ChanceItemStackEntry> conditionalOutputs;

    public ConditionalChanceItemStackEntry(ItemStack stack, int min, int max, float chance) {
        super(stack, min, max, chance);
        this.conditionalOutputs = new HashMap<Condition, ChanceItemStackEntry>();
    }

    public ConditionalChanceItemStackEntry(ChanceItemStackEntry defaultOutput) {
        super(defaultOutput.getMatchingStack(), defaultOutput.getMinCount(), defaultOutput.getMaxCount(), defaultOutput.getChance());
        this.conditionalOutputs = new HashMap<Condition, ChanceItemStackEntry>();
    }

    public ConditionalChanceItemStackEntry(ChanceItemStackEntry defaultOutput, Map<Condition, ChanceItemStackEntry> conditionalOutputs) {
        super(defaultOutput.getMatchingStack(), defaultOutput.getMinCount(), defaultOutput.getMaxCount(), defaultOutput.getChance());
        this.conditionalOutputs = conditionalOutputs;
    }

    public ConditionalChanceItemStackEntry addCondition(Condition condition, ChanceItemStackEntry output) {
        HashMap<Condition, ChanceItemStackEntry> newConditions = new HashMap<Condition, ChanceItemStackEntry>(this.conditionalOutputs);
        newConditions.put(condition, output);
        return new ConditionalChanceItemStackEntry(this, newConditions);
    }

    public ChanceItemStackEntry getDefaultOutput() {
        return this;
    }

    public Map<Condition, ChanceItemStackEntry> getConditionalOutputs() {
        return Collections.unmodifiableMap(this.conditionalOutputs);
    }

    @Override
    public ItemStack createItemStack(Random rand) {
        if (rand.nextFloat() >= this.getChance()) {
            return ItemStack.f_41583_;
        }
        return super.createItemStack(rand);
    }

    @Override
    public ConditionalChanceItemStackEntry adjustChance(float chance) {
        return new ConditionalChanceItemStackEntry(super.adjustChance(chance), this.conditionalOutputs);
    }

    public ItemStack createItemStack(Random rand, VaultGearRarity rarity, boolean isCrafted, boolean isLegendary) {
        if (this.conditionalOutputs == null) {
            VaultMod.LOGGER.error("A critical error occurred and your item was not generated to prevent a server crash. One of your configs is wrong, likely your recycler!");
            return super.createItemStack(rand);
        }
        for (Map.Entry<Condition, ChanceItemStackEntry> entry : this.conditionalOutputs.entrySet()) {
            if (!entry.getKey().matches(rarity, isCrafted, isLegendary)) continue;
            if (rand.nextFloat() >= entry.getValue().getChance()) {
                return ItemStack.f_41583_;
            }
            return entry.getValue().createItemStackIgnoreChance(rand);
        }
        return super.createItemStack(rand);
    }

    public static class Condition {
        @Expose
        private final VaultGearRarity rarity;
        @Expose
        private final Boolean isCrafted;
        @Expose
        private final Boolean isLegendary;

        public Condition(VaultGearRarity rarity, Boolean isCrafted, Boolean isLegendary) {
            this.rarity = rarity;
            this.isCrafted = isCrafted;
            this.isLegendary = isLegendary;
        }

        public static Condition forRarity(VaultGearRarity rarity) {
            return new Condition(rarity, null, null);
        }

        public static Condition forCrafted(boolean isCrafted) {
            return new Condition(null, isCrafted, null);
        }

        public static Condition forLegendary(boolean isLegendary) {
            return new Condition(null, null, isLegendary);
        }

        public static Condition forAll(VaultGearRarity rarity, boolean isCrafted, Boolean isLegendary) {
            return new Condition(rarity, isCrafted, isLegendary);
        }

        public boolean matches(VaultGearRarity rarity, boolean isCrafted, boolean isLegendary) {
            boolean rarityMatches = this.rarity == null || this.rarity == rarity;
            boolean craftedMatches = this.isCrafted == null || this.isCrafted == isCrafted;
            boolean legendaryMatches = this.isLegendary == null || this.isLegendary == isLegendary;
            return rarityMatches && craftedMatches && legendaryMatches;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Condition condition = (Condition)o;
            return Objects.equals((Object)this.rarity, (Object)condition.rarity) && Objects.equals(this.isCrafted, condition.isCrafted) && Objects.equals(this.isLegendary, condition.isLegendary);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.rarity, this.isCrafted, this.isLegendary});
        }
    }
}

